/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.html.editor.indexing.HtmlFileModel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HtmlIndexer
extends EmbeddingIndexer {
    private static final Logger LOGGER = Logger.getLogger(HtmlIndexer.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    static final String REFERS_KEY = "imports";

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            HtmlFileModel model;
            if (LOG) {
                FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
                LOGGER.log(Level.FINE, "indexing " + fo.getPath());
            }
            if (!(model = new HtmlFileModel((HtmlParserResult)parserResult)).isEmpty()) {
                IndexingSupport support = IndexingSupport.getInstance((Context)context);
                IndexDocument document = support.createDocument(indexable);
                this.storeEntries(model.getReferences(), document, REFERS_KEY);
                support.addDocument(document);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void storeEntries(Collection<? extends Entry> entries, IndexDocument doc, String key) {
        if (!entries.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator<? extends Entry> i = entries.iterator();
            while (i.hasNext()) {
                sb.append(i.next().getName());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(';');
            doc.addPair(key, sb.toString(), true, true);
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "html";
        static final int VERSION = 1;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new HtmlIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        private boolean isIndexable(Snapshot snapshot) {
            return "text/html".equals(snapshot.getMimeType());
        }
    }
}

