/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.html.editor.codegen.LoremIpsumPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoremIpsumGenerator
implements CodeGenerator {
    JTextComponent textComp;

    private LoremIpsumGenerator(Lookup context) {
        this.textComp = (JTextComponent)context.lookup(JTextComponent.class);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_lorem_ipsum");
    }

    private static List<String> completeParagraphList() {
        ArrayList<String> paragraphs = new ArrayList<String>();
        for (int paragraphNumber = 1; paragraphNumber <= 10; ++paragraphNumber) {
            paragraphs.add(NbBundle.getMessage(LoremIpsumGenerator.class, (String)("lorem_ipsum_paragraph_" + paragraphNumber)));
        }
        return paragraphs;
    }

    public void invoke() {
        int caretOffset = this.textComp.getCaretPosition();
        LoremIpsumPanel panel = new LoremIpsumPanel(LoremIpsumGenerator.completeParagraphList());
        String title = NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_generate_lorem_ipsum");
        DialogDescriptor dialogDescriptor = LoremIpsumGenerator.createDialogDescriptor(panel, title);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue()) {
            BaseDocument document = (BaseDocument)this.textComp.getDocument();
            try {
                LoremIpsumGenerator.insertLoremIpsum(document, panel.getParagraphs(), panel.getTag(), this.getIndentSize((Document)document), caretOffset);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void insertLoremIpsum(BaseDocument document, List<String> paragraphs, String tag, CharSequence indent, int caretOffset) throws BadLocationException {
        boolean insertAfterIndent;
        StringBuilder insertText = new StringBuilder();
        CharSequence indentText = LoremIpsumGenerator.findIndent(document, caretOffset, indent);
        boolean insertAtEndOfLine = LoremIpsumGenerator.isLineCharacter(document.getChars(caretOffset, 1)[0]);
        boolean bl = insertAfterIndent = caretOffset > 0 ? LoremIpsumGenerator.isIndentCharacter(document.getChars(caretOffset - 1, 1)[0]) : true;
        if (!insertAfterIndent) {
            insertText.append('\n');
        }
        String closeTag = tag.replaceFirst("<", "</");
        for (String paragraph : paragraphs) {
            insertText.append(indentText).append(tag).append("\n");
            insertText.append(indentText).append(indent).append(paragraph).append("\n");
            insertText.append(indentText).append(closeTag).append("\n");
        }
        if (insertAtEndOfLine) {
            insertText.setLength(insertText.length() - 1);
        }
        if (insertAfterIndent) {
            while (LoremIpsumGenerator.isIndentCharacter(document.getChars(caretOffset - 1, 1)[0])) {
                --caretOffset;
            }
        }
        document.insertString(caretOffset, insertText.toString(), null);
    }

    private static boolean isLineCharacter(char c) {
        return c == '\n' || c == '\r';
    }

    private CharSequence getIndentSize(Document document) {
        StringBuilder indentation = new StringBuilder();
        if (IndentUtils.isExpandTabs((Document)document)) {
            int spacesInIndent = IndentUtils.indentLevelSize((Document)document);
            for (int i = 0; i < spacesInIndent; ++i) {
                indentation.append(' ');
            }
        } else {
            indentation.append('\t');
        }
        return indentation;
    }

    private static boolean isIndentCharacter(char c) {
        return Character.isWhitespace(c) && !LoremIpsumGenerator.isLineCharacter(c);
    }

    private static boolean isIndentCharacter(CharSequence tokenText, int index) {
        if (index >= tokenText.length()) {
            return false;
        }
        char c = tokenText.charAt(index);
        return LoremIpsumGenerator.isIndentCharacter(c);
    }

    private static CharSequence findIndent(BaseDocument document, int caretOffset, CharSequence indent) {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)document, (int)caretOffset, (Language)HTMLTokenId.language());
        while (ts.moveNext() && ts.offset() <= caretOffset) {
        }
        boolean firstToken = true;
        int nestingCount = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            HTMLTokenId id = (HTMLTokenId)token.id();
            if (HTMLTokenId.TAG_OPEN.equals((Object)id)) {
                ++nestingCount;
            } else if (HTMLTokenId.TAG_CLOSE.equals((Object)id)) {
                --nestingCount;
            } else if (HTMLTokenId.TAG_CLOSE_SYMBOL.equals((Object)id)) {
                if ("/>".equals(((Object)token.text()).toString())) {
                    --nestingCount;
                }
            } else if (HTMLTokenId.TEXT.equals((Object)id) || HTMLTokenId.WS.equals((Object)id)) {
                int nonWhitespaceIndex;
                CharSequence tokenText = token.text();
                char indexedChar = tokenText.charAt(nonWhitespaceIndex = firstToken ? caretOffset - ts.offset() : tokenText.length() - 1);
                if (LoremIpsumGenerator.isLineCharacter(indexedChar)) {
                    // empty if block
                }
                for (int index = --nonWhitespaceIndex; index >= 0; --index) {
                    indexedChar = tokenText.charAt(index);
                    if (LoremIpsumGenerator.isLineCharacter(indexedChar)) {
                        if (nonWhitespaceIndex == 0) {
                            return "";
                        }
                        if (firstToken) {
                            while (LoremIpsumGenerator.isIndentCharacter(tokenText, nonWhitespaceIndex)) {
                                ++nonWhitespaceIndex;
                            }
                            return tokenText.subSequence(index + 1, nonWhitespaceIndex);
                        }
                        String indentText = ((Object)tokenText.subSequence(index + 1, nonWhitespaceIndex + 1)).toString();
                        if (nestingCount > 0) {
                            indentText = indentText + indent;
                        } else if (nestingCount < 0 && indentText.length() >= indent.length()) {
                            boolean outdent = true;
                            char indentCharacter = indent.charAt(0);
                            for (char c : indentText.toCharArray()) {
                                outdent = outdent && c == indentCharacter;
                            }
                            if (outdent) {
                                indentText = indentText.substring(0, indentText.length() - indent.length());
                            }
                        }
                        return indentText;
                    }
                    if (LoremIpsumGenerator.isIndentCharacter(indexedChar)) continue;
                    nonWhitespaceIndex = index;
                }
            }
            firstToken = false;
        }
        return "";
    }

    private static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            return Collections.singletonList(new LoremIpsumGenerator(context));
        }
    }
}

