/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.deploy;

import com.nokia.phone.deploy.CONA;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Deployer {
    private boolean connected = false;

    public Deployer() {
        this.openConnectionLayer();
        if (!this.connected) {
            // empty if block
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isPCSuiteInstalled() {
        return CONA.getInstance().isConnAPIDllFound();
    }

    public boolean isOSSupportsDeployment() {
        return CONA.getInstance().isOSSupportsDeployment();
    }

    public void openConnectionLayer() {
        if (CONA.getInstance().isConnAPIDllFound() && CONA.getInstance().isConnJNIDllFound() && !this.connected) {
            this.connected = CONA.getInstance().connect();
        }
    }

    public void closeConnectionLayer() {
        try {
            Thread.sleep(3050L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.connected) {
            boolean disconnected = CONA.getInstance().disconnect();
            if (!disconnected) {
                System.err.println("Failed to close service layer");
            }
            this.connected = !disconnected;
        }
    }

    public List<String> getTerminals() {
        ArrayList<String> terminalList = new ArrayList<String>();
        if (!this.connected) {
            this.openConnectionLayer();
        }
        if (!this.connected) {
            System.err.println("Connection opening failed, could not get terminal list.");
            return terminalList;
        }
        this.addDevicesToList(CONA.getInstance().getDevices(8), terminalList);
        this.addDevicesToList(CONA.getInstance().getDevices(2), terminalList);
        this.addDevicesToList(CONA.getInstance().getDevices(4), terminalList);
        this.addDevicesToList(CONA.getInstance().getDevices(16), terminalList);
        return terminalList;
    }

    public String getConnectionType(String terminal) {
        if (!this.connected) {
            this.openConnectionLayer();
        }
        int id = this.getID(terminal);
        return CONA.getInstance().getDeviceType(id);
    }

    public List<String> deployToAllTerminals(File jad, File jar) {
        List<String> allTerminals = this.getTerminals();
        ArrayList<String> notOk = new ArrayList<String>();
        for (String terminal : allTerminals) {
            try {
                boolean success = this.deploy(jad, jar, terminal);
                if (success) {
                    System.out.println("Deployment succeeded!");
                    continue;
                }
                notOk.add(terminal);
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                notOk.add(terminal);
            }
            catch (IOException e) {
                e.printStackTrace();
                notOk.add(terminal);
            }
        }
        return notOk;
    }

    public boolean deploy(File jad, File jar, String terminal) throws IOException, UnsatisfiedLinkError {
        if (!CONA.getInstance().isConnAPIDllFound()) {
            throw new UnsatisfiedLinkError("Failed to open ConnAPI.dll");
        }
        if (!CONA.getInstance().isConnJNIDllFound()) {
            throw new UnsatisfiedLinkError("Failed to open ConnJNI.dll");
        }
        if (!this.connected) {
            this.openConnectionLayer();
            if (!this.connected) {
                System.err.println("Failed to open service layer");
                return false;
            }
            System.out.println("Service layer opened");
        }
        int id = this.getID(terminal);
        if (!jad.exists()) {
            throw new IOException("JAD file not found:" + jad.getAbsolutePath());
        }
        if (!jar.exists()) {
            throw new IOException("JAR file not found:" + jar.getAbsolutePath());
        }
        if (id != -1) {
            return this.synchronizedDeploy(jad, jar, id);
        }
        System.err.println("Failed to find destination device:" + terminal);
        return false;
    }

    private boolean openConnection(int ind) {
        boolean openC = CONA.getInstance().openFileSystem(ind);
        return openC;
    }

    private boolean closeConnection() {
        return CONA.getInstance().closeFileSystem();
    }

    private void addDevicesToList(String devices, List<String> list) {
        if (devices == null) {
            return;
        }
        StringTokenizer devicesTokenizer = new StringTokenizer(devices, ",");
        while (devicesTokenizer.hasMoreTokens()) {
            list.add(devicesTokenizer.nextToken());
        }
    }

    private int getID(String terminal) {
        String idString = terminal.substring(terminal.indexOf("(ID:") + 4, terminal.indexOf(")")).trim();
        return Integer.parseInt(idString);
    }

    private boolean synchronizedDeploy(File jad, File jar, int id) {
        boolean success = true;
        String jarfilepath = jar.getParentFile().getAbsolutePath();
        String jadfilename = jad.getName();
        String jarfilename = jar.getName();
        boolean bopenconnection = this.openConnection(id);
        if (!bopenconnection) {
            return false;
        }
        String strFilepath = jarfilepath + "\\";
        success = CONA.getInstance().installApplication(strFilepath, jarfilename, jadfilename, 2, true);
        this.closeConnection();
        return true;
    }
}

