/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.util.HashMap;
import java.util.Map;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public abstract class SVNClientAdapterFactory {
    private static Map ourFactoriesMap;
    private static SVNClientAdapterFactory preferredFactory;

    protected abstract ISVNClientAdapter createSVNClientImpl();

    protected abstract String getClientType();

    public static ISVNClientAdapter createSVNClient(String clientType) {
        if (ourFactoriesMap == null || !ourFactoriesMap.containsKey(clientType)) {
            return null;
        }
        SVNClientAdapterFactory factory = (SVNClientAdapterFactory)ourFactoriesMap.get(clientType);
        if (factory != null) {
            return factory.createSVNClientImpl();
        }
        return null;
    }

    public static boolean isSVNClientAvailable(String clientType) {
        return ourFactoriesMap != null && ourFactoriesMap.containsKey(clientType);
    }

    public static String getPreferredSVNClientType() throws SVNClientException {
        if (preferredFactory != null) {
            return preferredFactory.getClientType();
        }
        throw new SVNClientException("No subversion client interface found.");
    }

    protected static void registerAdapterFactory(SVNClientAdapterFactory factory) throws SVNClientException {
        String type;
        if (factory == null) {
            return;
        }
        if (ourFactoriesMap == null) {
            ourFactoriesMap = new HashMap();
        }
        if (!ourFactoriesMap.containsKey(type = factory.getClientType())) {
            ourFactoriesMap.put(type, factory);
            if (preferredFactory == null) {
                preferredFactory = factory;
            }
        } else {
            throw new SVNClientException("factory for type " + type + " already registered");
        }
    }
}

