/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.framework.InvokeHookCallback;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;

public class ServiceRegistry {
    private final Logger m_logger;
    private long m_currentServiceId = 1L;
    private final Map m_serviceRegsMap = Collections.synchronizedMap(new HashMap());
    private Map m_lockedRegsMap = new HashMap();
    private Map m_inUseMap = new HashMap();
    private final ServiceRegistryCallbacks m_callbacks;
    private final Set m_eventHooks = new TreeSet(Collections.reverseOrder());
    private final Set m_findHooks = new TreeSet(Collections.reverseOrder());
    private final Set m_listenerHooks = new TreeSet(Collections.reverseOrder());
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$EventHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$FindHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$ListenerHook;

    public ServiceRegistry(Logger logger, ServiceRegistryCallbacks callbacks) {
        this.m_logger = logger;
        this.m_callbacks = callbacks;
    }

    public ServiceReference[] getRegisteredServices(Bundle bundle) {
        ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
        if (regs != null) {
            ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>(regs.length);
            for (int i = 0; i < regs.length; ++i) {
                try {
                    refs.add(regs[i].getReference());
                    continue;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            return refs.toArray(new ServiceReference[refs.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(Bundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        ServiceRegistrationImpl reg = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            reg = new ServiceRegistrationImpl(this, bundle, classNames, new Long(this.m_currentServiceId++), svcObj, dict);
            this.addHooks(classNames, svcObj, reg.getReference());
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
            this.m_serviceRegsMap.put(bundle, ServiceRegistry.addServiceRegistration(regs, reg));
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(1, reg.getReference()), null);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistration reg) {
        this.removeHook(reg.getReference());
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
            this.m_serviceRegsMap.put(bundle, ServiceRegistry.removeServiceRegistration(regs, reg));
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(4, reg.getReference()), null);
        }
        serviceRegistry = this;
        synchronized (serviceRegistry) {
            Bundle[] clients = this.getUsingBundles(reg.getReference());
            for (int i = 0; clients != null && i < clients.length; ++i) {
                while (this.ungetService(clients[i], reg.getReference())) {
                }
            }
            ((ServiceRegistrationImpl)reg).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(Bundle bundle) {
        ServiceRegistration[] regs = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
        }
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!((ServiceRegistrationImpl)regs[i]).isValid()) continue;
            regs[i].unregister();
        }
        ServiceRegistry serviceRegistry2 = this;
        synchronized (serviceRegistry2) {
            this.m_serviceRegsMap.remove(bundle);
        }
    }

    public List getServiceReferences(String className, Filter filter) {
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>();
        Object[] registrations = this.m_serviceRegsMap.values().toArray();
        for (int i = 0; i < registrations.length; ++i) {
            ServiceRegistration[] regs = (ServiceRegistration[])registrations[i];
            for (int regIdx = 0; regs != null && regIdx < regs.length; ++regIdx) {
                try {
                    boolean matched = false;
                    if (className == null && (filter == null || filter.match(regs[regIdx].getReference()))) {
                        matched = true;
                    } else if (className != null) {
                        String[] objectClass = (String[])((ServiceRegistrationImpl)regs[regIdx]).getProperty("objectClass");
                        for (int classIdx = 0; classIdx < objectClass.length; ++classIdx) {
                            if (!objectClass[classIdx].equals(className) || filter != null && !filter.match(regs[regIdx].getReference())) continue;
                            matched = true;
                            break;
                        }
                    }
                    if (!matched) continue;
                    list.add(regs[regIdx].getReference());
                    continue;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public synchronized ServiceReference[] getServicesInUse(Bundle bundle) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usages != null) {
            ServiceReference[] refs = new ServiceReference[usages.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = usages[i].m_ref;
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        Object svcObj = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.getService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
            if (reg.isValid()) {
                usage = this.getUsageCount(bundle, ref);
                if (usage == null) {
                    usage = this.addUsageCount(bundle, ref);
                }
                ++usage.m_count;
                svcObj = usage.m_svcObj;
            }
        }
        try {
            if (usage != null && svcObj == null) {
                svcObj = reg.getService(bundle);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                if (!reg.isValid() || svcObj == null) {
                    this.flushUsageCount(bundle, ref);
                } else {
                    usage.m_svcObj = svcObj;
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            usage = this.getUsageCount(bundle, ref);
            if (usage == null) {
                return false;
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
        }
        try {
            if (usage.m_count == 1) {
                ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().ungetService(bundle, usage.m_svcObj);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                --usage.m_count;
                if (!reg.isValid() || usage.m_count <= 0) {
                    usage.m_svcObj = null;
                    this.flushUsageCount(bundle, ref);
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServices(Bundle bundle) {
        UsageCount[] usages;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            usages = (UsageCount[])this.m_inUseMap.get(bundle);
        }
        if (usages == null) {
            return;
        }
        for (int i = 0; i < usages.length; ++i) {
            while (this.ungetService(bundle, usages[i].m_ref)) {
            }
        }
    }

    public synchronized Bundle[] getUsingBundles(ServiceReference ref) {
        Bundle[] bundles = null;
        Iterator iter = this.m_inUseMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Bundle bundle = (Bundle)entry.getKey();
            UsageCount[] usages = (UsageCount[])entry.getValue();
            for (int useIdx = 0; useIdx < usages.length; ++useIdx) {
                if (!usages[useIdx].m_ref.equals(ref)) continue;
                if (bundles == null) {
                    bundles = new Bundle[]{bundle};
                    continue;
                }
                Bundle[] nbs = new Bundle[bundles.length + 1];
                System.arraycopy(bundles, 0, nbs, 0, bundles.length);
                nbs[bundles.length] = bundle;
                bundles = nbs;
            }
        }
        return bundles;
    }

    void servicePropertiesModified(ServiceRegistration reg, Dictionary oldProps) {
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(2, reg.getReference()), oldProps);
        }
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    private static ServiceRegistration[] addServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        if (regs == null) {
            regs = new ServiceRegistration[]{reg};
        } else {
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length + 1];
            System.arraycopy(regs, 0, newRegs, 0, regs.length);
            newRegs[regs.length] = reg;
            regs = newRegs;
        }
        return regs;
    }

    private static ServiceRegistration[] removeServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!regs[i].equals(reg)) continue;
            if (regs.length - 1 == 0) {
                regs = new ServiceRegistration[]{};
                continue;
            }
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length - 1];
            System.arraycopy(regs, 0, newRegs, 0, i);
            if (i < newRegs.length) {
                System.arraycopy(regs, i + 1, newRegs, i, newRegs.length - i);
            }
            regs = newRegs;
        }
        return regs;
    }

    private UsageCount getUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            return usages[i];
        }
        return null;
    }

    private UsageCount addUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        UsageCount usage = new UsageCount();
        usage.m_ref = ref;
        if (usages == null) {
            usages = new UsageCount[]{usage};
        } else {
            UsageCount[] newUsages = new UsageCount[usages.length + 1];
            System.arraycopy(usages, 0, newUsages, 0, usages.length);
            newUsages[usages.length] = usage;
            usages = newUsages;
        }
        this.m_inUseMap.put(bundle, usages);
        return usage;
    }

    private void flushUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            if (usages.length - 1 == 0) {
                usages = null;
                continue;
            }
            UsageCount[] newUsages = new UsageCount[usages.length - 1];
            System.arraycopy(usages, 0, newUsages, 0, i);
            if (i < newUsages.length) {
                System.arraycopy(usages, i + 1, newUsages, i, newUsages.length - i);
            }
            usages = newUsages;
        }
        if (usages != null) {
            this.m_inUseMap.put(bundle, usages);
        } else {
            this.m_inUseMap.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHooks(String[] classNames, Object svcObj, ServiceReference ref) {
        Set set;
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$EventHook == null ? (class$org$osgi$framework$hooks$service$EventHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.EventHook")) : class$org$osgi$framework$hooks$service$EventHook, svcObj)) {
            set = this.m_eventHooks;
            synchronized (set) {
                this.m_eventHooks.add(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$FindHook == null ? (class$org$osgi$framework$hooks$service$FindHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.FindHook")) : class$org$osgi$framework$hooks$service$FindHook, svcObj)) {
            set = this.m_findHooks;
            synchronized (set) {
                this.m_findHooks.add(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook, svcObj)) {
            set = this.m_listenerHooks;
            synchronized (set) {
                this.m_listenerHooks.add(ref);
            }
        }
    }

    static boolean isHook(String[] classNames, Class hookClass, Object svcObj) {
        if (svcObj instanceof ServiceFactory) {
            return Arrays.asList(classNames).contains(hookClass.getName());
        }
        if (hookClass.isAssignableFrom(svcObj.getClass())) {
            String hookName = hookClass.getName();
            for (int i = 0; i < classNames.length; ++i) {
                if (!classNames[i].equals(hookName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHook(ServiceReference ref) {
        Set set;
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        String[] classNames = (String[])ref.getProperty("objectClass");
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$EventHook == null ? (class$org$osgi$framework$hooks$service$EventHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.EventHook")) : class$org$osgi$framework$hooks$service$EventHook, svcObj)) {
            set = this.m_eventHooks;
            synchronized (set) {
                this.m_eventHooks.remove(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$FindHook == null ? (class$org$osgi$framework$hooks$service$FindHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.FindHook")) : class$org$osgi$framework$hooks$service$FindHook, svcObj)) {
            set = this.m_findHooks;
            synchronized (set) {
                this.m_findHooks.remove(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook, svcObj)) {
            set = this.m_listenerHooks;
            synchronized (set) {
                this.m_listenerHooks.remove(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEventHooks() {
        Set set = this.m_eventHooks;
        synchronized (set) {
            return new ArrayList(this.m_eventHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getFindHooks() {
        Set set = this.m_findHooks;
        synchronized (set) {
            return new ArrayList(this.m_findHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getListenerHooks() {
        Set set = this.m_listenerHooks;
        synchronized (set) {
            return new ArrayList(this.m_listenerHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeHook(ServiceReference ref, Framework framework, InvokeHookCallback callback) {
        Object hook = this.getService((Bundle)framework, ref);
        try {
            callback.invokeHook(hook);
        }
        catch (Throwable th) {
            this.m_logger.log(ref, 2, "Problem invoking Service Registry Hook", th);
        }
        finally {
            this.ungetService((Bundle)framework, ref);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ServiceRegistryCallbacks {
        public void serviceChanged(ServiceEvent var1, Dictionary var2);
    }

    private static class UsageCount {
        public int m_count = 0;
        public ServiceReference m_ref = null;
        public Object m_svcObj = null;

        private UsageCount() {
        }
    }
}

