/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskOperation {
    private final String connectorKind;
    private String label;
    private final String operationId;
    private final String repositoryUrl;
    private TaskAttribute taskAttribute;
    private final String taskId;

    public static void applyTo(TaskAttribute taskAttribute, String operationId, String label) {
        TaskData taskData = taskAttribute.getTaskData();
        taskData.getAttributeMapper().setValue(taskAttribute, operationId);
        taskAttribute.getMetaData().defaults().setType("operation").setLabel(label);
    }

    public static TaskOperation createFrom(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskOperation operation = new TaskOperation(taskData.getConnectorKind(), taskData.getRepositoryUrl(), taskData.getTaskId(), taskAttribute.getValue());
        operation.setLabel(taskAttribute.getMetaData().getLabel());
        operation.setTaskAttribute(taskAttribute);
        return operation;
    }

    public TaskOperation(String connectorKind, String repositoryUrl, String taskId, String operationId) {
        Assert.isNotNull((Object)connectorKind);
        Assert.isNotNull((Object)repositoryUrl);
        Assert.isNotNull((Object)taskId);
        Assert.isNotNull((Object)operationId);
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
        this.operationId = operationId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskOperation other = (TaskOperation)obj;
        if (!this.connectorKind.equals(other.connectorKind)) {
            return false;
        }
        if (!this.operationId.equals(other.operationId)) {
            return false;
        }
        if (!this.repositoryUrl.equals(other.repositoryUrl)) {
            return false;
        }
        return this.taskId.equals(other.taskId);
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public TaskAttribute getTaskAttribute() {
        return this.taskAttribute;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.connectorKind.hashCode();
        result = 31 * result + this.operationId.hashCode();
        result = 31 * result + this.repositoryUrl.hashCode();
        result = 31 * result + this.taskId.hashCode();
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTaskAttribute(TaskAttribute taskAttribute) {
        this.taskAttribute = taskAttribute;
    }
}

