/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Ticker;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGPlayer
extends Canvas
implements CommandListener {
    public static final int TOP_LEFT = 0;
    public static final int TOP = 1;
    public static final int TOP_RIGHT = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final int STOPPED = 0;
    public static final int PAUSED = 1;
    public static final int PLAYING = 2;
    private final SVGImage svgImage;
    private final Canvas animatorCanvas;
    private final SVGAnimator animator;
    private final Display display;
    private CommandListener commandListener;
    private SVGEventListener userSvgEventListener;
    private SVGEventListener safeSvgEventListener;
    private boolean startAnimation;
    private boolean resetAnimationWhenStopped;
    private int animatorState = 0;
    private boolean animationNeedsReset;
    private Thread documentUpdateThread;
    private final Document doc;
    private final SVGSVGElement svg;
    private Runnable resetAnimationRunnable = new Runnable(){

        public void run() {
            SVGSVGElement svg = (SVGSVGElement)SVGPlayer.this.getSVGImage().getDocument().getDocumentElement();
            svg.setCurrentTime(0.0f);
        }
    };

    public SVGPlayer(SVGImage svgImage, Display display) throws IllegalArgumentException {
        if (svgImage == null) {
            throw new IllegalArgumentException("svgImage parameter cannot be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("display parameter cannot be null");
        }
        this.animatorState = 0;
        this.svgImage = svgImage;
        this.display = display;
        this.animator = SVGAnimator.createAnimator((SVGImage)svgImage);
        this.animatorCanvas = (Canvas)this.animator.getTargetComponent();
        this.svgImage.setViewportWidth(this.animatorCanvas.getWidth());
        this.svgImage.setViewportHeight(this.animatorCanvas.getHeight());
        this.animatorCanvas.setCommandListener((CommandListener)this);
        this.animator.setSVGEventListener((SVGEventListener)new WrapperSvgEventListener());
        this.setStartAnimationImmediately(true);
        this.setResetAnimationWhenStopped(true);
        this.doc = svgImage.getDocument();
        this.svg = (SVGSVGElement)this.doc.getDocumentElement();
    }

    public Canvas getSvgCanvas() {
        return this.animatorCanvas;
    }

    public SVGEventListener getSVGEventListener() {
        return this.userSvgEventListener;
    }

    public void setSVGEventListener(SVGEventListener svgEventListener) {
        this.userSvgEventListener = svgEventListener;
    }

    public SVGEventListener getSafeSVGEventListener() {
        return this.userSvgEventListener;
    }

    public void setSafeSVGEventListener(SVGEventListener safeSvgEventListener) {
        this.safeSvgEventListener = safeSvgEventListener;
    }

    public void setTimeIncrement(float timeIncrement) {
        this.animator.setTimeIncrement(timeIncrement);
    }

    public float getTimeIncrement() {
        return this.animator.getTimeIncrement();
    }

    public synchronized void pause() {
        this.getAnimator().pause();
        this.animatorState = 1;
    }

    public synchronized void stop() {
        this.getAnimator().stop();
        this.documentUpdateThread = null;
        this.animatorState = 0;
    }

    public synchronized void play() {
        this.getAnimator().play();
        try {
            this.getAnimator().invokeAndWait(new Runnable(){

                public void run() {
                    SVGPlayer.this.documentUpdateThread = Thread.currentThread();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.animatorState = 2;
    }

    public void reset() {
        if (this.animatorState == 0) {
            this.resetAnimationRunnable.run();
        } else {
            this.animator.invokeLater(this.resetAnimationRunnable);
        }
    }

    public synchronized int getAnimatorState() {
        return this.animatorState;
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        this.getAnimator().invokeAndWait(runnable);
    }

    public void invokeLater(Runnable runnable) {
        this.getAnimator().invokeLater(runnable);
    }

    public String getTitle() {
        return this.animatorCanvas != null ? this.animatorCanvas.getTitle() : null;
    }

    public void setTitle(String s) {
        this.animatorCanvas.setTitle(s);
    }

    public void addCommand(Command cmd) {
        this.animatorCanvas.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this.animatorCanvas.removeCommand(cmd);
    }

    public Ticker getTicker() {
        return this.animatorCanvas != null ? this.animatorCanvas.getTicker() : null;
    }

    public void setTicker(Ticker ticker) {
        this.animatorCanvas.setTicker(ticker);
    }

    public void setFullScreenMode(boolean mode) {
        this.animatorCanvas.setFullScreenMode(mode);
        this.svgImage.setViewportWidth(this.animatorCanvas.getWidth());
        this.svgImage.setViewportHeight(this.animatorCanvas.getHeight());
    }

    public void setStartAnimationImmediately(boolean startAnimation) {
        this.startAnimation = startAnimation;
    }

    public boolean isResetAnimationWhenStopped() {
        return this.resetAnimationWhenStopped;
    }

    public void setResetAnimationWhenStopped(boolean reset) {
        this.resetAnimationWhenStopped = reset;
    }

    protected final CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected SVGAnimator getAnimator() {
        return this.animator;
    }

    public final SVGImage getSVGImage() {
        return this.svgImage;
    }

    public SVGElement getSVGElementById(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("id parameter cannot be null");
        }
        Element element = this.doc.getElementById(id);
        if (element instanceof SVGElement) {
            return (SVGElement)element;
        }
        return null;
    }

    public SVGLocatableElement getSVGLocatableElementById(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("id parameter cannot be null");
        }
        Element element = this.doc.getElementById(id);
        if (element instanceof SVGLocatableElement) {
            return (SVGLocatableElement)element;
        }
        return null;
    }

    public SVGAnimationElement getSVGAnimationElementById(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("id parameter cannot be null");
        }
        Element element = this.doc.getElementById(id);
        if (element instanceof SVGAnimationElement) {
            return (SVGAnimationElement)element;
        }
        return null;
    }

    private boolean isRunningInUpdateThread() {
        return Thread.currentThread() == this.documentUpdateThread;
    }

    public synchronized void invokeLaterSafely(Runnable runnable) {
        if (runnable != null) {
            if (this.getAnimatorState() == 0) {
                new Thread(runnable).start();
            } else {
                this.getAnimator().invokeLater(runnable);
            }
        }
    }

    public synchronized void invokeAndWaitSafely(Runnable runnable) {
        if (runnable != null) {
            if (this.isRunningInUpdateThread() || this.getAnimatorState() == 0) {
                runnable.run();
            } else {
                try {
                    this.getAnimator().invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setTraitSafely(final String id, final String traitName, final String traitValue) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.setTrait(id, traitName, traitValue);
            }
        });
    }

    public void setTrait(String id, String traitName, String traitValue) {
        SVGElement elt = this.getSVGElementById(id);
        if (elt != null) {
            elt.setTrait(traitName, traitValue);
        }
    }

    public void setFloatTraitSafely(final String id, final String traitName, final float traitValue) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.setFloatTrait(id, traitName, traitValue);
            }
        });
    }

    public void setFloatTrait(String id, String traitName, float traitValue) {
        SVGElement elt = this.getSVGElementById(id);
        if (elt != null) {
            elt.setFloatTrait(traitName, traitValue);
        }
    }

    public void setRGBTraitSafely(final String id, final String traitName, final int rgb) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.setRGBTrait(id, traitName, rgb);
            }
        });
    }

    public void setRGBTrait(String id, String traitName, int rgb) {
        SVGElement elt = this.getSVGElementById(id);
        if (elt != null) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            SVGRGBColor svgRGB = this.svg.createSVGRGBColor(r, g, b);
            elt.setRGBColorTrait(traitName, svgRGB);
        }
    }

    public void setRGBTraitSafely(final String id, final String traitName, final int r, final int g, final int b) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.setRGBTrait(id, traitName, r, g, b);
            }
        });
    }

    public void setRGBTrait(String id, String traitName, int r, int g, int b) {
        SVGElement elt = this.getSVGElementById(id);
        if (elt != null) {
            SVGRGBColor rgb = this.svg.createSVGRGBColor(r, g, b);
            elt.setRGBColorTrait(traitName, rgb);
        }
    }

    public void translateSafely(final String id, final float tx, final float ty) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.translate(id, tx, ty);
            }
        });
    }

    public void translate(String id, float tx, float ty) {
        this.translate(this.getSVGElementById(id), tx, ty);
    }

    public void translate(SVGElement svgElement, float tx, float ty) {
        if (svgElement != null) {
            SVGMatrix txf = svgElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            txf.mTranslate(tx, ty);
            svgElement.setMatrixTrait("transform", txf);
        }
    }

    public void screenTranslateSafely(final String id, final float tx, final float ty) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.screenTranslate(id, tx, ty);
            }
        });
    }

    public void screenTranslate(String id, float tx, float ty) {
        this.screenTranslate(this.getSVGLocatableElementById(id), tx, ty);
    }

    public void screenTranslate(SVGLocatableElement svgLocatableElement, float tx, float ty) {
        if (svgLocatableElement != null) {
            SVGMatrix txf = svgLocatableElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            SVGMatrix screenTxf = svgLocatableElement.getScreenCTM();
            SVGMatrix screenTxfInv = screenTxf.inverse();
            txf = txf.mMultiply(screenTxfInv);
            txf.mTranslate(tx, ty);
            txf.mMultiply(screenTxf);
            svgLocatableElement.setMatrixTrait("transform", txf);
        }
    }

    public SVGRect getScreenBBox(String id) {
        SVGLocatableElement elt = this.getSVGLocatableElementById(id);
        if (elt != null) {
            return elt.getScreenBBox();
        }
        return null;
    }

    public void scaleSafely(final String id, final float sx, final float sy) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.scale(id, sx, sy);
            }
        });
    }

    public void scale(String id, float sx, float sy) {
        this.scale(this.getSVGElementById(id), sx, sy);
    }

    public void scale(SVGElement svgElement, float sx, float sy) {
        if (svgElement != null) {
            SVGMatrix txf = svgElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            SVGMatrix scale = this.svg.createSVGMatrixComponents(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
            txf.mMultiply(scale);
            svgElement.setMatrixTrait("transform", txf);
        }
    }

    public void scaleAboutSafely(final String id, final float sx, final float sy, final int anchor) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.scaleAbout(id, sx, sy, anchor);
            }
        });
    }

    public void scaleAbout(String id, float sx, float sy, int anchor) {
        this.scaleAbout(this.getSVGLocatableElementById(id), sx, sy, anchor);
    }

    public void scaleAbout(SVGLocatableElement svgLocatableElement, float sx, float sy, int anchor) {
        if (svgLocatableElement != null) {
            SVGMatrix txf = svgLocatableElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            SVGRect bbox = svgLocatableElement.getBBox();
            float[] translate = this.computeAnchorTranslate(bbox, anchor);
            SVGMatrix scale = this.svg.createSVGMatrixComponents(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
            txf.mTranslate(-translate[0], -translate[1]);
            txf.mMultiply(scale);
            txf.mTranslate(translate[0], translate[1]);
            svgLocatableElement.setMatrixTrait("transform", txf);
        }
    }

    public void rotateSafely(final String id, final float angle) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.rotate(id, angle);
            }
        });
    }

    public void rotate(String id, float angle) {
        this.rotate(this.getSVGElementById(id), angle);
    }

    public void rotate(SVGElement svgElement, float angle) {
        if (svgElement != null) {
            SVGMatrix txf = svgElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            txf.mRotate(angle);
            svgElement.setMatrixTrait("transform", txf);
        }
    }

    public void rotateAboutSafely(final String id, final float angle, final int anchor) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.rotateAbout(id, angle, anchor);
            }
        });
    }

    public void rotateAbout(String id, float angle, int anchor) {
        this.rotateAbout(this.getSVGLocatableElementById(id), angle, anchor);
    }

    public void rotateAbout(SVGLocatableElement svgLocatableElement, float angle, int anchor) {
        if (svgLocatableElement != null) {
            SVGMatrix txf = svgLocatableElement.getMatrixTrait("transform");
            if (txf == null) {
                txf = this.svg.createSVGMatrixComponents(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            SVGRect bbox = svgLocatableElement.getBBox();
            float[] translate = this.computeAnchorTranslate(bbox, anchor);
            txf.mTranslate(-translate[0], -translate[1]);
            txf.mRotate(angle);
            txf.mTranslate(translate[0], translate[1]);
            svgLocatableElement.setMatrixTrait("transform", txf);
        }
    }

    protected float[] computeAnchorTranslate(SVGRect bbox, int anchor) {
        float[] translate = new float[]{0.0f, 0.0f};
        switch (anchor) {
            case 0: 
            case 3: 
            case 6: {
                translate[0] = -bbox.getX();
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                translate[0] = -bbox.getX() - bbox.getWidth() / 2.0f;
                break;
            }
            default: {
                translate[0] = -bbox.getX() - bbox.getWidth();
            }
        }
        switch (anchor) {
            case 0: 
            case 1: 
            case 2: {
                translate[1] = -bbox.getY();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                translate[1] = -bbox.getY() - bbox.getHeight() / 2.0f;
                break;
            }
            default: {
                translate[1] = -bbox.getY() - bbox.getHeight();
            }
        }
        return translate;
    }

    public void startAnimationSafely(final String elementId) {
        this.invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.startAnimation(elementId);
            }
        });
    }

    public void startAnimation(String elementId) {
        this.startAnimation(elementId, 0.0f);
    }

    public void startAnimation(String elementId, float delay) {
        SVGAnimationElement animationElement = this.getSVGAnimationElementById(elementId);
        if (animationElement != null) {
            animationElement.beginElementAt(delay);
        }
    }

    public void stopAnimationSafely(final String elementId) {
        this.invokeLaterSafely(new Runnable(){

            public void run() {
                SVGPlayer.this.stopAnimationSafely(elementId);
            }
        });
    }

    public void stopAnimation(String elementId) {
        this.stopAnimation(elementId, 0.0f);
    }

    public void stopAnimation(String elementId, float delay) {
        SVGAnimationElement animationElement = this.getSVGAnimationElementById(elementId);
        if (animationElement != null) {
            animationElement.endElementAt(delay);
        }
    }

    protected void paint(Graphics graphics) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.animatorCanvas && this.commandListener != null) {
            this.commandListener.commandAction(command, (Displayable)this);
        }
    }

    private class WrapperSvgEventListener
    implements SVGEventListener {
        private WrapperSvgEventListener() {
        }

        public void keyPressed(final int i) {
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.keyPressed(i);
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.keyPressed(i);
                    }
                });
            }
        }

        public void keyReleased(final int i) {
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.keyReleased(i);
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.keyReleased(i);
                    }
                });
            }
        }

        public void pointerPressed(final int x, final int y) {
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.pointerPressed(x, y);
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.pointerPressed(x, y);
                    }
                });
            }
        }

        public void pointerReleased(final int x, final int y) {
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.pointerReleased(x, y);
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.pointerPressed(x, y);
                    }
                });
            }
        }

        public void hideNotify() {
            SVGPlayer.this.animationNeedsReset = true;
            if (SVGPlayer.this.animatorState != 0) {
                SVGPlayer.this.stop();
            }
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.hideNotify();
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.hideNotify();
                    }
                });
            }
        }

        public void showNotify() {
            if (SVGPlayer.this.resetAnimationWhenStopped && SVGPlayer.this.animationNeedsReset) {
                SVGPlayer.this.reset();
            }
            if (SVGPlayer.this.startAnimation && SVGPlayer.this.animatorState != 2) {
                SVGPlayer.this.getDisplay().callSerially(new Runnable(){

                    public void run() {
                        SVGPlayer.this.play();
                    }
                });
            }
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.showNotify();
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.showNotify();
                    }
                });
            }
        }

        public void sizeChanged(final int x, final int y) {
            SVGPlayer.this.svgImage.setViewportWidth(x);
            SVGPlayer.this.svgImage.setViewportHeight(y);
            if (SVGPlayer.this.userSvgEventListener != null) {
                SVGPlayer.this.userSvgEventListener.sizeChanged(x, y);
            }
            if (SVGPlayer.this.safeSvgEventListener != null) {
                SVGPlayer.this.invokeAndWaitSafely(new Runnable(){

                    public void run() {
                        SVGPlayer.this.safeSvgEventListener.sizeChanged(x, y);
                    }
                });
            }
        }
    }
}

