/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.engine;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;

public class StringSourceRewriter
implements SourceRewriter {
    PrintWriter out;
    StringWriter sout = new StringWriter();

    public StringSourceRewriter() {
        this.out = new PrintWriter(this.sout);
    }

    @Override
    public void writeTo(String s) throws IOException, BadLocationException {
        this.out.print(s);
    }

    @Override
    public void skipThrough(SourceReader in, int offset) throws IOException, BadLocationException {
        in.seek(offset);
    }

    @Override
    public void copyTo(SourceReader in, int offset) throws IOException {
        char[] buf = in.getCharsTo(offset);
        this.out.write(buf);
    }

    @Override
    public void copyRest(SourceReader in) throws IOException {
        int i;
        char[] buf = new char[4096];
        while ((i = in.read(buf)) > 0) {
            this.out.write(buf, 0, i);
        }
    }

    @Override
    public void close(boolean save) throws IOException {
        this.out.flush();
    }

    public String toString() {
        return this.sout.toString();
    }
}

