/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.SpecificLongValue;

final class ParticularLongValue
extends SpecificLongValue {
    private final long value;

    public ParticularLongValue(long l) {
        this.value = l;
    }

    public long value() {
        return this.value;
    }

    public LongValue negate() {
        return new ParticularLongValue(-this.value);
    }

    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    public LongValue generalize(LongValue longValue) {
        return longValue.generalize(this);
    }

    public LongValue add(LongValue longValue) {
        return longValue.add(this);
    }

    public LongValue subtract(LongValue longValue) {
        return longValue.subtractFrom(this);
    }

    public LongValue subtractFrom(LongValue longValue) {
        return longValue.subtract(this);
    }

    public LongValue multiply(LongValue longValue) {
        return longValue.multiply(this);
    }

    public LongValue divide(LongValue longValue) throws ArithmeticException {
        return longValue.divideOf(this);
    }

    public LongValue divideOf(LongValue longValue) throws ArithmeticException {
        return longValue.divide(this);
    }

    public LongValue remainder(LongValue longValue) throws ArithmeticException {
        return longValue.remainderOf(this);
    }

    public LongValue remainderOf(LongValue longValue) throws ArithmeticException {
        return longValue.remainder(this);
    }

    public LongValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public LongValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public LongValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public LongValue and(LongValue longValue) {
        return longValue.and(this);
    }

    public LongValue or(LongValue longValue) {
        return longValue.or(this);
    }

    public LongValue xor(LongValue longValue) {
        return longValue.xor(this);
    }

    public IntegerValue compare(LongValue longValue) {
        return longValue.compareReverse(this);
    }

    public LongValue generalize(ParticularLongValue particularLongValue) {
        return this.generalize((SpecificLongValue)particularLongValue);
    }

    public LongValue add(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value + particularLongValue.value);
    }

    public LongValue subtract(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value - particularLongValue.value);
    }

    public LongValue subtractFrom(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value - this.value);
    }

    public LongValue multiply(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value * particularLongValue.value);
    }

    public LongValue divide(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(this.value / particularLongValue.value);
    }

    public LongValue divideOf(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(particularLongValue.value / this.value);
    }

    public LongValue remainder(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(this.value % particularLongValue.value);
    }

    public LongValue remainderOf(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(particularLongValue.value % this.value);
    }

    public LongValue shiftLeft(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value << particularIntegerValue.value());
    }

    public LongValue shiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value >> particularIntegerValue.value());
    }

    public LongValue unsignedShiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value >>> particularIntegerValue.value());
    }

    public LongValue and(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value & particularLongValue.value);
    }

    public LongValue or(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value | particularLongValue.value);
    }

    public LongValue xor(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value ^ particularLongValue.value);
    }

    public boolean isParticular() {
        return true;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularLongValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return this.value + "L";
    }
}

