/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLCommandDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLMutableState;

public class WLDeploymentManager
implements DeploymentManager {
    public static final int MANAGER_TIMEOUT = 60000;
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentManager.class.getName());
    private final WLDeploymentFactory factory;
    private final String uri;
    private final String host;
    private final String port;
    private final WLProductProperties productProperties = new WLProductProperties(this);
    private final WLMutableState mutableState;
    private final boolean disconnected;
    private WLClassLoader classLoader;
    private InstanceProperties instanceProperties;

    public WLDeploymentManager(WLDeploymentFactory wLDeploymentFactory, String string, String string2, String string3, boolean bl, WLMutableState wLMutableState) {
        this.factory = wLDeploymentFactory;
        this.uri = string;
        this.host = string2;
        this.port = string3;
        this.disconnected = bl;
        this.mutableState = wLMutableState;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isRestartNeeded() {
        return this.mutableState.isRestartNeeded();
    }

    public void setRestartNeeded(boolean bl) {
        this.mutableState.setRestartNeeded(bl);
    }

    public synchronized InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.uri);
        }
        return this.instanceProperties;
    }

    public WLProductProperties getProductProperties() {
        return this.productProperties;
    }

    private synchronized ClassLoader getWLClassLoader(String string, String string2) {
        if (this.classLoader == null) {
            try {
                URL[] uRLArray = new URL[]{new File(string2 + "/server/lib/weblogic.jar").toURI().toURL()};
                this.classLoader = new WLClassLoader(uRLArray, WLDeploymentManager.class.getClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.WARNING, null, malformedURLException);
            }
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> T executeAction(Action<T> action) throws ExecutionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string = this.getInstanceProperties().getProperty("serverRoot");
        if (string == null) {
            string = WLPluginProperties.getInstance().getInstallLocation();
        }
        Thread.currentThread().setContextClassLoader(this.getWLClassLoader(this.getUri(), string));
        try {
            T t;
            DeploymentManager deploymentManager = WLDeploymentManager.getDeploymentManager(this.getInstanceProperties().getProperty("username"), this.getInstanceProperties().getProperty("password"), this.host, this.port);
            try {
                t = action.execute(deploymentManager);
            }
            catch (Throwable throwable) {
                try {
                    deploymentManager.release();
                    throw throwable;
                }
                catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                    throw new ExecutionException(deploymentManagerCreationException);
                }
            }
            deploymentManager.release();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static DeploymentManager getDeploymentManager(String string, String string2, String string3, String string4) throws DeploymentManagerCreationException {
        DeploymentManagerCreationException deploymentManagerCreationException = null;
        try {
            Class<?> clazz = Class.forName("weblogic.deploy.api.tools.SessionHelper", false, Thread.currentThread().getContextClassLoader());
            Method method = clazz.getDeclaredMethod("getDeploymentManager", String.class, String.class, String.class, String.class);
            Object object = method.invoke(null, string3, string4, string, string2);
            if (DeploymentManager.class.isAssignableFrom(object.getClass())) {
                return (DeploymentManager)object;
            }
            deploymentManagerCreationException = new DeploymentManagerCreationException("Instance created by WebLogic is not DeploymentManager instance.");
        }
        catch (Exception exception) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)noClassDefFoundError);
        }
        throw deploymentManagerCreationException;
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        WLCommandDeployer wLCommandDeployer = new WLCommandDeployer(this.factory, this.getInstanceProperties());
        return wLCommandDeployer.deploy(targetArray, file, file2, this.getHost(), this.getPort());
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Redeploy not yet implemented");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Redeploy not yet implemented");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        WLCommandDeployer wLCommandDeployer = new WLCommandDeployer(this.factory, this.getInstanceProperties());
        return wLCommandDeployer.undeploy(targetModuleIDArray);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        WLCommandDeployer wLCommandDeployer = new WLCommandDeployer(this.factory, this.getInstanceProperties());
        return wLCommandDeployer.stop(targetModuleIDArray);
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        WLCommandDeployer wLCommandDeployer = new WLCommandDeployer(this.factory, this.getInstanceProperties());
        return wLCommandDeployer.start(targetModuleIDArray);
    }

    public TargetModuleID[] getAvailableModules(final ModuleType moduleType, final Target[] targetArray) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager deploymentManager) throws ExecutionException {
                    try {
                        return deploymentManager.getAvailableModules(moduleType, WLDeploymentManager.translateTargets(deploymentManager, targetArray));
                    }
                    catch (TargetException targetException) {
                        throw new ExecutionException(targetException);
                    }
                }
            });
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof TargetException) {
                throw (TargetException)executionException.getCause();
            }
            LOGGER.log(Level.INFO, null, executionException.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getNonRunningModules(final ModuleType moduleType, final Target[] targetArray) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager deploymentManager) throws ExecutionException {
                    try {
                        return deploymentManager.getNonRunningModules(moduleType, WLDeploymentManager.translateTargets(deploymentManager, targetArray));
                    }
                    catch (TargetException targetException) {
                        throw new ExecutionException(targetException);
                    }
                }
            });
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof TargetException) {
                throw (TargetException)executionException.getCause();
            }
            LOGGER.log(Level.INFO, null, executionException.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getRunningModules(final ModuleType moduleType, final Target[] targetArray) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager deploymentManager) throws ExecutionException {
                    try {
                        return deploymentManager.getRunningModules(moduleType, WLDeploymentManager.translateTargets(deploymentManager, targetArray));
                    }
                    catch (TargetException targetException) {
                        throw new ExecutionException(targetException);
                    }
                }
            });
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof TargetException) {
                throw (TargetException)executionException.getCause();
            }
            LOGGER.log(Level.INFO, null, executionException.getCause());
            return new TargetModuleID[0];
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<Target[]>(){

                @Override
                public Target[] execute(DeploymentManager deploymentManager) throws ExecutionException {
                    return deploymentManager.getTargets();
                }
            });
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException.getCause());
            return new Target[0];
        }
    }

    public void release() {
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    private static Target[] translateTargets(DeploymentManager deploymentManager, Target[] targetArray) {
        Target[] targetArray2 = deploymentManager.getTargets();
        ArrayList<Target> arrayList = new ArrayList<Target>(targetArray.length);
        for (Target target : targetArray2) {
            for (Target target2 : targetArray) {
                if (target.hashCode() != target2.hashCode() || !target.getName().equals(target2.getName())) continue;
                arrayList.add(target);
            }
        }
        return arrayList.toArray(new Target[arrayList.size()]);
    }

    private static class WLClassLoader
    extends URLClassLoader {
        public WLClassLoader(URL[] uRLArray, ClassLoader classLoader) throws MalformedURLException {
            super(uRLArray, classLoader);
        }

        public void addURL(File file) throws MalformedURLException {
            if (file.isFile()) {
                this.addURL(file.toURL());
            }
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if (string.indexOf("jndi.properties") != -1 || string.indexOf("i18n_user.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }
    }

    private static interface Action<T> {
        public T execute(DeploymentManager var1) throws ExecutionException;
    }
}

