/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLMutableState;
import org.openide.util.NbBundle;

public class WLDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:WebLogic:http://";
    public static final int DEFAULT_PORT = 7001;
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentFactory.class.getName());
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private static WLDeploymentFactory instance;
    private static Map<InstanceProperties, WLDeploymentManager> managerCache;
    private static Map<InstanceProperties, WLMutableState> stateCache;

    public static synchronized WLDeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WLDeploymentFactory();
        }
        return instance;
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(URI_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        InstanceProperties instanceProperties;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDeploymentManager, uri: {0} username: {1} password: {2}", new Object[]{string, string2, string3});
        }
        if ((instanceProperties = InstanceProperties.getInstanceProperties((String)string)) == null) {
            throw new DeploymentManagerCreationException("Could not create deployment manager for " + string);
        }
        Class<WLDeploymentFactory> clazz = WLDeploymentFactory.class;
        synchronized (WLDeploymentFactory.class) {
            WLDeploymentManager wLDeploymentManager = managerCache.get(instanceProperties);
            if (wLDeploymentManager != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return wLDeploymentManager;
            }
            WLMutableState wLMutableState = WLDeploymentFactory.getMutableState(instanceProperties);
            String[] stringArray = string.split(":");
            String string4 = stringArray[3].substring(2);
            String string5 = stringArray[4] != null ? stringArray[4].trim() : stringArray[4];
            wLDeploymentManager = new WLDeploymentManager(this, string, string4, string5, false, wLMutableState);
            managerCache.put(instanceProperties, wLDeploymentManager);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return wLDeploymentManager;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        InstanceProperties instanceProperties;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDisconnectedDeploymentManager, uri: {0}", string);
        }
        if ((instanceProperties = InstanceProperties.getInstanceProperties((String)string)) == null) {
            throw new DeploymentManagerCreationException("Could not create deployment manager for " + string);
        }
        WLMutableState wLMutableState = WLDeploymentFactory.getMutableState(instanceProperties);
        String[] stringArray = string.split(":");
        String string2 = stringArray[3].substring(2);
        String string3 = stringArray[4] != null ? stringArray[4].trim() : stringArray[4];
        WLDeploymentManager wLDeploymentManager = new WLDeploymentManager(this, string, string2, string3, true, wLMutableState);
        return wLDeploymentManager;
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_productVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_displayName");
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static synchronized WLMutableState getMutableState(InstanceProperties instanceProperties) {
        WLMutableState wLMutableState = stateCache.get(instanceProperties);
        if (wLMutableState == null) {
            wLMutableState = new WLMutableState();
            stateCache.put(instanceProperties, wLMutableState);
        }
        return wLMutableState;
    }

    static {
        managerCache = new WeakHashMap<InstanceProperties, WLDeploymentManager>();
        stateCache = new WeakHashMap<InstanceProperties, WLMutableState>();
    }
}

