/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.netbeans.core.ui.sampler.SamplesOutputStream;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String THREAD_NAME = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ThreadName");
    private static final String NOT_SUPPORTED = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_NotSupported");
    private static final String SAVE_MSG = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_SavedFile");
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(SelfSamplerAction.class.getName());
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private static final int MAX_SAMPLING_TIME = 300;
    private static final int MAX_SAMPLES = 30000;
    private final AtomicReference<Controller> RUNNING = new AtomicReference();
    private Boolean debugMode;
    private String lastReason;

    private SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSampler.png", (boolean)false));
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    public static SelfSamplerAction getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (SamplesOutputStream.isSupported()) {
            Controller c = new Controller(THREAD_NAME);
            if (this.RUNNING.compareAndSet(null, c)) {
                this.putValue("Name", ACTION_NAME_STOP);
                this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSamplerRunning.png", (boolean)false));
                c.run();
            } else {
                c = this.RUNNING.getAndSet(null);
                if (c != null) {
                    final Controller controller = c;
                    this.setEnabled(false);
                    SwingWorker worker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            controller.actionPerformed(new ActionEvent(this, 0, "show"));
                            return null;
                        }

                        @Override
                        protected void done() {
                            SelfSamplerAction.this.putValue("Name", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSampler.png", (boolean)false));
                            SelfSamplerAction.this.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NOT_SUPPORTED, 1);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent kevent = (KeyEvent)event;
        if (kevent.getID() == 402 && kevent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, event.getID(), "shortcut"));
            kevent.consume();
        }
    }

    @Override
    public Object getValue(String key) {
        Object o = super.getValue(key);
        if (o == null && key.startsWith("logger-") && SamplesOutputStream.isSupported() && this.isRunMode()) {
            return new Controller(key);
        }
        return o;
    }

    private boolean isProfileMe(Controller c) {
        return c == this.RUNNING.get();
    }

    private synchronized boolean isDebugged() {
        if (this.debugMode == null) {
            this.debugMode = Boolean.FALSE;
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            List<String> args = runtime.getInputArguments();
            if (args.contains(DEBUG_ARG)) {
                this.debugMode = Boolean.TRUE;
            }
        }
        return this.debugMode;
    }

    private boolean isRunMode() {
        boolean runMode = true;
        String reason = null;
        if (this.isDebugged()) {
            reason = "running in debug mode";
            runMode = false;
        }
        if (runMode) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                reason = "running under profiler";
                runMode = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!runMode && reason != this.lastReason) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - " + reason);
        }
        this.lastReason = reason;
        return runMode;
    }

    private static final class Controller
    implements Runnable,
    ActionListener {
        private static Class defaultDataObject;
        private final String name;
        private Timer timer;
        private ByteArrayOutputStream out;
        private SamplesOutputStream samplesStream;
        private long startTime;
        private long samples;
        private long laststamp;
        private double max;
        private double min = 9.223372036854776E18;
        private double sum;
        private double devSquaresSum;
        private volatile boolean stopped;
        private volatile boolean running;

        Controller(String n) {
            this.name = n;
        }

        private void updateStats(long timestamp) {
            if (this.laststamp != 0L) {
                double diff = (double)(timestamp - this.laststamp) / 1000000.0;
                ++this.samples;
                this.sum += diff;
                this.devSquaresSum += (diff - 10.0) * (diff - 10.0);
                if (diff > this.max) {
                    this.max = diff;
                } else if (diff < this.min) {
                    this.min = diff;
                }
            }
            this.laststamp = timestamp;
        }

        @Override
        public synchronized void run() {
            assert (!this.running);
            this.running = true;
            final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            this.out = new ByteArrayOutputStream(65536);
            try {
                this.samplesStream = new SamplesOutputStream(this.out);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            this.startTime = System.currentTimeMillis();
            this.timer = new Timer(this.name);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Controller controller = Controller.this;
                    synchronized (controller) {
                        if (Controller.this.stopped) {
                            return;
                        }
                        if (Controller.this.samples >= 30000L) {
                            Controller.this.cancelTimer();
                            return;
                        }
                        try {
                            ThreadInfo[] infos = threadBean.dumpAllThreads(false, false);
                            long timestamp = System.nanoTime();
                            Controller.this.samplesStream.writeSample(infos, timestamp, Thread.currentThread().getId());
                            Controller.this.updateStats(timestamp);
                        }
                        catch (Throwable ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }, 10L, 10L);
        }

        private void cancelTimer() {
            this.timer.cancel();
            if (SelfSamplerAction.getInstance().isProfileMe(this)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelfSamplerAction.getInstance().actionPerformed(null);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            try {
                assert (this.running);
                assert (!this.stopped);
                this.stopped = true;
                this.timer.cancel();
                if ("cancel".equals(e.getActionCommand()) || this.samples < 1L) {
                    return;
                }
                double average = this.sum / (double)this.samples;
                double std_deviation = Math.sqrt(this.devSquaresSum / (double)this.samples);
                boolean writeCommand = "write".equals(e.getActionCommand());
                if (writeCommand) {
                    Object[] params = new Object[]{this.startTime, "Samples", this.samples, "Average", average, "Minimum", this.min, "Maximum", this.max, "Std. deviation", std_deviation};
                    Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", params);
                    if (average > 30.0 || std_deviation > 40.0) {
                        return;
                    }
                }
                this.samplesStream.close();
                this.samplesStream = null;
                if (writeCommand) {
                    DataOutputStream dos = (DataOutputStream)e.getSource();
                    dos.write(this.out.toByteArray());
                    dos.close();
                    return;
                }
                File outFile = File.createTempFile("selfsampler", ".npss");
                outFile = FileUtil.normalizeFile((File)outFile);
                this.writeToFile(outFile);
                FileObject fo = FileUtil.toFileObject((File)outFile);
                DataObject dobj = DataObject.find((FileObject)fo);
                if (defaultDataObject.isAssignableFrom(dobj.getClass())) {
                    String msg = MessageFormat.format(SAVE_MSG, outFile.getAbsolutePath());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                } else {
                    ((OpenCookie)dobj.getCookie(OpenCookie.class)).open();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.out = null;
                this.samplesStream = null;
            }
        }

        private void writeToFile(File file) {
            try {
                FileOutputStream fstream = new FileOutputStream(file);
                fstream.write(this.out.toByteArray());
                this.out = null;
                fstream.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        static {
            try {
                defaultDataObject = Class.forName("org.openide.loaders.DefaultDataObject");
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class Singleton {
        static final SelfSamplerAction INSTANCE = new SelfSamplerAction();

        private Singleton() {
        }
    }
}

