/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;

public class ArrayPropertyOrderingController
implements InspectorOrderingController {
    private String propertyName;
    private Integer order;
    private TypeID supportedTypeID;

    public ArrayPropertyOrderingController(String propertyName, Integer order, TypeID supportedTypeID) {
        this.propertyName = propertyName;
        this.order = order;
        this.supportedTypeID = supportedTypeID;
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent component, Collection<InspectorFolder> folders) {
        ArrayList<InspectorFolder> orderedList = new ArrayList<InspectorFolder>(folders.size());
        if (component == null) {
            return new ArrayList<InspectorFolder>(folders);
        }
        List array = component.readProperty(this.propertyName).getArray();
        if (array == null) {
            return new ArrayList<InspectorFolder>(folders);
        }
        block0: for (PropertyValue value : array) {
            DesignComponent itemsComponent = value.getComponent();
            for (InspectorFolder f : folders) {
                if (!f.getComponentID().equals(itemsComponent.getComponentID())) continue;
                orderedList.add(f);
                continue block0;
            }
        }
        return orderedList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument document, TypeID typeID) {
        return document.getDescriptorRegistry().isInHierarchy(this.supportedTypeID, typeID);
    }
}

