/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.codegen.Setter;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class MidpSetter
implements Setter {
    private TypeID constructorRelatedTypeID;
    private String instanceNameSuffix;
    private Versionable versionable;
    private String arrayParameterName;
    private ArrayList<String> parameterNames = new ArrayList();
    private ArrayList<String> exceptions = new ArrayList();

    private MidpSetter(TypeID constructorRelatedTypeID, String instanceNameSuffix, Versionable versionable) {
        this.constructorRelatedTypeID = constructorRelatedTypeID;
        this.instanceNameSuffix = instanceNameSuffix;
        this.versionable = versionable;
    }

    public MidpSetter setArrayParameter(String arrayParameterName) {
        this.arrayParameterName = arrayParameterName;
        return this;
    }

    public MidpSetter addParameters(String ... parameterNames) {
        this.parameterNames.addAll(Arrays.asList(parameterNames));
        return this;
    }

    public MidpSetter addExceptions(String ... exceptions) {
        this.exceptions.addAll(Arrays.asList(exceptions));
        return this;
    }

    public static MidpSetter createConstructor(TypeID constructorRelatedTypeID, Versionable versionable) {
        return new MidpSetter(constructorRelatedTypeID, " = new " + MidpTypes.getSimpleClassName(constructorRelatedTypeID), versionable);
    }

    public static MidpSetter createFactoryMethod(TypeID constructorRelatedTypeID, String classCast, String className, String methodName, Versionable versionable) {
        return new MidpSetter(constructorRelatedTypeID, " = " + (classCast != null ? "(" + classCast + ") " : "") + className + "." + methodName, versionable);
    }

    public static MidpSetter createSetter(String setterName, Versionable versionable) {
        return new MidpSetter(null, "." + setterName, versionable);
    }

    public boolean isConstructor() {
        return this.constructorRelatedTypeID != null;
    }

    public TypeID getConstructorRelatedTypeID() {
        return this.constructorRelatedTypeID;
    }

    public int getPriority() {
        return 0;
    }

    public String getSetterName() {
        return this.instanceNameSuffix;
    }

    public Versionable getVersionable() {
        return this.versionable;
    }

    public void generateSetterCode(MultiGuardedSection section, DesignComponent component, Map<String, Parameter> name2parameter) {
        if (!this.exceptions.isEmpty()) {
            section.getWriter().write("try {\n");
        }
        if (this.arrayParameterName != null) {
            Parameter arrayParameter = name2parameter.get(this.arrayParameterName);
            int count = arrayParameter.getCount(component);
            for (int index = 0; index < count; ++index) {
                if (!arrayParameter.isRequiredToBeSet(component, index)) continue;
                section.getWriter().write(CodeReferencePresenter.generateDirectAccessCode((DesignComponent)component));
                section.getWriter().write(this.instanceNameSuffix);
                section.getWriter().write(" (");
                for (int paramIndex = 0; paramIndex < this.parameterNames.size(); ++paramIndex) {
                    if (paramIndex > 0) {
                        section.getWriter().write(", ");
                    }
                    String parameterName = this.parameterNames.get(paramIndex);
                    Parameter parameter = name2parameter.get(parameterName);
                    parameter.generateParameterCode(component, section, index);
                }
                section.getWriter().write(");\n");
            }
        } else {
            section.getWriter().write(CodeReferencePresenter.generateDirectAccessCode((DesignComponent)component));
            section.getWriter().write(this.instanceNameSuffix);
            section.getWriter().write(" (");
            for (int paramIndex = 0; paramIndex < this.parameterNames.size(); ++paramIndex) {
                if (paramIndex > 0) {
                    section.getWriter().write(", ");
                }
                String parameterName = this.parameterNames.get(paramIndex);
                Parameter parameter = name2parameter.get(parameterName);
                parameter.generateParameterCode(component, section, -1);
            }
            section.getWriter().write(");\n");
        }
        if (!this.exceptions.isEmpty()) {
            for (String exception : this.exceptions) {
                section.getWriter().write("} catch (" + exception + " e) {\n").commit();
                section.switchToEditable(component.getComponentID() + "-@" + exception);
                section.getWriter().write("e.printStackTrace ();\n").commit();
                section.switchToGuarded();
            }
            section.getWriter().write("}\n");
        }
    }

    public List<String> getParameters() {
        return this.parameterNames;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }
}

