/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.platformdefinition;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    private Util() {
    }

    public static ClassPath createClassPath(String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<PathResourceImplementation> list = new ArrayList<PathResourceImplementation>();
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken();
            File f = FileUtil.normalizeFile((File)new File(item));
            URL url = Util.getRootURL(f);
            if (url == null) continue;
            list.add(ClassPathSupport.createResource((URL)url));
        }
        return ClassPathSupport.createClassPath(list);
    }

    static URL getRootURL(File f) {
        URL url = null;
        try {
            if (Util.isArchiveFile(f)) {
                url = FileUtil.getArchiveRoot((URL)f.toURI().toURL());
            } else {
                url = f.toURI().toURL();
                String surl = url.toExternalForm();
                if (!surl.endsWith("/")) {
                    url = new URL(surl + "/");
                }
            }
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        return url;
    }

    public static String normalizeName(String displayName) {
        StringBuffer normalizedName = new StringBuffer();
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                normalizedName.append(c);
                continue;
            }
            normalizedName.append('_');
        }
        return normalizedName.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform plat) {
        String version = (String)plat.getSystemProperties().get("java.specification.version");
        if (version == null) {
            version = "1.1";
        }
        return Util.makeSpec(version);
    }

    public static FileObject findTool(String folder, String toolName, Collection<FileObject> installFolders) {
        assert (toolName != null);
        for (FileObject root : installFolders) {
            FileObject tool;
            FileObject bin = root.getFileObject(folder);
            if (bin == null) continue;
            String suffix = null;
            if (Utilities.isWindows()) {
                suffix = toolName.indexOf(46) != -1 ? suffix : "exe";
                tool = bin.getFileObject(toolName, suffix);
                if (tool != null) {
                    return tool;
                }
                suffix = toolName.indexOf(46) != -1 ? suffix : "bat";
                tool = bin.getFileObject(toolName, suffix);
                if (tool == null) continue;
                return tool;
            }
            suffix = toolName.indexOf(46) != -1 ? suffix : null;
            tool = bin.getFileObject(toolName, suffix);
            if (tool != null) {
                return tool;
            }
            suffix = toolName.indexOf(46) != -1 ? suffix : "sh";
            tool = bin.getFileObject(toolName, suffix);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public static String getExtensions(String extPath) {
        if (extPath == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tk = new StringTokenizer(extPath, File.pathSeparator);
        while (tk.hasMoreTokens()) {
            File extFolder = FileUtil.normalizeFile((File)new File(tk.nextToken()));
            File[] files = extFolder.listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (!f.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), f, extFolder));
                    continue;
                }
                FileObject fo = FileUtil.toFileObject((File)f);
                assert (fo != null) : "Must have defined a FileObject for existent file " + f;
                if (!FileUtil.isArchiveFile((FileObject)fo)) continue;
                sb.append(File.pathSeparator);
                sb.append(f.getAbsolutePath());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion("1.2");
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static boolean isArchiveFile(File f) {
        String fileName = f.getName().toLowerCase();
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }
}

