/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.spi.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.simpleunit.spi.wizard.UnitTestTemplates;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnitTestIterator
implements TemplateWizard.Iterator {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private TemplateWizard wizard;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index = 0;
    public static final String CND_UNITTEST_DEFAULT_NAME = "UnitTestDefaultName";
    public static final String CND_UNITTEST_FUNCTIONS = "UnitTestFunctions";
    public static final String CND_UNITTEST_LOOKUP = "UnitTestContextLookup";
    public static final String CND_UNITTEST_GENERATION = "UnitTestCodeGeneration";
    public static final String CND_UNITTEST_KIND = "UnitTestKind";
    public static final String CND_UNITTEST_KIND_CPPUNIT = "UnitTestCppUnit";

    public abstract Set<DataObject> instantiate(TemplateWizard var1) throws IOException;

    protected abstract WizardDescriptor.Panel<WizardDescriptor>[] createPanels();

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.panels == null) {
            WizardDescriptor.Panel<WizardDescriptor>[] otherPanels = this.createPanels();
            if (this.isTestGenerationMode()) {
                Lookup lookup = (Lookup)this.wizard.getProperty(CND_UNITTEST_LOOKUP);
                assert (lookup != null) : "lookup must be found in wizard.getProperty(\"UnitTestContextLookup\")";
                WizardDescriptor.Panel[] aPanels = new WizardDescriptor.Panel[otherPanels.length + 1];
                this.panels = aPanels;
                this.panels[0] = UnitTestTemplates.createFunctionsPanel(lookup, (String)this.wizard.getProperty(CND_UNITTEST_KIND));
                System.arraycopy(otherPanels, 0, this.panels, 1, otherPanels.length);
                String[] steps = new String[this.panels.length];
                for (int i = 0; i < this.panels.length; ++i) {
                    Component c = this.panels[i].getComponent();
                    steps[i] = c.getName();
                    this.setupComponent(steps, i, c);
                }
            } else {
                this.panels = otherPanels;
            }
        }
        return this.panels;
    }

    private void setupComponent(String[] steps, int i, Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void initialize(TemplateWizard wiz) {
        this.wizard = wiz;
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public final WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public final String name() {
        return "";
    }

    public final boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public final boolean hasPrevious() {
        return this.index > 0;
    }

    public final void nextPanel() {
        ++this.index;
    }

    public final void previousPanel() {
        --this.index;
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }

    protected final boolean isTestGenerationMode() {
        Boolean generate = this.wizard == null ? null : (Boolean)this.wizard.getProperty(CND_UNITTEST_GENERATION);
        return generate == null ? false : generate;
    }

    protected final TemplateWizard getWizard() {
        return this.wizard;
    }

    protected final MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project p) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return null;
        }
        return pdp.getConfigurationDescriptor();
    }

    protected final Folder getTestsRootFolder(Project project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        return testRootFolder;
    }

    protected final Folder createTestsRootFolder(Project project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
        Folder root = projectDescriptor.getLogicalFolders();
        Folder newFolder = root.addNewFolder("TestFiles", NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)"TestsFilesTxt"), false, Folder.Kind.TEST_LOGICAL_FOLDER);
        return newFolder;
    }

    protected final boolean addItemToLogicalFolder(Project project, Folder folder, DataObject dataObject) {
        FileObject file = dataObject.getPrimaryFile();
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor(project);
        if (owner != null && owner.getProjectDirectory() == project.getProjectDirectory()) {
            File ioFile = FileUtil.toFile((FileObject)file);
            if (ioFile.isDirectory()) {
                return false;
            }
            if (!makeConfigurationDescriptor.okToChange()) {
                return false;
            }
            String itemPath = MakeProjectOptions.getPathMode() == 0 ? CndPathUtilitities.toAbsoluteOrRelativePath((String)makeConfigurationDescriptor.getBaseDir(), (String)ioFile.getPath()) : (MakeProjectOptions.getPathMode() == 1 ? CndPathUtilitities.toRelativePath((String)makeConfigurationDescriptor.getBaseDir(), (String)ioFile.getPath()) : ioFile.getPath());
            itemPath = CndPathUtilitities.normalize((String)itemPath);
            Item item = new Item(itemPath);
            folder.addItemAction(item);
        }
        return true;
    }
}

