/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.util.NbBundle;

public class GameDesignPreviewComponent
extends JPanel
implements MouseListener,
PropertyChangeListener {
    private static final Color COLOR_HILITE = ColorConstants.COLOR_OUTLINE_HILITE;
    private static final Color COLOR_PLAIN = ColorConstants.COLOR_OUTLINE_PLAIN;
    private static final Color COLOR_BACKGROUND = ColorConstants.COLOR_EDITOR_PANEL;
    private GlobalRepository gameDesign;
    private Editable editable;
    private JLabel labelName;
    private JPanel panelPreview;

    public GameDesignPreviewComponent(GlobalRepository globalRepository, JComponent jComponent, String string, Editable editable) {
        this.gameDesign = globalRepository;
        this.editable = editable;
        this.addMouseListener(this);
        this.initComponents();
        this.labelName.setText(string);
        this.panelPreview.add(jComponent);
        editable.addPropertyChangeListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.editable.getName();
    }

    private void initComponents() {
        this.panelPreview = new JPanel();
        this.labelName = new JLabel();
        this.setBackground(COLOR_BACKGROUND);
        this.panelPreview.setBackground(new Color(255, 255, 255));
        this.panelPreview.setBorder(new LineBorder(new Color(163, 184, 215), 1, true));
        this.panelPreview.setLayout(new BorderLayout());
        this.labelName.setBackground(COLOR_BACKGROUND);
        this.labelName.setForeground(new Color(100, 123, 156));
        this.labelName.setHorizontalAlignment(0);
        this.labelName.setText(NbBundle.getMessage(GameDesignPreviewComponent.class, (String)"GameDesignPreviewComponent.labelName.text"));
        this.labelName.setBorder(new LineBorder(new Color(163, 184, 215), 1, true));
        this.labelName.setInheritsPopupMenu(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.panelPreview, -2, 101, -2).add(1, (Component)this.labelName, -2, 101, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.panelPreview, -2, 101, -2).addPreferredGap(0).add((Component)this.labelName, -2, 19, -2).addContainerGap()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.gameDesign.getMainView().requestEditing(this.editable);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopup(mouseEvent);
        }
    }

    private void handlePopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        List<Action> list = this.editable.getActions();
        for (Action action : list) {
            jPopupMenu.add(action);
        }
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.panelPreview.setBorder(new LineBorder(COLOR_HILITE, 1, true));
        this.labelName.setBorder(new LineBorder(COLOR_HILITE, 1, true));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.panelPreview.setBorder(new LineBorder(COLOR_PLAIN, 1, true));
        this.labelName.setBorder(new LineBorder(COLOR_PLAIN, 1, true));
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(125, 150);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.panelPreview.repaint();
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.labelName.setText((String)propertyChangeEvent.getNewValue());
        }
    }
}

