/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.ClassPreloader;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class NewProjectIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4589834546983L;
    private static final String IS_LIBRARY = "is_library";
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    ProjectPanel.WizardPanel projectPanel;
    PlatformSelectionPanel psPanel;
    ConfigurationsSelectionPanel csPanel;

    static Object create() {
        return new NewProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
                case 2: {
                    return this.psPanel;
                }
                case 3: {
                    return this.csPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.projectPanel;
                }
                case 1: {
                    return this.psPanel;
                }
                case 2: {
                    return this.csPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 3;
        }
        return this.currentIndex < 2;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        boolean create = true;
        if (!(Templates.getTemplate((WizardDescriptor)templateWizard).getAttribute("application") instanceof Boolean)) {
            create = false;
        }
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled("j2me") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("j2me");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", create ? NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileApplication") : NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileLibrary"));
        }
        this.projectPanel = new ProjectPanel.WizardPanel(create, create);
        ((JComponent)this.projectPanel.getComponent()).putClientProperty("NewProjectWizard_Title", create ? NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileApplication") : NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileLibrary"));
        this.psPanel = new PlatformSelectionPanel();
        this.csPanel = new ConfigurationsSelectionPanel();
        templateWizard.putProperty("RequiredConfiguration", null);
        templateWizard.putProperty("RequiredProfile", null);
        templateWizard.putProperty("PlatformDescription", null);
        templateWizard.putProperty("configuration_templates", null);
        templateWizard.putProperty(IS_LIBRARY, (Object)(!create ? 1 : 0));
        DataObject dao = templateWizard.getTemplate();
        templateWizard.putProperty("ProjectName", dao != null ? dao.getPrimaryFile().getName() + '1' : null);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.projectPanel = null;
        this.psPanel = null;
        this.csPanel = null;
        this.currentIndex = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        Boolean createMIDlet;
        File projectLocation = (File)templateWizard.getProperty("ProjectLocation");
        String name = (String)templateWizard.getProperty("ProjectName");
        PlatformSelectionPanel.PlatformDescription platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        if (platform == null) {
            this.psPanel.readSettings(templateWizard);
            this.psPanel.storeSettings(templateWizard);
            platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        }
        HashSet<Object> result = (createMIDlet = (Boolean)templateWizard.getProperty("CreateMidlet")) != null && createMIDlet != false ? new HashSet<DataObject>() : null;
        AntProjectHelper helper = J2MEProjectGenerator.createNewProject(projectLocation, name, platform, result, (Set)templateWizard.getProperty("configuration_templates"), (Boolean)templateWizard.getProperty(IS_LIBRARY));
        if (result == null) {
            result = new HashSet();
        }
        result.add(DataObject.find((FileObject)helper.getProjectDirectory()));
        return result;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_ConfigurationsSelection")} : new String[]{NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_ConfigurationsSelection")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }

    static {
        ClassPreloader.start();
    }
}

