/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddKeystorePanel
extends JPanel
implements ActionListener,
DocumentListener {
    static String location = System.getProperty("user.home", "");
    private DialogDescriptor dd;
    private JButton bBrowseFile;
    private JButton bBrowseLocation;
    private ButtonGroup buttonGroup;
    private JLabel lFile;
    private JLabel lLocation;
    private JLabel lName;
    private JLabel lPassword;
    private JLabel lPasswordConfirm;
    private ErrorPanel pError;
    private JRadioButton rExisting;
    private JRadioButton rNew;
    private JTextField tFile;
    private JTextField tLocation;
    private JTextField tName;
    private JPasswordField tPassword;
    private JPasswordField tPasswordConfirm;

    public AddKeystorePanel() {
        this.initComponents();
        this.initAccessibility();
        this.rNew.addActionListener(this);
        this.rExisting.addActionListener(this);
        this.tName.getDocument().addDocumentListener(this);
        this.tLocation.getDocument().addDocumentListener(this);
        this.tPassword.getDocument().addDocumentListener(this);
        this.tPasswordConfirm.getDocument().addDocumentListener(this);
        this.tFile.getDocument().addDocumentListener(this);
        this.rNew.setSelected(true);
        this.tName.setText("keystore.ks");
        this.tLocation.setText(location);
        this.tFile.setText(location);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.rNew = new JRadioButton();
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lLocation = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowseLocation = new JButton();
        this.lPassword = new JLabel();
        this.tPassword = new JPasswordField();
        this.lPasswordConfirm = new JLabel();
        this.tPasswordConfirm = new JPasswordField();
        this.rExisting = new JRadioButton();
        this.lFile = new JLabel();
        this.tFile = new JTextField();
        this.bBrowseFile = new JButton();
        this.pError = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.rNew);
        this.rNew.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rNew, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_CreateNew"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.rNew, gridBagConstraints);
        this.rNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_New"));
        this.lName.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 12, 5);
        this.add((Component)this.lName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.tName, gridBagConstraints);
        this.tName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Name"));
        this.lLocation.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.lLocation, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Folder"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseLocation, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_BrowseFolder"));
        this.bBrowseLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddKeystorePanel.this.bBrowseLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bBrowseLocation, gridBagConstraints);
        this.bBrowseLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Browse1"));
        this.lPassword.setLabelFor(this.tPassword);
        Mnemonics.setLocalizedText((JLabel)this.lPassword, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 16, 12, 5);
        this.add((Component)this.lPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 12, 0);
        this.add((Component)this.tPassword, gridBagConstraints);
        this.tPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Password"));
        this.lPasswordConfirm.setLabelFor(this.tPasswordConfirm);
        Mnemonics.setLocalizedText((JLabel)this.lPasswordConfirm, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_ConfirmPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lPasswordConfirm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPasswordConfirm, gridBagConstraints);
        this.tPasswordConfirm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Password2"));
        this.buttonGroup.add(this.rExisting);
        Mnemonics.setLocalizedText((AbstractButton)this.rExisting, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_AddExisting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 12, 0);
        this.add((Component)this.rExisting, gridBagConstraints);
        this.rExisting.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Existing"));
        this.lFile.setLabelFor(this.tFile);
        Mnemonics.setLocalizedText((JLabel)this.lFile, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tFile, gridBagConstraints);
        this.tFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Keystore"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseFile, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_BrowseFile"));
        this.bBrowseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddKeystorePanel.this.bBrowseFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bBrowseFile, gridBagConstraints);
        this.bBrowseFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Browse2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSN_AddKeystore"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore"));
    }

    protected void setDialogDescriptor(DialogDescriptor desc) {
        this.dd = desc;
        this.dd.setHelpCtx(new HelpCtx(AddKeystorePanel.class));
        this.actionPerformed(null);
    }

    public String getErrorMessage() {
        if (this.rNew.isSelected()) {
            String text = this.tName.getText();
            if (text == null || "".equals(text)) {
                return "ERR_EmptyKSFileName";
            }
            File file = new File(this.tLocation.getText());
            if (!(file.exists() && file.isDirectory() && file.canWrite())) {
                return "ERR_KSFolderNotExists";
            }
            if ((file = new File(file, text)).exists()) {
                return "ERR_KSFileExists";
            }
            try {
                file.getCanonicalPath();
            }
            catch (IOException e) {
                return "ERR_KSInvalidFile";
            }
            if (KeyStoreRepository.getDefault().getKeyStore(file.getAbsolutePath(), false) != null) {
                return "ERR_KSFileAlreadyAdded";
            }
            if (this.tPassword.getPassword().length < 6) {
                return "ERR_PasswordSmall";
            }
            if (!new String(this.tPassword.getPassword()).equals(new String(this.tPasswordConfirm.getPassword()))) {
                return "ERR_PasswordsNotEqual";
            }
        } else {
            File file = new File(this.tFile.getText());
            if (!file.exists() || !file.isFile()) {
                return "ERR_KSFileNotExists";
            }
        }
        return null;
    }

    public void checkErrors() {
        boolean valid;
        String errorMessage = this.getErrorMessage();
        this.pError.setErrorMessage(errorMessage != null ? NbBundle.getMessage(AddKeystorePanel.class, (String)errorMessage) : null);
        boolean bl = valid = errorMessage == null;
        if (this.dd != null && valid != this.dd.isValid()) {
            this.dd.setValid(valid);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected = this.rNew.isSelected();
        this.lName.setEnabled(selected);
        this.tName.setEnabled(selected);
        this.lLocation.setEnabled(selected);
        this.tLocation.setEnabled(selected);
        this.bBrowseLocation.setEnabled(selected);
        this.lPassword.setEnabled(selected);
        this.tPassword.setEnabled(selected);
        this.lPasswordConfirm.setEnabled(selected);
        this.tPasswordConfirm.setEnabled(selected);
        this.lFile.setEnabled(!selected);
        this.tFile.setEnabled(!selected);
        this.bBrowseFile.setEnabled(!selected);
        this.checkErrors();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    private void bBrowseFileActionPerformed(ActionEvent evt) {
        String file = Utils.browseFilter(this, this.tFile.getText(), NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_SelectKeystore"), 0, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (!f.isFile()) {
                    return false;
                }
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i < 0) {
                    return false;
                }
                return ".ks".equals(name = name.substring(i).toLowerCase()) || ".keystore".equals(name) || ".p12".equals(name) || ".pkcs12".equals(name) || ".jks".equals(name);
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_KeystoreFileFilter");
            }
        });
        if (file == null) {
            return;
        }
        File f = new File(file);
        location = (f = f.getParentFile()) != null ? f.getAbsolutePath() : file;
        this.tFile.setText(file);
    }

    private void bBrowseLocationActionPerformed(ActionEvent evt) {
        String folder = Utils.browseFolder(this, this.tLocation.getText(), NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_SelectKeystoresFolder"));
        if (folder == null) {
            return;
        }
        location = folder;
        this.tLocation.setText(location);
    }

    public static KeyStoreRepository.KeyStoreBean showAddKeystorePanel() {
        KeyStoreRepository.KeyStoreBean bean;
        AddKeystorePanel add = new AddKeystorePanel();
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_AddKeystore"), true, null);
        add.setDialogDescriptor(dd);
        add.checkErrors();
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() != NotifyDescriptor.OK_OPTION) {
            return null;
        }
        if (add.rNew.isSelected()) {
            String file = add.tLocation.getText() + File.separator + add.tName.getText();
            if (!file.endsWith(".ks") && !file.endsWith(".keystore")) {
                file = file + ".ks";
            }
            if ((bean = KeyStoreRepository.getDefault().getKeyStore(file, false)) == null) {
                bean = KeyStoreRepository.KeyStoreBean.create(file, new String(add.tPassword.getPassword()));
                bean.openKeyStore(true);
                KeyStoreRepository.getDefault().addKeyStore(bean);
            }
        } else {
            String file = add.tFile.getText();
            bean = KeyStoreRepository.getDefault().getKeyStore(file, true);
        }
        return bean;
    }
}

