/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.spi.moduleinfo.JPAModuleInfo;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class Util {
    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        Vector vector = new Vector();
        Util.getAllComponents(jComponent.getComponents(), vector);
        for (Component component : vector) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static SourceGroup getClassSourceGroup(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        String string2 = string.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
            if (fileObject == null) continue;
            return sourceGroup;
        }
        return null;
    }

    private static List getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (!Logger.getLogger("global").isLoggable(Level.FINE)) continue;
            Logger.getLogger("global").log(Level.FINE, null, new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
        }
        return arrayList;
    }

    public static ClassPath getFullClasspath(FileObject fileObject) {
        int n;
        FileObject[] fileObjectArray = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getRoots();
        FileObject[] fileObjectArray2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot").getRoots();
        FileObject[] fileObjectArray3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile").getRoots();
        FileObject[] fileObjectArray4 = new FileObject[fileObjectArray.length + fileObjectArray2.length + fileObjectArray3.length];
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObjectArray4[n] = fileObjectArray[n];
        }
        for (n = 0; n < fileObjectArray2.length; ++n) {
            fileObjectArray4[fileObjectArray.length + n] = fileObjectArray2[n];
        }
        for (n = 0; n < fileObjectArray3.length; ++n) {
            fileObjectArray4[fileObjectArray.length + fileObjectArray2.length + n] = fileObjectArray3[n];
        }
        return ClassPathSupport.createClassPath((FileObject[])fileObjectArray4);
    }

    public static boolean isSupportedJavaEEVersion(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        if (JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType() && ("3.1".equals(jPAModuleInfo.getVersion()) || "3.0".equals(jPAModuleInfo.getVersion()))) {
            return true;
        }
        return JPAModuleInfo.ModuleType.WEB == jPAModuleInfo.getType() && ("3.0".equals(jPAModuleInfo.getVersion()) || "2.5".equals(jPAModuleInfo.getVersion()));
    }

    public static boolean isContainerManaged(Project project) {
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        return Util.isSupportedJavaEEVersion(project) && persistenceProviderSupplier != null && persistenceProviderSupplier.supportsDefaultProvider();
    }

    public static Provider getDefaultProvider(Project project) {
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (persistenceProviderSupplier != null && persistenceProviderSupplier.supportsDefaultProvider()) {
            List<Provider> list = persistenceProviderSupplier.getSupportedProviders();
            if (list.size() > 0) {
                return list.get(0);
            }
            Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.WARNING, "Default provider support is reported without any supported providers. See: " + persistenceProviderSupplier);
        }
        return null;
    }

    public static ArrayList<Provider> getProviders(Project project) {
        ArrayList<Provider> arrayList;
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (persistenceProviderSupplier == null) {
            persistenceProviderSupplier = new DefaultPersistenceProviderSupplier();
        }
        if ((arrayList = new ArrayList<Provider>(persistenceProviderSupplier.getSupportedProviders())).size() == 0 && persistenceProviderSupplier.supportsDefaultProvider()) {
            arrayList.add(ProviderUtil.DEFAULT_PROVIDER);
        }
        Util.addProvidersFromLibraries(arrayList);
        return arrayList;
    }

    public static boolean isDefaultProvider(Project project, Provider provider) {
        return provider != null && provider.equals(Util.getDefaultProvider(project));
    }

    public static boolean isEjbModule(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType();
    }

    public static boolean isEjb21Module(Project project) {
        JPAModuleInfo jPAModuleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (jPAModuleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == jPAModuleInfo.getType() && "2.1".equals(jPAModuleInfo.getVersion());
    }

    public static boolean isJavaSE(Project project) {
        return project.getLookup().lookup(JPAModuleInfo.class) == null;
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnitUsingWizard(Project project, String string, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        Object object;
        Object object2;
        boolean bl = Util.isContainerManaged(project);
        PersistenceUnitWizardPanel persistenceUnitWizardPanel = bl ? new PersistenceUnitWizardPanelDS(project, null, true, tableGeneration) : new PersistenceUnitWizardPanelJdbc(project, null, true, tableGeneration);
        if (string != null) {
            persistenceUnitWizardPanel.setPreselectedDB(string);
        }
        final JButton jButton = new JButton(NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnitButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"ACSD_CreatePersistenceUnitButton"));
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new WrapperPanel(persistenceUnitWizardPanel), NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnit"), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
        persistenceUnitWizardPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                    jButton.setEnabled((Boolean)object);
                }
            }
        });
        if (!persistenceUnitWizardPanel.isValidPanel()) {
            dialogDescriptor.setValid(false);
            jButton.setEnabled(false);
        }
        Object object3 = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        Library library = null;
        if (object3 == jButton) {
            if (bl) {
                object2 = (PersistenceUnitWizardPanelDS)persistenceUnitWizardPanel;
                library = PersistenceLibrarySupport.getLibrary(((PersistenceUnitWizardPanelDS)object2).getSelectedProvider());
            } else {
                object2 = (PersistenceUnitWizardPanelJdbc)persistenceUnitWizardPanel;
                library = PersistenceLibrarySupport.getLibrary(((PersistenceUnitWizardPanelJdbc)object2).getSelectedProvider());
                if (library != null) {
                    Util.addLibraryToProject(project, library);
                }
                object = JDBCDriverManager.getDefault().getDrivers(((PersistenceUnitWizardPanelJdbc)object2).getPersistenceConnection().getDriverClass());
                PersistenceLibrarySupport.addDriver(project, object[0]);
            }
        }
        Object object4 = object2 = library != null ? PersistenceUtils.getJPAVersion(library) : PersistenceUtils.getJPAVersion(project);
        if (object3 == jButton) {
            object = null;
            object = "2.0".equals(object2) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
            if (bl) {
                PersistenceUnitWizardPanelDS persistenceUnitWizardPanelDS = (PersistenceUnitWizardPanelDS)persistenceUnitWizardPanel;
                if (persistenceUnitWizardPanelDS.getDatasource() != null && !"".equals(persistenceUnitWizardPanelDS.getDatasource().trim())) {
                    if (persistenceUnitWizardPanelDS.isJTA()) {
                        object.setJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                    } else {
                        if (persistenceUnitWizardPanelDS.isNonDefaultProviderEnabled()) {
                            object.setNonJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                        }
                        object.setTransactionType("RESOURCE_LOCAL");
                    }
                }
                if (persistenceUnitWizardPanelDS.isNonDefaultProviderEnabled()) {
                    object.setProvider(persistenceUnitWizardPanelDS.getNonDefaultProvider());
                }
            } else {
                PersistenceUnitWizardPanelJdbc persistenceUnitWizardPanelJdbc = (PersistenceUnitWizardPanelJdbc)persistenceUnitWizardPanel;
                object = ProviderUtil.buildPersistenceUnit(persistenceUnitWizardPanelJdbc.getPersistenceUnitName(), persistenceUnitWizardPanelJdbc.getSelectedProvider(), persistenceUnitWizardPanelJdbc.getPersistenceConnection(), (String)object2);
                object.setTransactionType("RESOURCE_LOCAL");
            }
            object.setName(persistenceUnitWizardPanel.getPersistenceUnitName());
            ProviderUtil.setTableGeneration((org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)object, persistenceUnitWizardPanel.getTableGeneration(), project);
            return object;
        }
        return null;
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnitUsingData(Project project, String string, String string2, PersistenceUnitWizardPanel.TableGeneration tableGeneration, Provider provider) {
        Library library;
        boolean bl = Util.isContainerManaged(project);
        if (provider == null) {
            library = Util.getProviders(project);
            provider = library.get(0);
        }
        library = null;
        if (bl) {
            library = PersistenceLibrarySupport.getLibrary(provider);
        } else {
            library = PersistenceLibrarySupport.getLibrary(provider);
            if (library != null) {
                Util.addLibraryToProject(project, library);
            }
        }
        String string3 = library != null ? PersistenceUtils.getJPAVersion(library) : PersistenceUtils.getJPAVersion(project);
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = null;
        persistenceUnit = "2.0".equals(string3) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
        if (bl) {
            JPADataSourceProvider jPADataSourceProvider;
            if ((string2 == null || string2.trim().equals("")) && (jPADataSourceProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class)).getDataSources().size() > 0) {
                string2 = jPADataSourceProvider.getDataSources().get(0).getDisplayName();
            }
            if (string2 != null && !"".equals(string2.trim())) {
                persistenceUnit.setJtaDataSource(string2);
            }
            if (!(provider instanceof DefaultProvider)) {
                persistenceUnit.setProvider(provider.getProviderClass());
            }
        } else {
            DatabaseConnection databaseConnection = null;
            if (string2 != null && !string2.trim().equals("")) {
                databaseConnection = ConnectionManager.getDefault().getConnection(string2);
            }
            if (databaseConnection == null) {
                ConnectionManager connectionManager = ConnectionManager.getDefault();
                DatabaseConnection[] databaseConnectionArray = connectionManager.getConnections();
                databaseConnection = databaseConnectionArray != null && databaseConnectionArray.length > 0 ? databaseConnectionArray[0] : null;
            }
            persistenceUnit = ProviderUtil.buildPersistenceUnit("tmp", provider, databaseConnection, string3);
            persistenceUnit.setTransactionType("RESOURCE_LOCAL");
        }
        if (string == null) {
            string = Util.getCandidateName(project);
        }
        persistenceUnit.setName(string);
        ProviderUtil.setTableGeneration(persistenceUnit, tableGeneration != null ? tableGeneration.name() : PersistenceUnitWizardPanel.TableGeneration.NONE.name(), project);
        return persistenceUnit;
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String string, PersistenceUnitWizardPanel.TableGeneration tableGeneration) throws InvalidPersistenceXmlException {
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = Util.buildPersistenceUnitUsingWizard(project, string, tableGeneration);
        if (persistenceUnit == null) {
            return false;
        }
        String string2 = persistenceUnit instanceof PersistenceUnit ? "2.0" : "1.0";
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project, string2);
        if (pUDataObject == null) {
            return false;
        }
        pUDataObject.addPersistenceUnit(persistenceUnit);
        pUDataObject.save();
        return true;
    }

    public static void addPersistenceUnitToProject(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        String string = persistenceUnit.getProvider();
        if (string != null) {
            Provider provider = ProviderUtil.getProvider(string, project);
            Library library = PersistenceLibrarySupport.getLibrary(provider);
            if (library != null) {
                if (!Util.isDefaultProvider(project, provider)) {
                    Util.addLibraryToProject(project, library);
                } else if (provider.getAnnotationProcessor() != null) {
                    Util.addLibraryToProject(project, library, "classpath/processor");
                }
            }
            if (!Util.isContainerManaged(project)) {
                DatabaseConnection databaseConnection = ProviderUtil.getConnection(persistenceUnit);
                if (databaseConnection != null) {
                    JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(databaseConnection.getDriverClass());
                    PersistenceLibrarySupport.addDriver(project, jDBCDriverArray[0]);
                } else {
                    Logger.getLogger("global").log(Level.INFO, "Can't find connection for persistence unit");
                }
            }
        }
        try {
            ProviderUtil.addPersistenceUnit(persistenceUnit, project);
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
        }
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String string) throws InvalidPersistenceXmlException {
        return Util.createPersistenceUnitUsingWizard(project, string, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public static void addLibraryToProject(Project project, Library library) {
        Util.addLibraryToProject(project, library, "classpath/compile");
    }

    public static void addLibraryToProject(Project project, Library library, String string) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        SourceGroup sourceGroup = sourceGroupArray[0];
        FileObject fileObject = sourceGroup.getRootFolder();
        try {
            ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)string);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.FINE, "Can't add library to the project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Logger.getLogger("global").log(Level.FINE, "Can't add library to the project", unsupportedOperationException);
        }
    }

    private static void addProvidersFromLibraries(List<Provider> list) {
        for (Provider provider : PersistenceLibrarySupport.getProvidersFromLibraries()) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Provider provider2 = list.get(i);
                if (!(provider2 instanceof Provider) || !provider.equals(provider2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(provider);
        }
    }

    private static final String getCandidateName(Project project) {
        String string = ProjectUtils.getInformation((Project)project).getName() + "PU";
        try {
            if (!ProviderUtil.persistenceExists(project)) {
                return string;
            }
            PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
            Persistence persistence = pUDataObject.getPersistence();
            int n = 2;
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] persistenceUnitArray = persistence.getPersistenceUnit();
            String string2 = string;
            while (!Util.isUnique(string2, persistenceUnitArray)) {
                string2 = string + n++;
            }
            return string2;
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            Logger.getLogger("global").log(Level.FINE, "Invalid persistence.xml found", invalidPersistenceXmlException);
            return string;
        }
    }

    private static boolean isUnique(String string, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] persistenceUnitArray) {
        for (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit : persistenceUnitArray) {
            if (!string.equals(persistenceUnit.getName())) continue;
            return false;
        }
        return true;
    }

    private static class DefaultPersistenceProviderSupplier
    implements PersistenceProviderSupplier {
        private DefaultPersistenceProviderSupplier() {
        }

        @Override
        public List<Provider> getSupportedProviders() {
            return Collections.emptyList();
        }

        @Override
        public boolean supportsDefaultProvider() {
            return false;
        }
    }
}

