/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.openide.util.Utilities;

public abstract class EntityMember {
    private String memberName;
    private String memberClass;

    public static String makeFieldName(String string) {
        StringBuilder stringBuilder = EntityMember.makeName(string);
        stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        String string2 = stringBuilder.toString();
        if (!Utilities.isJavaIdentifier((String)string2)) {
            string2 = string2 + '1';
        }
        return string2;
    }

    public static String makeRelationshipFieldName(String string, boolean bl) {
        return EntityMember.makeRelationshipFieldName(string, EntityRelation.CollectionType.COLLECTION, bl);
    }

    public static String makeRelationshipFieldName(String string, EntityRelation.CollectionType collectionType, boolean bl) {
        if (bl) {
            string = string + collectionType.getShortName();
        }
        return EntityMember.makeFieldName(string);
    }

    public static String fixRelationshipFieldName(String string, EntityRelation.CollectionType collectionType) {
        String string2 = string;
        if (string.endsWith("Collection")) {
            int n = string.lastIndexOf("Collection");
            string2 = string.substring(0, n) + collectionType.getShortName();
        }
        return string2;
    }

    private static StringBuilder makeName(String string) {
        if (string == null || string.length() == 0) {
            string = "a";
        }
        if (!Character.isLetter(string.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() > 0 && !Character.isLetter(stringBuilder.charAt(0))) {
                stringBuilder.deleteCharAt(0);
            }
            return EntityMember.makeName(stringBuilder.toString());
        }
        String string2 = string.toLowerCase();
        String string3 = string.toUpperCase();
        boolean bl = !string.equals(string2) && !string.equals(string3);
        return EntityMember.mapName(new StringBuilder(bl ? string : string2), !bl);
    }

    public static String makeClassName(String string) {
        StringBuilder stringBuilder = EntityMember.makeName(string);
        if (JavaPersistenceQLKeywords.isKeyword(stringBuilder.toString())) {
            stringBuilder.append('1');
        }
        stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        return stringBuilder.toString();
    }

    private static StringBuilder mapName(StringBuilder stringBuilder, boolean bl) {
        int n = 0;
        while (n < stringBuilder.length()) {
            if (!Character.isLetterOrDigit(stringBuilder.charAt(n))) {
                if (bl && n + 1 < stringBuilder.length()) {
                    stringBuilder.setCharAt(n + 1, Character.toUpperCase(stringBuilder.charAt(n + 1)));
                }
                stringBuilder.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return stringBuilder;
    }

    public static EntityMember create(ColumnElement columnElement) {
        if (columnElement == null) {
            throw new IllegalArgumentException("columnElement == null");
        }
        return new DbSchemaEntityMember(columnElement);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            throw new IllegalArgumentException("isJavaIdentifier()==false");
        }
        this.memberName = string;
    }

    public String getMemberType() {
        return this.memberClass;
    }

    public void setMemberType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("aType == null");
        }
        this.memberClass = string;
    }

    public abstract boolean isLobType();

    public abstract boolean isPrimaryKey();

    public abstract void setPrimaryKey(boolean var1, boolean var2);

    public abstract boolean isAutoIncrement();

    public abstract boolean supportsFinder();

    public abstract Integer getLength();

    public abstract Integer getPrecision();

    public abstract Integer getScale();

    public boolean equals(Object object) {
        if (object == null || !object.getClass().isInstance(this.getClass())) {
            return false;
        }
        return ((EntityMember)object).getMemberName().equals(this.getMemberName());
    }

    public int hashCode() {
        return this.getMemberName().hashCode();
    }

    public abstract boolean isNullable();

    public abstract String getColumnName();

    public abstract String getTableName();
}

