/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StringSelector
extends JPanel
implements MouseListener {
    private List<String> choices;
    private JScrollPane jScrollPane;
    private JList listValues;
    private JPanel optionsPanel;
    private JLabel promptLabel;

    public static String select(String title, String prompt, List<String> strings) {
        StringSelector panel = new StringSelector();
        DialogDescriptor descriptor = panel.prepare(title, prompt, strings, null);
        if (descriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return null;
        }
        return (String)panel.listValues.getSelectedValue();
    }

    private DialogDescriptor prepare(String title, String prompt, List<String> strings, JPanel options) {
        Mnemonics.setLocalizedText((JLabel)this.promptLabel, (String)prompt);
        this.listValues.setSelectionMode(0);
        this.setChoices(strings);
        if (options != null) {
            this.optionsPanel.add("West", options);
        }
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, title);
        descriptor.setClosingOptions(null);
        descriptor.setHelpCtx(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringSelector.class, (String)"ACSD_StringSelectorDialog"));
        this.putClientProperty(Dialog.class, dialog);
        this.putClientProperty(DialogDescriptor.class, descriptor);
        dialog.setVisible(true);
        return descriptor;
    }

    private void setChoices(List<String> strings) {
        this.choices = strings;
        this.listValues.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return StringSelector.this.choices.size();
            }

            @Override
            public Object getElementAt(int index) {
                return StringSelector.this.choices.get(index);
            }
        });
    }

    public StringSelector() {
        this.initComponents();
        this.listValues.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && e.getClickCount() == 2) {
            Dialog dialog = (Dialog)this.getClientProperty(Dialog.class);
            DialogDescriptor descriptor = (DialogDescriptor)this.getClientProperty(DialogDescriptor.class);
            descriptor.setValue(DialogDescriptor.OK_OPTION);
            dialog.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void initComponents() {
        this.promptLabel = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.listValues = new JList();
        this.optionsPanel = new JPanel();
        this.promptLabel.setLabelFor(this.listValues);
        this.promptLabel.setText(NbBundle.getMessage(StringSelector.class, (String)"StringSelector.promptLabel.text"));
        this.listValues.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane.setViewportView(this.listValues);
        this.listValues.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringSelector.class, (String)"ACSN_StringSelectorMessages"));
        this.listValues.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringSelector.class, (String)"ACSD_StringSelectorMessages"));
        this.optionsPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.optionsPanel, -1, 645, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.promptLabel, -1, 549, Short.MAX_VALUE).add(96, 96, 96)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane, -1, 633, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.promptLabel).addPreferredGap(0).add((Component)this.jScrollPane, -1, 318, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.optionsPanel, -2, -1, -2).addContainerGap()));
    }

    public static class RecentMessageSelector
    extends StringSelector {
        private final Preferences prefs;
        private static final String KEY = "recentmessages.autofill";

        public RecentMessageSelector(Preferences prefs) {
            this.prefs = prefs;
        }

        public boolean isAutoFill() {
            return this.prefs.getBoolean(KEY, true);
        }

        public void setAutoFill(boolean value) {
            this.prefs.putBoolean(KEY, value);
        }

        public String getRecentMessage(String title, String prompt, List<String> strings) {
            StringSelector panel = new StringSelector();
            JPanel options = new JPanel(new BorderLayout());
            JCheckBox autoFillCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)autoFillCheckBox, (String)NbBundle.getMessage(RecentMessageSelector.class, (String)"RecentMessageSelector.autoFill"));
            autoFillCheckBox.setSelected(this.isAutoFill());
            options.add("Before", autoFillCheckBox);
            DialogDescriptor descriptor = panel.prepare(title, prompt, strings, options);
            if (descriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return null;
            }
            this.setAutoFill(autoFillCheckBox.isSelected());
            return (String)panel.listValues.getSelectedValue();
        }
    }
}

