/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.InheritAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.OverrideAnnotation;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.loaders.DataObject;

public class ComputeAnnotations {
    private final CsmProject csmProject;
    private final CsmFile csmFile;
    private final StyledDocument doc;
    private final DataObject dobj;

    public static ComputeAnnotations getInstance(CsmFile csmFile, StyledDocument doc, DataObject dobj) {
        return new ComputeAnnotations(csmFile, doc, dobj);
    }

    private ComputeAnnotations(CsmFile csmFile, StyledDocument doc, DataObject dobj) {
        this.csmFile = csmFile;
        this.csmProject = csmFile.getProject();
        this.doc = doc;
        this.dobj = dobj;
    }

    void computeAnnotations(Collection<BaseAnnotation> toAdd) {
        this.computeAnnotations(this.csmFile.getDeclarations(), toAdd);
    }

    private void computeAnnotations(Collection<? extends CsmOffsetableDeclaration> toProcess, Collection<BaseAnnotation> toAdd) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : toProcess) {
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                this.computeAnnotation((CsmFunction)csmOffsetableDeclaration, toAdd);
                continue;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
                this.computeAnnotation((CsmClass)csmOffsetableDeclaration, toAdd);
                this.computeAnnotations(((CsmClass)csmOffsetableDeclaration).getMembers(), toAdd);
                continue;
            }
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            this.computeAnnotations(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), toAdd);
        }
    }

    private void computeAnnotation(CsmFunction func, Collection<BaseAnnotation> toAdd) {
        if (CsmKindUtilities.isMethod((CsmObject)func)) {
            CsmMethod meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)func);
            Collection baseMethods = CsmVirtualInfoQuery.getDefault().getFirstBaseDeclarations(meth);
            List overriddenMethods = !baseMethods.isEmpty() || CsmVirtualInfoQuery.getDefault().isVirtual(meth) ? CsmVirtualInfoQuery.getDefault().getOverriddenMethods(meth, false) : Collections.emptyList();
            if (BaseAnnotation.LOGGER.isLoggable(Level.FINEST)) {
                BaseAnnotation.LOGGER.log(Level.FINEST, "Found {0} base decls for {1}", new Object[]{baseMethods.size(), ComputeAnnotations.toString(func)});
                for (CsmMethod baseMethod : baseMethods) {
                    BaseAnnotation.LOGGER.log(Level.FINEST, "    {0}", ComputeAnnotations.toString((CsmFunction)baseMethod));
                }
            }
            baseMethods.remove(meth);
            if (!baseMethods.isEmpty() || !overriddenMethods.isEmpty()) {
                toAdd.add(new OverrideAnnotation(this.doc, func, (Collection<? extends CsmOffsetableDeclaration>)baseMethods, overriddenMethods));
            }
        }
    }

    private void computeAnnotation(CsmClass cls, Collection<BaseAnnotation> toAdd) {
        Collection subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false);
        if (!subRefs.isEmpty()) {
            ArrayList<CsmClass> subClasses = new ArrayList<CsmClass>(subRefs.size());
            for (CsmReference ref : subRefs) {
                CsmObject obj = ref.getReferencedObject();
                CndUtils.assertTrue((obj == null || obj instanceof CsmClass ? 1 : 0) != 0, (String)"getClassifier() should return either null or CsmClass");
                if (!(obj instanceof CsmClass)) continue;
                subClasses.add((CsmClass)obj);
            }
            if (!subClasses.isEmpty()) {
                toAdd.add(new InheritAnnotation(this.doc, cls, subClasses));
            }
        }
    }

    private static CharSequence toString(CsmFunction func) {
        StringBuilder sb = new StringBuilder();
        sb.append(func.getClass().getSimpleName());
        sb.append(' ');
        sb.append(func.getQualifiedName());
        sb.append(" [");
        sb.append(func.getContainingFile().getName());
        sb.append(':');
        sb.append(func.getStartPosition().getLine());
        sb.append(']');
        return sb;
    }
}

