/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import hidden.org.codehaus.plexus.util.cli.CommandLineUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CosChecker
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    static final String NB_COS = ".netbeans_automatic_build";
    private static final String RUN_MAIN = "run.single.main";
    private static final String DEBUG_MAIN = "debug.single.main";
    private final Project project;
    static final String[] DEFAULT_INCLUDES = new String[]{"**"};

    public static ExecutionResultChecker createResultChecker() {
        return new COSExChecker();
    }

    public static ProjectOpenedHook createCoSHook(Project prj) {
        return new CosPOH(prj);
    }

    public CosChecker(Project prj) {
        this.project = prj;
    }

    @Override
    public boolean checkRunConfig(RunConfig config) {
        if (config.getProject() == null) {
            return true;
        }
        if (!this.checkRunMainClass(config)) {
            return false;
        }
        return this.checkRunTest(config);
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        if ("build".equals(config.getActionName())) {
            CosChecker.deleteCoSTimeStamp(config, true);
            CosChecker.deleteCoSTimeStamp(config, false);
            try {
                CosChecker.cleanGeneratedClassfiles(config);
            }
            catch (IOException ex) {
                if (!"clean".equals(config.getGoals().get(0))) {
                    config.getGoals().add(0, "clean");
                }
                Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Compile on Save Clean failed", ex);
            }
        } else if (!"rebuild".equals(config.getActionName())) {
            Project[] opened;
            for (Project openprj : opened = OpenProjects.getDefault().getOpenProjects()) {
                CosChecker.touchProject(openprj);
            }
        }
        return true;
    }

    private boolean hasChangedFilteredResources(boolean includeTests, long stamp, RunConfig config) {
        List res = config.getMavenProject().getResources();
        for (Resource r : res) {
            if (!r.isFiltering() || !this.hasChangedResources(r, stamp)) continue;
            return true;
        }
        if (includeTests) {
            res = config.getMavenProject().getTestResources();
            for (Resource r : res) {
                if (!r.isFiltering() || !this.hasChangedResources(r, stamp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasChangedResources(Resource r, long stamp) {
        String dir = r.getDirectory();
        File dirFile = FileUtil.normalizeFile((File)new File(dir));
        if (dirFile.exists()) {
            String[] inclds;
            ArrayList<File> toCopy = new ArrayList<File>();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(dirFile);
            String[] incls = r.getIncludes().toArray(new String[0]);
            if (incls.length > 0) {
                ds.setIncludes(incls);
            } else {
                ds.setIncludes(DEFAULT_INCLUDES);
            }
            String[] excls = r.getExcludes().toArray(new String[0]);
            if (excls.length > 0) {
                ds.setExcludes(excls);
            }
            ds.addDefaultExcludes();
            ds.scan();
            for (String inc : inclds = ds.getIncludedFiles()) {
                File f = new File(dirFile, inc);
                if (f.lastModified() < stamp) continue;
                toCopy.add(FileUtil.normalizeFile((File)f));
            }
            if (toCopy.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRunMainClass(RunConfig config) {
        String actionName = config.getActionName();
        if (RunUtils.hasApplicationCompileOnSaveEnabled(config) && ("jar".equals(((NbMavenProject)config.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()) && ("run".equals(actionName) || "debug".equals(actionName)) || RUN_MAIN.equals(actionName) || DEBUG_MAIN.equals(actionName))) {
            String action2Quick;
            boolean supported;
            ClassPathProviderImpl cpp;
            long stamp = CosChecker.getLastCoSLastTouch(config, false);
            if (this.checkImportantFiles(stamp, config)) {
                return true;
            }
            if (this.hasChangedFilteredResources(false, stamp, config)) {
                return true;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("project.name", config.getExecutionName());
            String proppath = config.getProperties().getProperty("exec.workingdir");
            if (proppath != null) {
                params.put("work.dir", FileUtil.normalizeFile((File)new File(proppath)));
            } else {
                params.put("work.dir", config.getExecutionDirectory());
            }
            if (RUN_MAIN.equals(actionName) || DEBUG_MAIN.equals(actionName)) {
                FileObject selected = config.getSelectedFileObject();
                cpp = (ClassPathProviderImpl)config.getProject().getLookup().lookup(ClassPathProviderImpl.class);
                ClassPath srcs = cpp.getProjectSourcesClassPath("classpath/source");
                String path = srcs.getResourceName(selected);
                if (path == null) {
                    return true;
                }
                params.put("execute.file", selected);
            } else {
                params.put("execute.classpath", this.createRuntimeClassPath(config.getMavenProject(), false));
            }
            String exargs = config.getProperties().getProperty("exec.args");
            if (exargs != null) {
                String[] args = RunJarPanel.splitAll(exargs);
                if (params.get("execute.file") == null) {
                    params.put("classname", args[1]);
                }
                String[] appargs = args[2].split(" ");
                params.put("application.args", Arrays.asList(appargs));
                try {
                    params.put("run.jvmargs", CosChecker.extractDebugJVMOptions(args[0]));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            cpp = (ClassPathProviderImpl)config.getProject().getLookup().lookup(ClassPathProviderImpl.class);
            params.put("platform", cpp.getJavaPlatform());
            params.put("maven.disableSources", Boolean.TRUE);
            if ((params.get("execute.file") != null || params.get("classname") != null) && (supported = JavaRunner.isSupported((String)(action2Quick = this.action2Quick(actionName)), params))) {
                try {
                    JavaRunner.execute((String)action2Quick, params);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnsupportedOperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    CosChecker.touchCoSTimeStamp(config, false);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRunTest(RunConfig config) {
        String argLine;
        String actionName = config.getActionName();
        if (!RunUtils.hasTestCompileOnSaveEnabled(config) || !"test.single".equals(actionName) && !"debug.test.single".equals(actionName)) return true;
        String testng = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test");
        if (testng == null) {
            testng = "org.testng:testng";
        }
        List deps = config.getMavenProject().getTestDependencies();
        for (Dependency d : deps) {
            if (!d.getManagementKey().startsWith(testng)) continue;
            return true;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String test = config.getProperties().getProperty("test");
        if (test == null) {
            return true;
        }
        long stamp = CosChecker.getLastCoSLastTouch(config, true);
        if (this.checkImportantFiles(stamp, config)) {
            return true;
        }
        if (this.hasChangedFilteredResources(true, stamp, config)) {
            return true;
        }
        FileObject selected = config.getSelectedFileObject();
        ClassPathProviderImpl cpp = (ClassPathProviderImpl)config.getProject().getLookup().lookup(ClassPathProviderImpl.class);
        ClassPath srcs = cpp.getProjectSourcesClassPath("classpath/source");
        ClassPath[] cps = cpp.getProjectClassPaths("classpath/source");
        ClassPath testcp = ClassPathSupport.createProxyClassPath((ClassPath[])cps);
        String path = null;
        if (selected != null) {
            path = srcs.getResourceName(selected);
            if (path != null) {
                String nameExt = selected.getNameExt().replace(".java", "Test.java");
                FileObject testFo = testcp.findResource(path = path.replace(selected.getNameExt(), nameExt));
                if (testFo == null) return true;
                selected = testFo;
            } else {
                path = testcp.getResourceName(selected);
                if (path == null) {
                    return true;
                }
            }
        } else {
            selected = testcp.findResource(test = test + ".java");
            if (selected == null) {
                List<FileObject> mainSourceRoots = Arrays.asList(srcs.getRoots());
                block14: for (FileObject root : testcp.getRoots()) {
                    if (mainSourceRoots.contains(root)) continue;
                    Enumeration fos = root.getData(true);
                    while (fos.hasMoreElements()) {
                        FileObject fo = (FileObject)fos.nextElement();
                        if (!fo.getNameExt().equals(test)) continue;
                        selected = fo;
                        break block14;
                    }
                }
            }
        }
        if (selected == null) {
            return true;
        }
        params.put("execute.file", selected);
        params.put("platform", cpp.getJavaPlatform());
        ArrayList<String> jvmProps = new ArrayList<String>();
        HashSet<String> jvmPropNames = new HashSet<String>();
        params.put("project.name", config.getExecutionName());
        String dir = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "basedir", "test");
        jvmPropNames.add("basedir");
        if (dir != null) {
            params.put("work.dir", dir);
            jvmProps.add("-Dbasedir=\"" + dir + "\"");
        } else {
            params.put("work.dir", config.getExecutionDirectory());
            jvmProps.add("-Dbasedir=\"" + config.getExecutionDirectory().getAbsolutePath() + "\"");
        }
        Properties sysProps = PluginPropertyUtils.getPluginPropertyParameter(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "systemProperties", "test");
        if (sysProps != null) {
            for (Map.Entry<Object, Object> key : sysProps.entrySet()) {
                jvmProps.add("-D" + key.getKey() + "=" + key.getValue());
                jvmPropNames.add((String)key.getKey());
            }
        }
        if (config.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : config.getProperties().entrySet()) {
                if ("maven.surefire.debug".equals(entry.getKey()) || "jpda.listen".equals(entry.getKey()) || "jpda.stopclass".equals(entry.getKey())) continue;
                if ("nb.single.run.methodName".equals(entry.getKey())) {
                    params.put("methodname", entry.getValue());
                    actionName = "test.single".equals(actionName) ? "run.single.method" : "debug.single.method";
                    continue;
                }
                if (jvmPropNames.contains((String)entry.getKey())) continue;
                jvmProps.add("-D" + entry.getKey() + "=" + entry.getValue());
                jvmPropNames.add((String)entry.getKey());
            }
        }
        if ((argLine = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "argLine", "test")) != null) {
            try {
                String[] arr = CommandLineUtils.translateCommandline((String)argLine);
                jvmProps.addAll(Arrays.asList(arr));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            argLine = config.getProperties().getProperty("argLine");
            if (argLine != null) {
                try {
                    jvmProps.addAll(CosChecker.extractDebugJVMOptions(argLine));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        String[] additionals = PluginPropertyUtils.getPluginPropertyList(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "additionalClasspathElements", "additionalClasspathElement", "test");
        ClassPath cp = this.createRuntimeClassPath(config.getMavenProject(), true);
        if (additionals != null) {
            ArrayList<URL> roots = new ArrayList<URL>();
            File base = FileUtil.toFile((FileObject)config.getProject().getProjectDirectory());
            for (String add : additionals) {
                File root = FileUtilities.resolveFilePath(base, add);
                if (root != null) {
                    try {
                        URL url = root.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            url = FileUtil.getArchiveRoot((URL)url);
                        }
                        roots.add(url);
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + add + "' to URL");
                    }
                    continue;
                }
                Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + add + "' to URL.");
            }
            ClassPath addCp = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, addCp});
        }
        params.put("execute.classpath", cp);
        params.put("run.jvmargs", jvmProps);
        params.put("maven.disableSources", Boolean.TRUE);
        String action2Quick = this.action2Quick(actionName);
        boolean supported = JavaRunner.isSupported((String)action2Quick, params);
        if (!supported) return true;
        try {
            ExecutorTask tsk = JavaRunner.execute((String)action2Quick, params);
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        finally {
            CosChecker.touchCoSTimeStamp(config, true);
            CosChecker.touchCoSTimeStamp(config, false);
        }
    }

    private static void cleanGeneratedClassfiles(RunConfig config) throws IOException {
        Project p = config.getProject();
        ArrayList<ClassPath> executePaths = new ArrayList<ClassPath>();
        for (SourceGroup g : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
            FileObject root = g.getRootFolder();
            ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
            if (cp == null) continue;
            executePaths.add(cp);
        }
        int res = JavaRunner.execute((String)"clean", Collections.singletonMap("execute.classpath", ClassPathSupport.createProxyClassPath((ClassPath[])executePaths.toArray(new ClassPath[0])))).result();
        if (res != 0) {
            throw new IOException("Failed to clean NetBeans-generated classes");
        }
    }

    private boolean checkImportantFiles(long stamp, RunConfig rc) {
        String name;
        M2Configuration m2c;
        assert (rc.getProject() != null);
        FileObject prjDir = rc.getProject().getProjectDirectory();
        if (this.isNewer(stamp, prjDir.getFileObject("pom.xml"))) {
            return true;
        }
        if (this.isNewer(stamp, prjDir.getFileObject("profiles.xml"))) {
            return true;
        }
        if (this.isNewer(stamp, prjDir.getFileObject("nbactions.xml"))) {
            return true;
        }
        M2ConfigProvider prov = (M2ConfigProvider)rc.getProject().getLookup().lookup(M2ConfigProvider.class);
        return prov != null && (m2c = prov.getActiveConfiguration()) != null && this.isNewer(stamp, prjDir.getFileObject(name = M2Configuration.getFileNameExt(m2c.getId())));
    }

    private boolean isNewer(long stamp, FileObject fo) {
        File fl;
        return fo != null && (fl = FileUtil.toFile((FileObject)fo)).lastModified() >= stamp;
    }

    private ClassPath createRuntimeClassPath(MavenProject prj, boolean test) {
        List<URI> roots = test ? TestRuntimeClassPathImpl.createPath(prj) : RuntimeClassPathImpl.createPath(prj);
        return ClassPathSupport.createClassPath(AbstractProjectClassPathImpl.getPath(roots.toArray(new URI[0])));
    }

    private static File getCoSFile(RunConfig rc, boolean test) {
        if (rc.getProject() == null) {
            return null;
        }
        return CosChecker.getCoSFile(rc.getMavenProject(), test);
    }

    private static File getCoSFile(MavenProject mp, boolean test) {
        String path;
        if (mp == null) {
            return null;
        }
        Build build = mp.getBuild();
        if (build == null) {
            return null;
        }
        String string = path = test ? build.getTestOutputDirectory() : build.getOutputDirectory();
        if (path == null) {
            return null;
        }
        File fl = new File(path);
        fl = FileUtil.normalizeFile((File)fl);
        return new File(fl, NB_COS);
    }

    private static long getLastCoSLastTouch(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl == null) {
            return 0L;
        }
        if (fl.getParentFile() == null || !fl.getParentFile().exists()) {
            return 0L;
        }
        if (!fl.exists()) {
            return Long.MAX_VALUE;
        }
        return fl.lastModified();
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, boolean test) {
        return CosChecker.touchCoSTimeStamp(rc, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, boolean test, long stamp) {
        if (rc.getProject() == null) {
            return false;
        }
        return CosChecker.touchCoSTimeStamp(rc.getMavenProject(), test, stamp);
    }

    private static boolean touchCoSTimeStamp(MavenProject mvn, boolean test) {
        return CosChecker.touchCoSTimeStamp(mvn, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(MavenProject mvn, boolean test, long stamp) {
        File fl = CosChecker.getCoSFile(mvn, test);
        if (fl == null) {
            return false;
        }
        if (fl.getParentFile() == null || !fl.getParentFile().exists()) {
            return false;
        }
        if (!fl.exists()) {
            try {
                return fl.createNewFile();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return fl.setLastModified(stamp);
    }

    private static void deleteCoSTimeStamp(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    private static void deleteCoSTimeStamp(MavenProject mp, boolean test) {
        File fl = CosChecker.getCoSFile(mp, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    static List<String> extractDebugJVMOptions(String argLine) throws Exception {
        String[] split = CommandLineUtils.translateCommandline((String)argLine);
        ArrayList<String> toRet = new ArrayList<String>();
        for (String arg : split) {
            if ("-Xdebug".equals(arg) || "-Djava.compiler=none".equals(arg) || "-Xnoagent".equals(arg) || arg.startsWith("-Xrunjdwp") || arg.trim().length() == 0) continue;
            toRet.add(arg);
        }
        return toRet;
    }

    private String action2Quick(String actionName) {
        if ("clean".equals(actionName)) {
            return "clean";
        }
        if ("run".equals(actionName) || RUN_MAIN.equals(actionName)) {
            return "run";
        }
        if ("debug".equals(actionName) || DEBUG_MAIN.equals(actionName)) {
            return "debug";
        }
        if ("test".equals(actionName) || "test.single".equals(actionName) || "run.single.method".equals(actionName)) {
            return "junit";
        }
        if ("debug.test.single".equals(actionName) || "debug.single.method".equals(actionName)) {
            return "junit-debug";
        }
        assert (false) : "Cannot convert " + actionName + " to quick actions.";
        return null;
    }

    static void touchProject(Project project) {
        NbMavenProject prj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (prj != null) {
            MavenProject mvn = prj.getMavenProject();
            if (RunUtils.hasApplicationCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mvn, false);
            } else {
                CosChecker.deleteCoSTimeStamp(mvn, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mvn, true);
            } else {
                CosChecker.deleteCoSTimeStamp(mvn, true);
            }
        }
    }

    private static class COSExChecker
    implements ExecutionResultChecker {
        private COSExChecker() {
        }

        @Override
        public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                CosChecker.touchCoSTimeStamp(config, false);
            } else {
                CosChecker.deleteCoSTimeStamp(config, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(config)) {
                CosChecker.touchCoSTimeStamp(config, true);
            } else {
                CosChecker.deleteCoSTimeStamp(config, true);
            }
        }
    }

    static class CosPOH
    extends ProjectOpenedHook {
        private final Project project;

        CosPOH(Project prj) {
            this.project = prj;
        }

        protected void projectOpened() {
            CosChecker.touchProject(this.project);
        }

        protected void projectClosed() {
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (prj != null) {
                MavenProject mvn = prj.getMavenProject();
                CosChecker.deleteCoSTimeStamp(mvn, true);
                CosChecker.deleteCoSTimeStamp(mvn, false);
            }
        }
    }
}

