/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.types.Time;

public final class DataTableMetadataFilterSupport {
    private static DataTableMetadataFilterSupport instance;

    private DataTableMetadataFilterSupport() {
    }

    public static final synchronized DataTableMetadataFilterSupport getInstance() {
        if (instance == null) {
            instance = new DataTableMetadataFilterSupport();
        }
        return instance;
    }

    private final Collection<DataTableMetadataFilter> createFilters(List<DataTableMetadata.Column> columns, TimeIntervalDataFilter filter) {
        ArrayList<DataTableMetadataFilter> result = new ArrayList<DataTableMetadataFilter>();
        for (DataTableMetadata.Column c : columns) {
            try {
                c.getColumnClass().asSubclass(Time.class);
                result.add(new DataTableMetadataFilter(c, filter));
            }
            catch (ClassCastException e) {}
        }
        return result;
    }

    public final Collection<DataTableMetadataFilter> createFilters(DataTableMetadata metadata, TimeIntervalDataFilter filter) {
        ArrayList<DataTableMetadataFilter> result = new ArrayList<DataTableMetadataFilter>();
        List<DataTableMetadata> sourceTables = metadata.getSourceTables();
        if (sourceTables == null) {
            List<DataTableMetadata.Column> columns = metadata.getColumns();
            result.addAll(this.createFilters(columns, filter));
            return result;
        }
        for (DataTableMetadata table : sourceTables) {
            result.addAll(this.createFilters(table.getColumns(), filter));
        }
        return result;
    }
}

