/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.xml;

import java.util.Stack;
import oracle.toplink.essentials.platform.xml.XMLPlatform;
import oracle.toplink.essentials.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentBuilder
implements ContentHandler {
    private Document document;
    private Stack nodes = new Stack();
    private XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();

    public Document getDocument() {
        return this.document;
    }

    public Document getInitializedDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = this.xmlPlatform.createDocument();
                this.nodes.push(this.document);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.document = this.xmlPlatform.createDocument();
            this.nodes.push(this.document);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        this.nodes.pop();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (null != namespaceURI && "".equals(namespaceURI)) {
            namespaceURI = null;
        }
        Element element = this.getInitializedDocument().createElementNS(namespaceURI, qName);
        Node parentNode = (Node)this.nodes.peek();
        parentNode.appendChild(element);
        this.nodes.push(element);
        int numberOfAttributes = atts.getLength();
        for (int x = 0; x < numberOfAttributes; ++x) {
            element.setAttributeNS(atts.getURI(x), atts.getQName(x), atts.getValue(x));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.nodes.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String characters = new String(ch, start, length);
        if (characters.trim().length() == 0) {
            return;
        }
        Text text = this.getInitializedDocument().createTextNode(characters);
        Node parentNode = (Node)this.nodes.peek();
        parentNode.appendChild(text);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction pi = this.getInitializedDocument().createProcessingInstruction(target, data);
        Node parentNode = (Node)this.nodes.peek();
        parentNode.appendChild(pi);
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

