/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.BinaryOperatorNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class EqualsNode
extends BinaryOperatorNode {
    public void validate(ParseTreeContext context) {
        super.validate(context);
        TypeHelper typeHelper = context.getTypeHelper();
        Object leftType = this.left.getType();
        Object rightType = this.right.getType();
        if (typeHelper.isEnumType(leftType) && !typeHelper.isEnumType(rightType)) {
            throw EJBQLException.invalidEnumEqualExpression(context.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(leftType), typeHelper.getTypeName(rightType));
        }
        if (typeHelper.isEnumType(rightType) && !typeHelper.isEnumType(leftType)) {
            throw EJBQLException.invalidEnumEqualExpression(context.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(rightType), typeHelper.getTypeName(leftType));
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = whereClause.equal(this.getRight().generateExpression(context));
        return whereClause;
    }

    public String getAsString() {
        return this.left.getAsString() + " = " + this.right.getAsString();
    }
}

