/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.ejb.cmp3.persistence.ArchiveFactoryImpl;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataPersistenceUnit;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLClassAccessor;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataLogger m_logger;
    protected MetadataProject m_project;
    protected MetadataValidator m_validator;
    protected AbstractSession m_session;

    public MetadataProcessor(PersistenceUnitInfo puInfo, AbstractSession session, ClassLoader loader, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_session = session;
        this.m_logger = new MetadataLogger(session);
        this.m_project = new MetadataProject(puInfo, session, enableLazyForOneToOne);
    }

    public MetadataProcessor(AbstractSession session, ClassLoader loader, Collection<Class> entities, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_project = new MetadataProject(null, session, enableLazyForOneToOne);
        this.m_session = session;
        HashSet<String> entityNames = new HashSet<String>(entities.size());
        for (Class entity : entities) {
            this.m_project.addDescriptor(new MetadataDescriptor(entity));
            entityNames.add(entity.getName());
        }
        this.m_project.setEntityNames(entityNames);
        this.m_logger = new MetadataLogger(session);
    }

    public void addEntityListeners() {
        for (MetadataDescriptor descriptor : this.m_project.getDescriptors()) {
            ClassAccessor accessor = descriptor.getClassAccessor();
            descriptor.setJavaClass(descriptor.getClassDescriptor().getJavaClass());
            accessor.setAnnotatedElement(descriptor.getJavaClass());
            accessor.clearMappedSuperclasses();
            accessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processNamedQueries(this.m_validator);
        this.m_project.processNamedNativeQueries(this.m_loader);
    }

    private static Set<String> buildEntityClassSetFromXMLDocument(Document document, String fileName, ClassLoader loader) {
        XMLHelper helper = new XMLHelper(document, fileName, loader);
        String defaultPkg = helper.getNodeValue(new String[]{"entity-mappings", "package", "text()"});
        HashSet<String> classSet = new HashSet<String>();
        classSet.addAll(MetadataProcessor.buildEntityClassSetForNodeList(helper, "entity", defaultPkg));
        return classSet;
    }

    private static Set<String> buildEntityClassSetForNodeList(XMLHelper helper, String xPath, String defaultPkg) {
        HashSet<String> classNames = new HashSet<String>();
        NodeList nodes = helper.getNodes("entity-mappings", xPath);
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            classNames.add(XMLHelper.getFullyQualifiedClassName(helper.getNode(nodes.item(i), "@class").getNodeValue(), defaultPkg));
        }
        return classNames;
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public MetadataValidator getValidator() {
        return this.m_validator;
    }

    public void processAnnotations() {
        this.m_validator = new MetadataValidator();
        for (MetadataDescriptor descriptor : this.m_project.getDescriptors().toArray(new MetadataDescriptor[0])) {
            ClassAccessor accessor = descriptor.getClassAccessor();
            if (accessor != null) continue;
            accessor = new ClassAccessor(new MetadataClass(descriptor.getJavaClass()), this, descriptor);
            descriptor.setClassAccessor(accessor);
            accessor.process();
        }
        this.m_project.process();
    }

    public void processPersistenceUnitMetadata() {
        for (Map.Entry<URL, Document> mfDocPair : this.m_project.getMappingFiles().entrySet()) {
            MetadataPersistenceUnit existingPersistenceUnit;
            Class cls;
            Node node;
            int i;
            XMLHelper helper = new XMLHelper(mfDocPair.getValue(), mfDocPair.getKey().getFile(), this.m_loader);
            NodeList nodes = helper.getNodes("entity-mappings", "mapped-superclass");
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                cls = helper.getNodeValue(nodes.item(i), "@class", Void.TYPE);
                this.m_project.addMappedSuperclass(cls, node, helper);
            }
            nodes = helper.getNodes("entity-mappings", "embeddable");
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                cls = helper.getNodeValue(nodes.item(i), "@class", Void.TYPE);
                this.m_project.addEmbeddable(cls, node, helper);
            }
            Node persistenceUnitMetadataNode = helper.getNode(new String[]{"entity-mappings", "persistence-unit-metadata"});
            if (persistenceUnitMetadataNode == null) continue;
            MetadataPersistenceUnit persistenceUnit = new MetadataPersistenceUnit();
            persistenceUnit.setIsMetadataComplete(helper.getNode(persistenceUnitMetadataNode, "xml-mapping-metadata-complete") != null);
            Node persistenceUnitDefaultsNode = helper.getNode(persistenceUnitMetadataNode, "persistence-unit-defaults");
            if (persistenceUnitDefaultsNode != null) {
                persistenceUnit.setAccess(helper.getNodeTextValue(persistenceUnitDefaultsNode, "access"));
                persistenceUnit.setSchema(helper.getNodeTextValue(persistenceUnitDefaultsNode, "schema"));
                persistenceUnit.setCatalog(helper.getNodeTextValue(persistenceUnitDefaultsNode, "catalog"));
                persistenceUnit.setIsCascadePersist(helper.getNode(persistenceUnitDefaultsNode, "cascade-persist") != null);
                NodeList listenerNodes = helper.getNodes(persistenceUnitDefaultsNode, "entity-listeners", "entity-listener");
                if (listenerNodes != null) {
                    this.m_project.addDefaultListeners(listenerNodes, helper);
                }
            }
            if ((existingPersistenceUnit = this.m_project.getPersistenceUnit()) != null) {
                if (existingPersistenceUnit.equals(persistenceUnit)) continue;
                new XMLValidator().throwPersistenceUnitMetadataConflict(existingPersistenceUnit.getConflict());
                continue;
            }
            this.m_project.setPersistenceUnit(persistenceUnit);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void readMappingFiles(boolean throwExceptionOnFail) {
        this.m_validator = new XMLValidator();
        Map<URL, Document> list = this.readStandardMappingFiles();
        list.putAll(this.readExplicitlySpecifiedMappingFiles(throwExceptionOnFail));
        this.m_project.setMappingFiles(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URL, Document> readStandardMappingFiles() {
        HashMap<URL, Document> list = new HashMap<URL, Document>();
        PersistenceUnitInfo puInfo = this.m_project.getPUInfo();
        HashSet<URL> rootUrls = new HashSet<URL>(puInfo.getJarFileUrls());
        rootUrls.add(puInfo.getPersistenceUnitRootUrl());
        String ormXMLFile = "META-INF/orm.xml";
        for (URL rootURL : rootUrls) {
            this.logMessage("Searching for default mapping file in " + rootURL);
            URL ormURL = null;
            InputStream stream = null;
            try {
                Archive m_par = null;
                m_par = new ArchiveFactoryImpl().createArchive(rootURL);
                ormURL = m_par.getEntryAsURL("META-INF/orm.xml");
                stream = m_par.getEntry("META-INF/orm.xml");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (stream == null) continue;
            this.logMessage("Found a default mapping file at " + ormURL + " for root URL " + rootURL);
            try {
                Document document = XMLHelper.parseDocument(stream, ormURL.getFile(), this.m_loader);
                list.put(ormURL, document);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    private Map<URL, Document> readExplicitlySpecifiedMappingFiles(boolean throwExceptionOnFail) {
        HashMap<URL, Document> list = new HashMap<URL, Document>();
        PersistenceUnitInfo puInfo = this.m_project.getPUInfo();
        for (String mf : puInfo.getMappingFileNames()) {
            try {
                Enumeration<URL> mfURLs = this.m_loader.getResources(mf);
                if (mfURLs.hasMoreElements()) {
                    URL nextURL = mfURLs.nextElement();
                    if (mfURLs.hasMoreElements()) {
                        this.handleORMException(ValidationException.nonUniqueMappingFileName(puInfo.getPersistenceUnitName(), mf), mf, throwExceptionOnFail);
                    }
                    InputStream stream = null;
                    stream = nextURL.openStream();
                    Document document = XMLHelper.parseDocument(stream, nextURL.getFile(), this.m_loader);
                    list.put(nextURL, document);
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
                this.handleORMException(ValidationException.mappingFileNotFound(puInfo.getPersistenceUnitName(), mf), mf, throwExceptionOnFail);
            }
            catch (IOException e) {
                this.handleORMException(PersistenceUnitLoadingException.exceptionLoadingORMXML(mf, e), mf, throwExceptionOnFail);
            }
        }
        return list;
    }

    private void handleORMException(RuntimeException e, String mf, boolean throwException) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(4, "error_loading_xml_file", new Object[]{mf, e});
        } else if (!throwException) {
            this.m_session.log(4, "ejb_or_metadata", "error_loading_xml_file", new Object[]{mf, e});
        } else {
            this.m_session.handleException(e);
        }
    }

    public void buildEntityList() {
        Set<String> classNames = this.buildEntityClassSetFromAnnotations();
        classNames.addAll(this.buildEntityClassSetFromXMLDocuments());
        this.m_project.setEntityNames(classNames);
        for (String className : classNames) {
            try {
                this.m_project.addDescriptor(new MetadataDescriptor(this.m_loader.loadClass(className)));
            }
            catch (ClassNotFoundException e) {
                AbstractSessionLog.getLog().log(6, "exception_loading_entity_class", className, e);
            }
        }
    }

    private Set<String> buildEntityClassSetFromAnnotations() {
        HashSet<String> set = new HashSet<String>();
        PersistenceUnitInfo puInfo = this.m_project.getPUInfo();
        for (String className : puInfo.getManagedClassNames()) {
            if (!PersistenceUnitProcessor.isEntity(className, this.m_loader, true)) continue;
            set.add(className);
        }
        for (URL url : puInfo.getJarFileUrls()) {
            set.addAll(PersistenceUnitProcessor.getEntityClassNamesFromURL(url, this.m_loader));
        }
        if (!puInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getEntityClassNamesFromURL(puInfo.getPersistenceUnitRootUrl(), this.m_loader));
        }
        return set;
    }

    public Set<String> buildEntityClassSetFromXMLDocuments() {
        HashSet<String> classSet = new HashSet<String>();
        for (Map.Entry<URL, Document> urlToDoc : this.m_project.getMappingFiles().entrySet()) {
            classSet.addAll(MetadataProcessor.buildEntityClassSetFromXMLDocument(urlToDoc.getValue(), urlToDoc.getKey().getFile(), this.m_loader));
        }
        return classSet;
    }

    public void processMappingFiles() {
        for (Map.Entry<URL, Document> urlToDocPair : this.m_project.getMappingFiles().entrySet()) {
            this.processMappingFile(urlToDocPair.getValue(), urlToDocPair.getKey().getFile());
        }
    }

    private void processMappingFile(Document document, String fileName) {
        if (this.m_project.hasDescriptors()) {
            XMLHelper helper = new XMLHelper(document, fileName, this.m_loader);
            MetadataDescriptor desc = this.m_project.getDescriptors().iterator().next();
            XMLClassAccessor dummyAccessor = new XMLClassAccessor(new MetadataClass(desc.getJavaClass()), null, helper, this, desc);
            dummyAccessor.processEntityMappings();
            NodeList entityNodes = helper.getNodes("entity-mappings", "entity");
            if (entityNodes != null) {
                for (int i = 0; i < entityNodes.getLength(); ++i) {
                    Node entityNode = entityNodes.item(i);
                    Class entityClass = helper.getClassForNode(entityNode);
                    MetadataDescriptor descriptor = this.m_project.getDescriptor(entityClass);
                    ClassAccessor accessor = descriptor.getClassAccessor();
                    if (accessor != null) continue;
                    accessor = new XMLClassAccessor(new MetadataClass(descriptor.getJavaClass()), entityNode, helper, this, descriptor);
                    descriptor.setClassAccessor(accessor);
                    accessor.process();
                }
            }
        }
    }

    public void cleanup() {
        this.m_project.cleanup();
        this.m_loader = null;
        this.m_project = null;
        this.m_session = null;
    }

    private void logMessage(String msg) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(2, msg);
        } else {
            this.m_session.logMessage(msg);
        }
    }
}

