/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class TestRunnerInputProcessorFactory
implements ExecutionDescriptor.InputProcessorFactory {
    private static final Logger LOGGER = Logger.getLogger(TestRunnerInputProcessorFactory.class.getName());
    private final Data data;

    public TestRunnerInputProcessorFactory(Manager manager, TestSession session, boolean printSummary) {
        this.data = new Data(manager, session, printSummary);
    }

    public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
        return new TestRunnerInputProcessor(defaultProcessor, this.data);
    }

    public void refreshSession(TestSession newSession) {
        this.data.session = newSession;
    }

    private static class TestRunnerInputProcessor
    implements InputProcessor {
        private final InputProcessor delegate;
        private final Data data;

        public TestRunnerInputProcessor(InputProcessor delegate, Data data) {
            this.delegate = delegate;
            this.data = data;
        }

        public void processInput(char[] chars) throws IOException {
            this.delegate.processInput(chars);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.finish();
            this.delegate.close();
        }

        private synchronized void finish() {
            this.printSummary();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Session finished: " + this.data.session);
            }
            this.data.manager.sessionFinished(this.data.session);
        }

        private void printSummary() {
            if (!this.data.printSummary) {
                return;
            }
            ArrayList<String> output = new ArrayList<String>(2);
            output.add("");
            output.add(NbBundle.getMessage(TestRunnerInputProcessorFactory.class, (String)"MSG_TestSessionFinished", (Object)new Double((double)this.data.session.getSessionResult().getElapsedTime() / 1000.0)));
            output.add(NbBundle.getMessage(TestRunnerInputProcessorFactory.class, (String)"MSG_TestSessionFinishedSummary", (Object)this.data.session.getSessionResult().getTotal(), (Object)this.data.session.getSessionResult().getFailed(), (Object)this.data.session.getSessionResult().getErrors()));
            try {
                for (String line : output) {
                    this.delegate.processInput((line + "\n").toCharArray());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class Data {
        private final Manager manager;
        private TestSession session;
        private final boolean printSummary;

        public Data(Manager manager, TestSession session, boolean printSummary) {
            this.manager = manager;
            this.session = session;
            this.printSummary = printSummary;
        }
    }
}

