/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;

public abstract class ScreenResourceOrderingController {
    private static ArrayOrderingController arrayOrdering;
    private static DefaultOrderingController defaultOrdering;

    public static ScreenResourceOrderingController getArrayOrdering(String propertyName) {
        if (arrayOrdering == null) {
            arrayOrdering = new ArrayOrderingController(propertyName);
        }
        return arrayOrdering;
    }

    public static ScreenResourceOrderingController getDefaultOrdering() {
        if (defaultOrdering == null) {
            defaultOrdering = new DefaultOrderingController();
        }
        return defaultOrdering;
    }

    public abstract List<ScreenResourceItemPresenter> getOrdered(DesignComponent var1, Collection<ScreenResourceItemPresenter> var2);

    private static class DefaultOrderingController
    extends ScreenResourceOrderingController {
        private DefaultOrderingController() {
        }

        @Override
        public List<ScreenResourceItemPresenter> getOrdered(DesignComponent component, Collection<ScreenResourceItemPresenter> items) {
            ArrayList<ScreenResourceItemPresenter> orderedList = new ArrayList<ScreenResourceItemPresenter>(items);
            Collections.sort(orderedList, new Comparator<ScreenResourceItemPresenter>(){

                @Override
                public int compare(ScreenResourceItemPresenter item1, ScreenResourceItemPresenter item2) {
                    String name1 = InfoPresenter.getDisplayName((DesignComponent)item1.getRelatedComponent());
                    String name2 = InfoPresenter.getDisplayName((DesignComponent)item2.getRelatedComponent());
                    if (name1 == null || name2 == null) {
                        throw new NullPointerException();
                    }
                    return name1.compareTo(name2);
                }
            });
            return orderedList;
        }
    }

    private static class ArrayOrderingController
    extends ScreenResourceOrderingController {
        private String propertyName;

        private ArrayOrderingController(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public List<ScreenResourceItemPresenter> getOrdered(DesignComponent component, Collection<ScreenResourceItemPresenter> items) {
            ArrayList<ScreenResourceItemPresenter> list = new ArrayList<ScreenResourceItemPresenter>(items.size());
            if (component == null || component.readProperty(this.propertyName) == null || component.readProperty(this.propertyName).getArray() == null) {
                return list;
            }
            ArrayList array = new ArrayList(component.readProperty(this.propertyName).getArray());
            block0: for (PropertyValue value : array) {
                DesignComponent commandEventSource = value.getComponent();
                for (ScreenResourceItemPresenter descriptor : items) {
                    if (descriptor.getRelatedComponent() != commandEventSource) continue;
                    list.add(descriptor);
                    continue block0;
                }
            }
            return list;
        }
    }
}

