/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.ArchiveResources;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.NetigsoModule;
import org.netbeans.ProxyClassLoader;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class NetigsoFramework {
    private static NetigsoFramework framework;
    private static List<NetigsoModule> toInit;
    private static List<Module> toEnable;

    protected NetigsoFramework() {
        if (!this.getClass().getName().equals("org.netbeans.core.netigso.Netigso")) {
            throw new IllegalStateException();
        }
    }

    protected abstract void prepare(Lookup var1, Collection<? extends Module> var2);

    protected abstract Set<String> start(Collection<? extends Module> var1);

    protected abstract void shutdown();

    protected abstract Set<String> createLoader(ModuleInfo var1, ProxyClassLoader var2, File var3) throws IOException;

    protected abstract void reload(Module var1) throws IOException;

    protected abstract void stopLoader(ModuleInfo var1, ClassLoader var2);

    protected final byte[] fromArchive(ArchiveResources resources, String name) throws IOException {
        return JarClassLoader.archive.getData(resources, name);
    }

    static NetigsoFramework getDefault() {
        return framework;
    }

    static void willEnable(List<Module> newlyEnabling) {
        toEnable.addAll(newlyEnabling);
    }

    static Set<Module> turnOn(ClassLoader findNetigsoFrameworkIn, Collection<Module> allModules) {
        boolean found = false;
        if (framework == null) {
            for (Module m : toEnable) {
                if (!(m instanceof NetigsoModule)) continue;
                found = true;
                break;
            }
        } else {
            found = true;
        }
        if (!found) {
            return Collections.emptySet();
        }
        Lookup lkp = Lookups.metaInfServices((ClassLoader)findNetigsoFrameworkIn);
        framework = (NetigsoFramework)lkp.lookup(NetigsoFramework.class);
        if (framework == null) {
            throw new IllegalStateException("No NetigsoFramework found, is org.netbeans.core.netigso module enabled?");
        }
        NetigsoFramework.getDefault().prepare(lkp, allModules);
        toEnable.clear();
        NetigsoFramework.delayedInit();
        Set<String> cnbs = framework.start(allModules);
        if (cnbs == null) {
            return Collections.emptySet();
        }
        HashSet<Module> additional = new HashSet<Module>();
        for (Module m : allModules) {
            if (m.isEnabled() || !cnbs.contains(m.getCodeNameBase())) continue;
            additional.add(m);
        }
        return additional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean delayedInit() {
        Class<NetigsoFramework> clazz = NetigsoFramework.class;
        synchronized (NetigsoFramework.class) {
            List<NetigsoModule> init = toInit;
            toInit = null;
            if (init == null || init.isEmpty()) {
                // ** MonitorExit[var1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            for (NetigsoModule nm : init) {
                try {
                    nm.start();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }

    static synchronized void classLoaderUp(NetigsoModule nm) throws IOException {
        if (toInit != null) {
            toInit.add(nm);
            return;
        }
        nm.start();
    }

    static synchronized void classLoaderDown(NetigsoModule nm) {
        if (toInit != null) {
            toInit.remove((Object)nm);
            return;
        }
    }

    static void shutdownFramework() {
        if (framework != null) {
            framework.shutdown();
        }
        framework = null;
        toInit = new ArrayList<NetigsoModule>();
        toEnable.clear();
    }

    static {
        toInit = new ArrayList<NetigsoModule>();
        toEnable = new ArrayList<Module>();
    }
}

