/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CustomJavac
extends Javac {
    private Path processorPath;
    private boolean usingExplicitIncludes;

    public void addProcessorPath(Path cp) {
        this.processorPath = cp;
    }

    public void setIncludes(String includes) {
        super.setIncludes(includes);
        this.usingExplicitIncludes = true;
    }

    public void execute() throws BuildException {
        if (!this.usingExplicitIncludes) {
            this.cleanUpStaleClasses();
        }
        super.execute();
    }

    protected void compile() {
        if (this.processorPath != null && this.processorPath.size() > 0) {
            this.createCompilerArg().setValue("-processorpath");
            this.createCompilerArg().setPath(this.processorPath);
        }
        this.createCompilerArg().setValue("-implicit:class");
        File generatedClassesDir = new File(this.getDestdir().getParentFile(), this.getDestdir().getName() + "-generated");
        if (generatedClassesDir.isDirectory() || generatedClassesDir.mkdirs()) {
            this.createCompilerArg().setValue("-s");
            this.createCompilerArg().setFile(generatedClassesDir);
            if (generatedClassesDir.isDirectory()) {
                this.createSrc().setLocation(generatedClassesDir);
            }
        } else {
            this.log("Warning: could not create " + generatedClassesDir, 1);
        }
        super.compile();
    }

    private void cleanUpStaleClasses() {
        Date startTime;
        File d = this.getDestdir();
        if (!d.isDirectory()) {
            return;
        }
        String[] _sources = this.getSrcdir().list();
        File[] sources = new File[_sources.length];
        for (int i = 0; i < _sources.length; ++i) {
            sources[i] = new File(_sources[i]);
        }
        FileSet classes = new FileSet();
        classes.setDir(d);
        classes.setIncludes("**/*.class");
        classes.setExcludes("**/*$*.class");
        String startTimeProp = this.getProject().getProperty("module.build.started.time");
        try {
            startTime = startTimeProp != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(startTimeProp) : null;
        }
        catch (ParseException x) {
            throw new BuildException((Throwable)x);
        }
        for (String clazz : classes.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
            if (startTime != null && new File(d, clazz).lastModified() > startTime.getTime()) continue;
            String java = clazz.substring(0, clazz.length() - ".class".length()) + ".java";
            boolean found = false;
            for (File source : sources) {
                if (!new File(source, java).isFile()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.log(new File(d, clazz) + " appears to be stale, rebuilding all module sources", 1);
            Delete delete = new Delete();
            delete.setProject(this.getProject());
            delete.setOwningTarget(this.getOwningTarget());
            delete.setLocation(this.getLocation());
            FileSet deletables = new FileSet();
            deletables.setDir(d);
            delete.addFileset(deletables);
            delete.init();
            delete.execute();
            break;
        }
    }

    public void setErrorProperty(String errorProperty) {
        throw new UnsupportedOperationException();
    }

    public void setUpdatedProperty(String updatedProperty) {
        throw new UnsupportedOperationException();
    }

    public void setFailonerror(boolean fail) {
        throw new UnsupportedOperationException();
    }

    public void setFork(boolean f) {
        throw new UnsupportedOperationException();
    }
}

