/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HgProjectUtils {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";

    public static void renameProject(Project p, Object caller) {
        if (p == null) {
            return;
        }
        ContextAwareAction action = (ContextAwareAction)CommonProjectActions.renameProjectAction();
        Lookup ctx = Lookups.singleton((Object)p);
        Action ctxAction = action.createContextAwareInstance(ctx);
        ctxAction.actionPerformed(new ActionEvent(caller, 0, ""));
    }

    public static void openProject(Project p, Object caller, boolean setMain) {
        if (p == null) {
            return;
        }
        Project[] projects = new Project[]{p};
        OpenProjects.getDefault().open(projects, false);
        if (setMain) {
            OpenProjects.getDefault().setMainProject(p);
        }
        HgProjectUtils.selectAndExpandProject(p);
    }

    public static void selectAndExpandProject(final Project p) {
        if (p == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final ExplorerManager.Provider ptLogial = HgProjectUtils.access$000("projectTabLogical_tc");

            @Override
            public void run() {
                Node root = this.ptLogial.getExplorerManager().getRootContext();
                Node projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                if (projNode != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectName(File root) {
        if (root == null || !root.isDirectory()) {
            return null;
        }
        ProjectManager projectManager = ProjectManager.getDefault();
        FileObject rootFileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)root));
        if (rootFileObj == null || projectManager == null) {
            return null;
        }
        String res = null;
        if (projectManager.isProject(rootFileObj)) {
            try {
                Project prj = projectManager.findProject(rootFileObj);
                res = HgProjectUtils.getProjectName(prj);
                return res;
            }
            catch (Exception ex) {
                Mercurial.LOG.log(Level.FINE, "getProjectName() file: {0} {1}", new Object[]{rootFileObj.getPath(), ex.toString()});
            }
            finally {
                return res;
            }
        }
        return res;
    }

    public static String getProjectName(Project p) {
        if (p == null) {
            return null;
        }
        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
        return pi == null ? null : pi.getDisplayName();
    }

    private static synchronized ExplorerManager.Provider findDefault(String tcID) {
        TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
        return (ExplorerManager.Provider)tc;
    }

    private HgProjectUtils() {
    }

    static /* synthetic */ ExplorerManager.Provider access$000(String x0) {
        return HgProjectUtils.findDefault(x0);
    }
}

