/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

class GraphPainter {
    private static final Stroke BALL_STROKE = new BasicStroke(1.0f);
    private static final Stroke LINE_STROKE = new BasicStroke(DLightUIPrefs.getFloat((String)"indicator.line.thickness"));
    private static final Color H_AXIS_FONT_COLOR = DLightUIPrefs.getColor((String)"indicator.x_axis.font_color");
    private static final Color V_AXIS_FONT_COLOR = DLightUIPrefs.getColor((String)"indicator.y_axis.font_color");
    private final List<TimeSeriesDescriptor> descriptors;
    private final int seriesCount;
    private TimeSeriesDataContainer data;

    public GraphPainter(List<TimeSeriesDescriptor> descriptors, TimeSeriesDataContainer data) {
        this.descriptors = descriptors;
        this.seriesCount = descriptors.size();
        this.data = data;
    }

    public int calculateUpperLimit(float ... data) {
        float absLimit = 0.0f;
        float relLimit = 0.0f;
        block4: for (int i = 0; i < data.length; ++i) {
            float value = data[i];
            TimeSeriesDescriptor descriptor = this.descriptors.get(i);
            switch (TimeSeriesDescriptorAccessor.getDefault().getKind(descriptor)) {
                case ABS_SURFACE: 
                case LINE: {
                    absLimit = Math.max(absLimit, value);
                    continue block4;
                }
                case REL_SURFACE: {
                    relLimit += value;
                }
            }
        }
        return (int)Math.max(absLimit, relLimit);
    }

    public void paint(Graphics g, int scale, List<AxisMark> yMarks, int viewportStart, int viewportEnd, List<AxisMark> xMarks, int filterStart, int filterEnd, int x, int y, int w, int h, boolean ticks) {
        GraphPainter.paintGradient(g, x, y, w, h);
        if (0 < w && 0 < h) {
            this.paintGraph(g, scale, viewportStart, viewportEnd, x, y, w, h);
            GraphPainter.paintGrid(g, x, y, w, h, xMarks, yMarks, ticks);
            this.dimInactiveRegions(g, viewportStart, viewportEnd, filterStart, filterEnd, x, y, w, h);
        }
    }

    private static void paintGradient(Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        Color topColor = DLightUIPrefs.getColor((String)"indicator.graph.bgcolor_top");
        Color bottomColor = DLightUIPrefs.getColor((String)"indicator.graph.bgcolor_bottom");
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topColor, 0.0f, h, bottomColor);
        g2.setPaint(gradient);
        g2.fillRect(x, y, w, h);
        g2.setPaint(oldPaint);
    }

    private static void paintGrid(Graphics g, int x, int y, int w, int h, List<AxisMark> xMarks, List<AxisMark> yMarks, boolean ticks) {
        Color gridColor = DLightUIPrefs.getColor((String)"indicator.grid.color");
        Color borderColor = DLightUIPrefs.getColor((String)"indicator.border.color");
        for (AxisMark xMark : xMarks) {
            g.setColor(GraphPainter.adjustAlpha(gridColor, xMark.getMarkOpacity()));
            g.drawLine(x + xMark.getPosition(), y, x + xMark.getPosition(), y + h - 1);
        }
        if (ticks) {
            for (AxisMark xMark : xMarks) {
                g.setColor(GraphPainter.adjustAlpha(borderColor, xMark.getMarkOpacity()));
                g.drawLine(x + xMark.getPosition(), y + h - 5, x + xMark.getPosition(), y + h - 1);
            }
        }
        for (AxisMark yMark : yMarks) {
            g.setColor(GraphPainter.adjustAlpha(gridColor, yMark.getMarkOpacity()));
            g.drawLine(x, y + h - 1 - yMark.getPosition(), x + w - 1, y + h - 1 - yMark.getPosition());
        }
        if (ticks) {
            for (AxisMark yMark : yMarks) {
                g.setColor(GraphPainter.adjustAlpha(borderColor, yMark.getMarkOpacity()));
                g.drawLine(x, y + h - 1 - yMark.getPosition(), x + 5, y + h - 1 - yMark.getPosition());
            }
        }
    }

    private void paintGraph(Graphics g, int scale, int viewportStart, int viewportEnd, int x, int y, int w, int h) {
        TimeSeriesDescriptorAccessor accessor = TimeSeriesDescriptorAccessor.getDefault();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2.getStroke();
        int sampleCount = Math.min(viewportEnd + 1, this.data.size()) - viewportStart;
        if (0 < sampleCount) {
            int[] xx = new int[sampleCount + 2];
            int[] yy = new int[sampleCount + 2];
            Font yAxisFont = DLightUIPrefs.getFont((String)"indicator.y_axis.font");
            int effectiveHeight = h - 2 - yAxisFont.getSize() / 2;
            int ballSize = DLightUIPrefs.getInt((String)"indicator.ball.size");
            block4: for (int ser = 0; ser < this.seriesCount; ++ser) {
                int lastx = 0;
                int lasty = 0;
                for (int i = 0; i < sampleCount; ++i) {
                    int j;
                    float[] values = this.data.get(viewportStart + i);
                    float value = values[ser];
                    int bonus = 0;
                    if (accessor.getKind(this.descriptors.get(ser)) == TimeSeriesDescriptor.Kind.REL_SURFACE) {
                        for (j = ser + 1; j < this.seriesCount; ++j) {
                            if (accessor.getKind(this.descriptors.get(j)) != TimeSeriesDescriptor.Kind.REL_SURFACE) continue;
                            value += values[j];
                        }
                    } else if (accessor.getKind(this.descriptors.get(ser)) == TimeSeriesDescriptor.Kind.ABS_SURFACE) {
                        for (j = ser + 1; j < this.seriesCount; ++j) {
                            if (accessor.getKind(this.descriptors.get(j)) != TimeSeriesDescriptor.Kind.ABS_SURFACE) continue;
                            bonus += 2;
                        }
                    }
                    xx[i] = lastx = DLightMath.map((int)(viewportStart + i), (int)viewportStart, (int)viewportEnd, (int)x, (int)(x + w));
                    yy[i] = lasty = (int)((float)(y + h - 2) - value * (float)effectiveHeight / (float)scale) - bonus;
                }
                g2.setColor(accessor.getColor(this.descriptors.get(ser)));
                switch (accessor.getKind(this.descriptors.get(ser))) {
                    case LINE: {
                        g2.setStroke(LINE_STROKE);
                        g2.drawPolyline(xx, yy, sampleCount);
                        g2.setStroke(BALL_STROKE);
                        g2.setColor(Color.WHITE);
                        g2.fillOval(lastx - ballSize / 2, lasty - ballSize / 2, ballSize - 1, ballSize - 1);
                        g2.setColor(accessor.getColor(this.descriptors.get(ser)));
                        g2.drawOval(lastx - ballSize / 2, lasty - ballSize / 2, ballSize - 1, ballSize - 1);
                        continue block4;
                    }
                    case ABS_SURFACE: 
                    case REL_SURFACE: {
                        xx[sampleCount] = lastx;
                        xx[sampleCount + 1] = x;
                        int n = y + h;
                        yy[sampleCount + 1] = n;
                        yy[sampleCount] = n;
                        g2.fillPolygon(xx, yy, sampleCount + 2);
                        continue block4;
                    }
                    default: {
                        System.err.println("Uknown graph kind: " + (Object)((Object)accessor.getKind(this.descriptors.get(ser))));
                    }
                }
            }
        }
        g2.setStroke(oldStroke);
    }

    private void dimInactiveRegions(Graphics g, int viewportStart, int viewportEnd, int filterStart, int filterEnd, int x, int y, int w, int h) {
        int xx;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(DLightUIPrefs.getColor((String)"indicator.graph.filter.color"));
        if (viewportStart <= filterStart) {
            xx = DLightMath.map((int)filterStart, (int)viewportStart, (int)viewportEnd, (int)0, (int)w);
            g2.fillRect(x, y, xx, h);
        }
        if (filterEnd <= viewportEnd) {
            xx = DLightMath.map((int)filterEnd, (int)viewportStart, (int)viewportEnd, (int)0, (int)w);
            g2.fillRect(x + xx, y, w - xx, h);
        }
    }

    public void paintHorizontalAxis(Graphics g, int x, int y, int w, int h, List<AxisMark> marks, Color bg) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(bg);
        g2.fillRect(x, y, w, h);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        FontMetrics fm = g2.getFontMetrics();
        for (AxisMark mark : marks) {
            if (mark.getText() == null) continue;
            int length = fm.stringWidth(mark.getText());
            g.setColor(GraphPainter.adjustAlpha(H_AXIS_FONT_COLOR, mark.getTextOpacity()));
            g.drawString(mark.getText(), x + mark.getPosition() - length / 2, y + fm.getAscent());
        }
    }

    public void paintVerticalAxis(Graphics g, int x, int y, int w, int h, List<AxisMark> marks, Color bg) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(bg);
        g2.fillRect(x, y, w, h);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
        FontMetrics fm = g2.getFontMetrics();
        for (AxisMark mark : marks) {
            if (mark.getText() == null) continue;
            int length = fm.stringWidth(mark.getText());
            g.setColor(GraphPainter.adjustAlpha(V_AXIS_FONT_COLOR, mark.getTextOpacity()));
            g.drawString(mark.getText(), x + w - length - fm.getAscent() / 2, y + h - 1 - mark.getPosition() + fm.getAscent() / 2);
        }
    }

    private static Color adjustAlpha(Color orig, int alpha) {
        if (alpha == 255) {
            return orig;
        }
        return new Color(orig.getRed(), orig.getGreen(), orig.getBlue(), orig.getAlpha() * alpha / 255);
    }
}

