/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesIndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class TimeSeriesIndicatorConfiguration
extends IndicatorConfiguration {
    private String title = "";
    private int scale = 100;
    private final List<TimeSeriesDescriptor> seriesDescriptors = new ArrayList<TimeSeriesDescriptor>();
    private final List<DetailDescriptor> detailDescriptors = new ArrayList<DetailDescriptor>();
    private DataRowToTimeSeries dataRowHandler;
    private long granularity = 1000000000L;
    private Aggregation aggr = Aggregation.LAST;
    private ValueFormatter formatter;
    private boolean lastNonNull = true;
    private String persistencePrefix;

    public TimeSeriesIndicatorConfiguration(IndicatorMetadata metadata, int position) {
        super(metadata, position, true);
    }

    public String getID() {
        return "DLightTimeSeriesIndicatorConfigurationID";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private String getTitle() {
        return this.title;
    }

    public void setGraphScale(int scale) {
        this.scale = scale;
    }

    private int getGraphScale() {
        return this.scale;
    }

    public void addTimeSeriesDescriptors(TimeSeriesDescriptor ... seriesDescriptors) {
        this.seriesDescriptors.addAll(Arrays.asList(seriesDescriptors));
    }

    private List<TimeSeriesDescriptor> getTimeSeriesDescriptors() {
        return Collections.unmodifiableList(this.seriesDescriptors);
    }

    public void addDetailDescriptors(DetailDescriptor ... detailDescriptors) {
        this.detailDescriptors.addAll(Arrays.asList(detailDescriptors));
    }

    private List<DetailDescriptor> getDetailDescriptors() {
        return Collections.unmodifiableList(this.detailDescriptors);
    }

    public void setDataRowHandler(DataRowToTimeSeries dataRowHandler) {
        this.dataRowHandler = dataRowHandler;
    }

    private DataRowToTimeSeries getDataRowHandler() {
        return this.dataRowHandler;
    }

    public void setLabelFormatter(ValueFormatter formatter) {
        this.formatter = formatter;
    }

    private ValueFormatter getLabelRenderer() {
        return this.formatter;
    }

    public void setAggregation(Aggregation aggr) {
        this.aggr = aggr;
    }

    private Aggregation getAggregation() {
        return this.aggr;
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    private long getGranularity() {
        return this.granularity;
    }

    public void setLastNonNull(boolean lastNonNull) {
        this.lastNonNull = lastNonNull;
    }

    private boolean getLastNonNull() {
        return this.lastNonNull;
    }

    public void setPersistencePrefix(String persistencePrefix) {
        this.persistencePrefix = persistencePrefix;
    }

    private String getPersistencePrefix() {
        return this.persistencePrefix;
    }

    static {
        TimeSeriesIndicatorConfigurationAccessor.setDefault(new TimeSeriesIndicatorConfigurationAccessorImpl());
    }

    private static class TimeSeriesIndicatorConfigurationAccessorImpl
    extends TimeSeriesIndicatorConfigurationAccessor {
        private TimeSeriesIndicatorConfigurationAccessorImpl() {
        }

        @Override
        public String getTitle(TimeSeriesIndicatorConfiguration conf) {
            return conf.getTitle();
        }

        @Override
        public int getGraphScale(TimeSeriesIndicatorConfiguration conf) {
            return conf.getGraphScale();
        }

        @Override
        public List<TimeSeriesDescriptor> getTimeSeriesDescriptors(TimeSeriesIndicatorConfiguration conf) {
            return conf.getTimeSeriesDescriptors();
        }

        @Override
        public List<DetailDescriptor> getDetailDescriptors(TimeSeriesIndicatorConfiguration conf) {
            return conf.getDetailDescriptors();
        }

        @Override
        public DataRowToTimeSeries getDataRowHandler(TimeSeriesIndicatorConfiguration conf) {
            return conf.getDataRowHandler();
        }

        @Override
        public ValueFormatter getLabelRenderer(TimeSeriesIndicatorConfiguration conf) {
            return conf.getLabelRenderer();
        }

        @Override
        public long getGranularity(TimeSeriesIndicatorConfiguration conf) {
            return conf.getGranularity();
        }

        @Override
        public Aggregation getAggregation(TimeSeriesIndicatorConfiguration conf) {
            return conf.getAggregation();
        }

        @Override
        public boolean getLastNonNull(TimeSeriesIndicatorConfiguration conf) {
            return conf.getLastNonNull();
        }

        @Override
        public String getPersistencePrefix(TimeSeriesIndicatorConfiguration conf) {
            return conf.getPersistencePrefix();
        }
    }
}

