/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Array;
import gnu.lists.FVector;
import gnu.lists.GeneralArray1;
import gnu.lists.SimpleVector;

public class GeneralArray
extends AbstractSequence
implements Array {
    SimpleVector base;
    int[] dimensions;
    int[] strides;
    int[] lowBounds;
    static final int[] zeros = new int[8];
    int offset;
    boolean simple = true;

    public static Array makeSimple(int[] lowBounds, int[] dimensions, SimpleVector base) {
        int d = dimensions.length;
        if (lowBounds == null && d > (lowBounds = zeros).length) {
            lowBounds = new int[d];
        }
        if (d == 1 && lowBounds[0] == 0) {
            return base;
        }
        GeneralArray array = new GeneralArray();
        int[] strides = new int[d];
        int n = 1;
        int i = d;
        while (--i >= 0) {
            strides[i] = n;
            n *= dimensions[i];
        }
        array.strides = strides;
        array.dimensions = dimensions;
        array.lowBounds = lowBounds;
        array.base = base;
        return array;
    }

    public GeneralArray() {
    }

    public GeneralArray(int[] dimensions) {
        int total = 1;
        int rank = dimensions.length;
        this.lowBounds = rank <= zeros.length ? zeros : new int[rank];
        int[] strides = new int[rank];
        int i = rank;
        while (--i >= 0) {
            strides[i] = total;
            total *= dimensions[i];
        }
        this.base = new FVector(total);
        this.dimensions = dimensions;
        this.offset = 0;
    }

    @Override
    public int rank() {
        return this.dimensions.length;
    }

    @Override
    public int getEffectiveIndex(int[] indexes) {
        int result = this.offset;
        int i = this.dimensions.length;
        while (--i >= 0) {
            int index = indexes[i];
            int low = this.lowBounds[i];
            if (index < low || (index -= low) >= this.dimensions[i]) {
                throw new IndexOutOfBoundsException();
            }
            result += this.strides[i] * index;
        }
        return result;
    }

    public Object get(int index) {
        return this.getRowMajor(index);
    }

    @Override
    public int createPos(int index, boolean isAfter) {
        int total = this.offset;
        int i = this.dimensions.length;
        while (--i >= 0) {
            int dim = this.dimensions[i];
            int cur = index % dim;
            index /= dim;
            total += this.strides[i] * cur;
        }
        return total << 1 | (isAfter ? 1 : 0);
    }

    public Object getRowMajor(int index) {
        if (this.simple) {
            return this.base.get(index);
        }
        int total = this.offset;
        int i = this.dimensions.length;
        while (--i >= 0) {
            int dim = this.dimensions[i];
            int cur = index % dim;
            index /= dim;
            total += this.strides[i] * cur;
        }
        return this.base.get(total);
    }

    public Object get(int[] indexes) {
        return this.base.get(this.getEffectiveIndex(indexes));
    }

    public Object set(int[] indexes, Object value) {
        return this.base.set(this.getEffectiveIndex(indexes), value);
    }

    @Override
    public int size() {
        int total = 1;
        int i = this.dimensions.length;
        while (--i >= 0) {
            total *= this.dimensions[i];
        }
        return total;
    }

    @Override
    public int getLowBound(int dim) {
        return this.lowBounds[dim];
    }

    @Override
    public int getSize(int dim) {
        return this.dimensions[dim];
    }

    public Array transpose(int[] lowBounds, int[] dimensions, int offset0, int[] factors) {
        GeneralArray array = dimensions.length == 1 && lowBounds[0] == 0 ? new GeneralArray1() : new GeneralArray();
        array.offset = offset0;
        array.strides = factors;
        array.dimensions = dimensions;
        array.lowBounds = lowBounds;
        array.base = this.base;
        array.simple = false;
        return array;
    }

    public static void toString(Array array, StringBuffer sbuf) {
        sbuf.append("#<array");
        int r = array.rank();
        for (int i = 0; i < r; ++i) {
            sbuf.append(' ');
            int lo = array.getLowBound(i);
            int sz = array.getSize(i);
            if (lo != 0) {
                sbuf.append(lo);
                sbuf.append(':');
            }
            sbuf.append(lo + sz);
        }
        sbuf.append('>');
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        GeneralArray.toString(this, sbuf);
        return sbuf.toString();
    }
}

