/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;

public class ConsumerTarget
extends Target {
    Variable consumer;
    boolean isContextTarget;

    public ConsumerTarget(Variable consumer) {
        this.consumer = consumer;
    }

    public Variable getConsumerVariable() {
        return this.consumer;
    }

    public final boolean isContextTarget() {
        return this.isContextTarget;
    }

    public static Target makeContextTarget(Compilation comp) {
        CodeAttr code = comp.getCode();
        comp.loadCallContext();
        code.emitGetField(Compilation.typeCallContext.getDeclaredField("consumer"));
        Scope scope = code.getCurrentScope();
        Variable result = scope.addVariable(code, Compilation.typeConsumer, "$result");
        code.emitStore(result);
        ConsumerTarget target = new ConsumerTarget(result);
        target.isContextTarget = true;
        return target;
    }

    public static void compileUsingConsumer(Expression exp, Compilation comp, Target target) {
        if (target instanceof ConsumerTarget || target instanceof IgnoreTarget) {
            exp.compile(comp, target);
        } else {
            ClassType typeValues = Compilation.typeValues;
            ConsumerTarget.compileUsingConsumer(exp, comp, target, typeValues.getDeclaredMethod("make", 0), typeValues.getDeclaredMethod("canonicalize", 0));
        }
    }

    public static void compileUsingConsumer(Expression exp, Compilation comp, Target target, Method makeMethod, Method resultMethod) {
        Type ctype;
        CodeAttr code = comp.getCode();
        Scope scope = code.pushScope();
        if (makeMethod.getName() == "<init>") {
            ClassType cltype = makeMethod.getDeclaringClass();
            ctype = cltype;
            code.emitNew(cltype);
            code.emitDup(ctype);
            code.emitInvoke(makeMethod);
        } else {
            ctype = makeMethod.getReturnType();
            code.emitInvokeStatic(makeMethod);
        }
        Variable consumer = scope.addVariable(code, ctype, null);
        ConsumerTarget ctarget = new ConsumerTarget(consumer);
        code.emitStore(consumer);
        exp.compile(comp, ctarget);
        code.emitLoad(consumer);
        if (resultMethod != null) {
            code.emitInvoke(resultMethod);
        }
        code.popScope();
        target.compileFromStack(comp, resultMethod == null ? ctype : resultMethod.getReturnType());
    }

    @Override
    public void compileFromStack(Compilation comp, Type stackType) {
        this.compileFromStack(comp, stackType, -1);
    }

    void compileFromStack(Compilation comp, Type stackType, int consumerPushed) {
        char sig;
        CodeAttr code = comp.getCode();
        String methodName = null;
        Method method = null;
        Type methodArg = null;
        boolean islong = false;
        if ((stackType = stackType.getImplementationType()) instanceof PrimType) {
            sig = stackType.getSignature().charAt(0);
            switch (sig) {
                case 'B': 
                case 'I': 
                case 'S': {
                    methodName = "writeInt";
                    methodArg = Type.intType;
                    break;
                }
                case 'J': {
                    methodName = "writeLong";
                    methodArg = Type.longType;
                    islong = true;
                    break;
                }
                case 'F': {
                    methodName = "writeFloat";
                    methodArg = Type.floatType;
                    break;
                }
                case 'D': {
                    methodName = "writeDouble";
                    methodArg = Type.doubleType;
                    islong = true;
                    break;
                }
                case 'C': {
                    methodName = "append";
                    methodArg = Type.charType;
                    break;
                }
                case 'Z': {
                    methodName = "writeBoolean";
                    methodArg = Type.booleanType;
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else {
            sig = '\u0000';
            if (consumerPushed == 1 || OccurrenceType.itemCountIsOne(stackType)) {
                methodName = "writeObject";
                methodArg = Type.pointer_type;
            } else {
                method = Compilation.typeValues.getDeclaredMethod("writeValues", 2);
                code.emitLoad(this.consumer);
                if (consumerPushed == 0) {
                    code.emitSwap();
                }
                code.emitInvokeStatic(method);
                return;
            }
        }
        if (consumerPushed < 0) {
            if (islong) {
                code.pushScope();
                Variable temp = code.addLocal(stackType);
                code.emitStore(temp);
                code.emitLoad(this.consumer);
                code.emitLoad(temp);
                code.popScope();
            } else {
                code.emitLoad(this.consumer);
                code.emitSwap();
            }
        }
        if (method == null && methodName != null) {
            Type[] methodArgs = new Type[]{methodArg};
            method = Compilation.typeConsumer.getDeclaredMethod(methodName, methodArgs);
        }
        if (method != null) {
            code.emitInvokeInterface(method);
        }
        if (sig == 'C') {
            code.emitPop(1);
        }
    }

    public boolean compileWrite(Expression exp, Compilation comp) {
        Type stackType = exp.getType();
        Type implType = stackType.getImplementationType();
        if (implType instanceof PrimType && !implType.isVoid() || OccurrenceType.itemCountIsOne(implType)) {
            comp.getCode().emitLoad(this.consumer);
            Target starget = StackTarget.getInstance(stackType);
            exp.compile(comp, starget);
            this.compileFromStack(comp, implType, 1);
            return true;
        }
        return false;
    }

    @Override
    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

