/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceError;
import gnu.text.SourceMessages;
import java.io.PrintWriter;

public class SyntaxException
extends Exception {
    String header;
    SourceMessages messages;
    public int maxToPrint = 10;

    public SyntaxException(SourceMessages messages) {
        this.messages = messages;
    }

    public SyntaxException(String header, SourceMessages messages) {
        this.header = header;
        this.messages = messages;
    }

    public final String getHeader() {
        return this.header;
    }

    public final void setHeader(String header) {
        this.header = header;
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void printAll(PrintWriter out, int max) {
        if (this.header != null) {
            out.println(this.header);
        }
        this.messages.printAll(out, max);
    }

    public void clear() {
        this.messages.clear();
    }

    @Override
    public String getMessage() {
        int max = this.messages.adjustDisplayMax(this.maxToPrint);
        StringBuffer buffer = new StringBuffer();
        if (this.header != null) {
            buffer.append(this.header);
        }
        SourceError err = this.messages.firstError;
        while (err != null) {
            if (!this.messages.skipDisplayMessage(max, err)) {
                buffer.append('\n');
                buffer.append(err);
                max -= 2;
            }
            err = err.next;
        }
        return buffer.toString();
    }
}

