/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public abstract class ByteVector
extends SimpleVector
implements Externalizable,
Comparable {
    byte[] data;
    protected static byte[] empty = new byte[0];

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            byte[] tmp = new byte[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public byte[] getBuffer() {
        return this.data;
    }

    public final byte byteAt(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public final byte byteAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeInt(this.intAtBuffer(index));
        return true;
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeInt(this.intAtBuffer(i));
            ++i;
        }
    }

    public final void setByteAt(int index, byte value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setByteAtBuffer(int index, byte value) {
        this.data[index] = value;
    }

    public void copyFrom(byte[] src, int soffset, int doffset, int length) {
        if (doffset + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(src, soffset, this.data, doffset, length);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = 0;
        }
    }

    public void copyFrom(int index, ByteVector src, int start, int end) {
        int count = end - start;
        if (count < 0 || index + count > this.size || end > src.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(src.data, start, this.data, index, count);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeByte(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readByte();
        }
        this.data = data;
        this.size = size;
    }

    public int readFrom(int start, int count, InputStream in) throws IOException {
        return in.read(this.data, start, count);
    }

    public void writeTo(int start, int count, OutputStream out) throws IOException {
        out.write(this.data, start, count);
    }
}

