/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.parser;

import impl.krypt.asn1.Asn1Object;
import impl.krypt.asn1.EncodableHeader;
import impl.krypt.asn1.Length;
import impl.krypt.asn1.ParseException;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.SerializeException;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.parser.ChunkInputStream;
import impl.krypt.asn1.parser.DefiniteInputStream;
import impl.krypt.asn1.parser.PullHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ParsedHeaderImpl
implements ParsedHeader {
    private final Tag tag;
    private final Length length;
    private final InputStream in;
    private final PullHeaderParser parser;
    private byte[] cachedValue;
    private InputStream cachedValueStream;
    private boolean consumed = false;

    ParsedHeaderImpl(Tag tag, Length length, InputStream in, PullHeaderParser parser) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (length == null) {
            throw new NullPointerException();
        }
        if (in == null) {
            throw new NullPointerException();
        }
        if (parser == null) {
            throw new NullPointerException();
        }
        this.tag = tag;
        this.length = length;
        this.in = in;
        this.parser = parser;
    }

    @Override
    public void skipValue() {
        this.getValue();
    }

    @Override
    public byte[] getValue() {
        if (this.cachedValue == null) {
            if (this.consumed) {
                throw new ParseException("The stream has already been consumed");
            }
            InputStream stream = this.getValueStream(false);
            byte[] ret = this.doGetValue(stream);
            this.cachedValue = ret.length == 0 ? null : ret;
            this.cachedValueStream = null;
            this.consumed = true;
        }
        return this.cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doGetValue(InputStream stream) {
        try {
            byte[] byArray = this.consume(stream);
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public InputStream getValueStream(boolean valuesOnly) {
        if (this.consumed && this.cachedValueStream == null) {
            throw new ParseException("The stream is already consumed");
        }
        if (this.cachedValueStream == null) {
            this.cachedValueStream = this.cacheStream(valuesOnly);
            this.consumed = true;
        }
        return this.cachedValueStream;
    }

    private InputStream cacheStream(boolean valuesOnly) {
        if (this.length.isInfiniteLength()) {
            return new ChunkInputStream(this.in, this.parser, valuesOnly);
        }
        return new DefiniteInputStream(this.in, this.length.getLength());
    }

    private byte[] consume(InputStream stream) {
        byte[] buf = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int read;
            while ((read = stream.read(buf)) != -1) {
                baos.write(buf, 0, read);
            }
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        return baos.toByteArray();
    }

    @Override
    public Length getLength() {
        return this.length;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    @Override
    public int getHeaderLength() {
        return this.tag.getEncoding().length + this.length.getEncoding().length;
    }

    @Override
    public Asn1Object getObject() {
        EncodableHeader h = new EncodableHeader(this.tag, this.length);
        return new Asn1Object(h, this.getValue());
    }

    @Override
    public void encodeTo(OutputStream out) {
        try {
            out.write(this.tag.getEncoding());
            out.write(this.length.getEncoding());
        }
        catch (IOException ex) {
            throw new SerializeException(ex);
        }
    }
}

