/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ext.ripper.HeredocTerm;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.Position;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.ext.ripper.Token;
import org.jruby.ext.ripper.Warnings;
import org.jruby.lexer.yacc.StackState;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;

public class RipperLexer
implements Warnings {
    public static final Encoding UTF8_ENCODING = UTF8Encoding.INSTANCE;
    public static final Encoding USASCII_ENCODING = USASCIIEncoding.INSTANCE;
    public static final Encoding ASCII8BIT_ENCODING = ASCIIEncoding.INSTANCE;
    private static ByteList END_MARKER = new ByteList(new byte[]{95, 69, 78, 68, 95, 95});
    private static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    private static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    private static final HashMap<String, Keyword> map = new HashMap();
    private Encoding encoding;
    private List<TokenPair> delayed = new ArrayList<TokenPair>();
    public boolean ignoreNextScanEvent = false;
    private int token;
    Object yaccValue;
    String identValue;
    private LexerSource src;
    private RipperParser parser = null;
    private LexState lex_state;
    private StringBuilder tokenBuffer = new StringBuilder(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    public boolean commandStart;
    static final int EOF = -1;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private static final int str_squote = 0;
    private static final int str_dquote = 2;
    private static final int str_xquote = 2;
    private static final int str_regexp = 7;
    private static final int str_ssym = 16;
    private static final int str_dsym = 18;
    private int parenNest = 0;
    private int leftParenBegin = 0;
    private static final String magicString = "([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*";
    private static final Regex magicRegexp;
    private static final String encodingString = "[cC][oO][dD][iI][nN][gG]\\s*[=:]\\s*([a-zA-Z0-9\\-_]+)";
    private static final Regex encodingRegexp;
    private Position lastEventLocation = null;
    private byte[] mbcBuf = new byte[6];

    public Encoding getEncoding() {
        return this.encoding;
    }

    private int getFloatToken(String number) {
        try {
            double d = SafeDoubleParser.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warn(Warnings.ID.FLOAT_OUT_OF_RANGE, this.getPosition(), "Float " + number + " out of range.");
            double d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        ByteList buf = new ByteList(number.getBytes());
        this.yaccValue = new Token(buf, this.getPosition());
        return 379;
    }

    @Override
    public boolean isVerbose() {
        return this.parser.getRuntime().isVerbose();
    }

    @Override
    public void warn(Warnings.ID id2, Position position, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warn(Warnings.ID id2, String fileName, int lineNumber, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warn(Warnings.ID id2, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, Position position, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, String fileName, int lineNumber, String message2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warn(Warnings.ID id2, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warn(Warnings.ID id2, Position position, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warn(Warnings.ID id2, String fileName, int lineNumber, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, Position position, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void warning(Warnings.ID id2, String fileName, int lineNumber, String message2, Object ... data2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addDelayedValue(int token, Object value2) {
        this.delayed.add(new TokenPair(token, value2));
    }

    void dispatchAllDelayedTokens() {
        for (TokenPair pair : this.delayed) {
            this.dispatchScanEvent(pair.token, pair.value);
        }
        this.delayed.clear();
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public int incrementParenNest() {
        ++this.parenNest;
        return this.parenNest;
    }

    public int getLeftParenBegin() {
        return this.leftParenBegin;
    }

    public void setLeftParenBegin(int value2) {
        this.leftParenBegin = value2;
    }

    public RipperLexer(RipperParser parser, LexerSource src) {
        this.parser = parser;
        this.token = 0;
        this.yaccValue = null;
        this.src = src;
        this.setState(null);
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
        this.encoding = USASCII_ENCODING;
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        if (this.token == -1) {
            this.dispatchAllDelayedTokens();
            return 0;
        }
        this.dispatchScanEvent(this.token, this.yaccValue);
        return this.token;
    }

    public String getIdent() {
        return this.identValue;
    }

    public int token() {
        return this.token;
    }

    public StringBuilder getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public Position getPosition(Position startPosition, boolean inclusive) {
        return this.src.getPosition(startPosition, inclusive);
    }

    @Override
    public Ruby getRuntime() {
        return this.parser.context.getRuntime();
    }

    public Position getPosition() {
        return this.src.getPosition(null, false);
    }

    public String getCurrentLine() {
        return this.src.getCurrentLine();
    }

    public void setParser(RipperParser parserSupport) {
        this.parser = parserSupport;
    }

    private void setEncoding(ByteList name2) {
        Encoding newEncoding = this.parser.getRuntime().getEncodingService().loadEncoding(name2);
        if (newEncoding == null) {
            throw new SyntaxException(SyntaxException.PID.UNKNOWN_ENCODING, this.getPosition(), null, "unknown encoding name: " + name2.toString(), new Object[0]);
        }
        if (!newEncoding.isAsciiCompatible()) {
            throw new SyntaxException(SyntaxException.PID.NOT_ASCII_COMPATIBLE, this.getPosition(), null, name2.toString() + " is not ASCII compatible", new Object[0]);
        }
        this.setEncoding(newEncoding);
    }

    public void setEncoding(Encoding encoding2) {
        this.encoding = encoding2;
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    private void printState() {
        if (this.lex_state == null) {
            System.out.println("NULL");
        } else {
            System.out.println((Object)this.lex_state);
        }
    }

    public void setState(LexState state2) {
        this.lex_state = state2;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    private boolean isNext_identchar() throws IOException {
        int c = this.src.read();
        this.src.unread(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    private boolean isBEG() {
        return this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || this.lex_state == LexState.EXPR_VALUE;
    }

    private boolean isEND() {
        return this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || this.lex_state == LexState.EXPR_ENDFN;
    }

    private boolean isARG() {
        return this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG;
    }

    private boolean isSpaceArg(int c, boolean spaceSeen) {
        return this.isARG() && spaceSeen && !Character.isWhitespace(c);
    }

    private void determineExpressionState() {
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.setState(LexState.EXPR_ARG);
                break;
            }
            default: {
                this.setState(LexState.EXPR_BEG);
            }
        }
    }

    private Object getInteger(String value2, int radix) {
        return new Token(value2, this.getPosition());
    }

    static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public boolean isIdentifierChar(int c) {
        return Character.isLetterOrDigit(c) || c == 95 || this.isMultiByteChar(c);
    }

    protected boolean isMultiByteChar(int c) {
        return this.encoding.codeToMbcLength(c) != 1;
    }

    public IRubyObject createStr(Position position, ByteList buffer, int flags) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan(bufferEncoding, buffer);
        if ((flags & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 32 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = RipperParser.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        return this.getRuntime().newString(buffer);
    }

    private int parseQuote(int c) throws IOException {
        int end2;
        boolean shortHand;
        int begin2;
        String value2 = "%" + (char)c;
        if (!Character.isLetterOrDigit(c)) {
            begin2 = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin2 = this.src.read();
            value2 = value2 + (char)begin2;
            if (Character.isLetterOrDigit(begin2)) {
                throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), this.getCurrentLine(), "unknown type of %string", new Object[0]);
            }
        }
        if (c == -1 || begin2 == -1) {
            throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), this.getCurrentLine(), "unterminated quoted string meets end of file", new Object[0]);
        }
        switch (begin2) {
            case 40: {
                end2 = 41;
                break;
            }
            case 91: {
                end2 = 93;
                break;
            }
            case 123: {
                end2 = 125;
                break;
            }
            case 60: {
                end2 = 62;
                break;
            }
            default: {
                end2 = begin2;
                begin2 = 0;
            }
        }
        int w = this.src.read();
        while (Character.isWhitespace(w)) {
            value2 = value2 + (char)w;
            w = this.src.read();
        }
        this.src.unread(w);
        this.yaccValue = new Token(value2, this.getPosition());
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                return 365;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin2, end2);
                return 365;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, begin2, end2);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                return 368;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, begin2, end2);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                return 369;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                return 366;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin2, end2);
                return 367;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin2, end2);
                this.setState(LexState.EXPR_FNAME);
                return 364;
            }
        }
        throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), this.getCurrentLine(), "Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.", new Object[0]);
    }

    private int hereDocumentIdentifier() throws IOException {
        int term;
        ByteList markerValue;
        int c = this.src.read();
        ByteList fullMarker = new ByteList();
        fullMarker.append(60).append(60);
        int func = 0;
        if (c == 45) {
            fullMarker.append(c);
            c = this.src.read();
            func = 32;
        }
        if (c == 39 || c == 34 || c == 96) {
            fullMarker.append(c);
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            markerValue = new ByteList();
            term = c;
            while ((c = this.src.read()) != -1 && c != term) {
                fullMarker.append(c);
                markerValue.append(c);
            }
            if (c == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, this.getPosition(), this.getCurrentLine(), "unterminated here document identifier", new Object[0]);
            }
            fullMarker.append(c);
        } else {
            if (!this.isIdentifierChar(c)) {
                this.src.unread(c);
                if ((func & 0x20) != 0) {
                    this.src.unread(45);
                }
                return 0;
            }
            markerValue = new ByteList();
            term = 34;
            func |= 2;
            do {
                fullMarker.append(c);
                markerValue.append(c);
            } while ((c = this.src.read()) != -1 && this.isIdentifierChar(c));
            this.src.unread(c);
        }
        ByteList lastLine = this.src.readLineBytes();
        lastLine.append(10);
        this.dispatchScanEvent(387, fullMarker);
        this.lex_strterm = new HeredocTerm(markerValue, func, lastLine);
        if (term == 96) {
            return 366;
        }
        this.ignoreNextScanEvent = true;
        return 365;
    }

    private void arg_ambiguous() {
        this.parser.dispatch("on_arg_ambiguous");
    }

    private int magicCommentMarker(ByteList str, int begin2) {
        int i2 = begin2;
        int len = str.length();
        block4: while (i2 < len) {
            switch (str.charAt(i2)) {
                case '-': {
                    if (i2 >= 2 && str.charAt(i2 - 1) == '*' && str.charAt(i2 - 2) == '-') {
                        return i2 + 1;
                    }
                    i2 += 2;
                    continue block4;
                }
                case '*': {
                    if (i2 + 1 >= len) {
                        return -1;
                    }
                    if (str.charAt(i2 + 1) != '-') {
                        i2 += 4;
                        continue block4;
                    }
                    if (str.charAt(i2 - 1) != '-') {
                        i2 += 2;
                        continue block4;
                    }
                    return i2 + 2;
                }
            }
            i2 += 3;
        }
        return -1;
    }

    private boolean magicCommentSpecialChar(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    protected boolean parseMagicComment(ByteList magicLine) throws IOException {
        int length2 = magicLine.length();
        if (length2 <= 7) {
            return false;
        }
        int beg = this.magicCommentMarker(magicLine, 0);
        if (beg < 0) {
            return false;
        }
        int end2 = this.magicCommentMarker(magicLine, beg);
        if (end2 < 0) {
            return false;
        }
        int realSize = magicLine.getRealSize();
        int begin2 = magicLine.getBegin();
        Matcher matcher = magicRegexp.matcher(magicLine.getUnsafeBytes(), begin2, begin2 + realSize);
        int result2 = RubyRegexp.matcherSearch(this.getRuntime(), matcher, begin2, begin2 + realSize, 0);
        if (result2 < 0) {
            return false;
        }
        int[] begs = matcher.getRegion().beg;
        int[] ends = matcher.getRegion().end;
        String name2 = magicLine.subSequence(begs[1], ends[1]).toString();
        if (!name2.equalsIgnoreCase("encoding")) {
            return false;
        }
        this.setEncoding(new ByteList(magicLine.getUnsafeBytes(), begs[2], ends[2] - begs[2]));
        return true;
    }

    protected void handleFileEncodingComment(ByteList encodingLine) throws IOException {
        int realSize = encodingLine.getRealSize();
        int begin2 = encodingLine.getBegin();
        Matcher matcher = encodingRegexp.matcher(encodingLine.getUnsafeBytes(), begin2, begin2 + realSize);
        int result2 = RubyRegexp.matcherSearch(this.getRuntime(), matcher, begin2, begin2 + realSize, 1);
        if (result2 < 0) {
            return;
        }
        int[] begs = matcher.getRegion().beg;
        int[] ends = matcher.getRegion().end;
        this.setEncoding(new ByteList(encodingLine.getUnsafeBytes(), begs[1], ends[1] - begs[1]));
    }

    protected int readComment() throws IOException {
        ByteList commentBuf = new ByteList();
        commentBuf.append(35);
        boolean handledMagicComment = false;
        if (this.src.getLine() == 0 && this.token == 0) {
            ByteList commentLine;
            if (this.src.peek(33)) {
                commentBuf = this.src.readUntil('\n');
                if (!this.src.peek(35)) {
                    return 10;
                }
            }
            if ((commentLine = this.src.readLineBytesPlusNewline()) != null) {
                handledMagicComment = this.parseMagicComment(commentLine);
                if (!handledMagicComment) {
                    this.handleFileEncodingComment(commentLine);
                }
                commentBuf.append(commentLine);
                this.dispatchScanEvent(382, commentBuf);
            }
            return 0;
        }
        commentBuf.append(this.src.readLineBytesPlusNewline());
        this.dispatchScanEvent(382, commentBuf);
        return 10;
    }

    private String printToken(int token) {
        switch (token) {
            case 256: {
                return "yyErrorCode,";
            }
            case 257: {
                return "kClass,";
            }
            case 258: {
                return "kModule,";
            }
            case 259: {
                return "kDEF,";
            }
            case 260: {
                return "kUNDEF,";
            }
            case 261: {
                return "kBEGIN,";
            }
            case 262: {
                return "kRESCUE,";
            }
            case 263: {
                return "kENSURE,";
            }
            case 264: {
                return "kEND,";
            }
            case 265: {
                return "kIF,";
            }
            case 266: {
                return "kUNLESS,";
            }
            case 267: {
                return "kTHEN,";
            }
            case 268: {
                return "kELSIF,";
            }
            case 269: {
                return "kELSE,";
            }
            case 270: {
                return "kCASE,";
            }
            case 271: {
                return "kWHEN,";
            }
            case 272: {
                return "kWHILE,";
            }
            case 273: {
                return "kUNTIL,";
            }
            case 274: {
                return "kFOR,";
            }
            case 275: {
                return "kBREAK,";
            }
            case 276: {
                return "kNEXT,";
            }
            case 277: {
                return "kREDO,";
            }
            case 278: {
                return "kRETRY,";
            }
            case 279: {
                return "kIN,";
            }
            case 280: {
                return "kDO,";
            }
            case 281: {
                return "kDO_COND,";
            }
            case 282: {
                return "kDO_BLOCK,";
            }
            case 283: {
                return "kRETURN,";
            }
            case 284: {
                return "kYIELD,";
            }
            case 285: {
                return "kSUPER,";
            }
            case 286: {
                return "kSELF,";
            }
            case 287: {
                return "kNIL,";
            }
            case 288: {
                return "kTRUE,";
            }
            case 289: {
                return "kFALSE,";
            }
            case 290: {
                return "kAND,";
            }
            case 291: {
                return "kOR,";
            }
            case 292: {
                return "kNOT,";
            }
            case 293: {
                return "kIF_MOD,";
            }
            case 294: {
                return "kUNLESS_MOD,";
            }
            case 295: {
                return "kWHILE_MOD,";
            }
            case 296: {
                return "kUNTIL_MOD,";
            }
            case 297: {
                return "kRESCUE_MOD,";
            }
            case 298: {
                return "kALIAS,";
            }
            case 299: {
                return "kDEFINED,";
            }
            case 300: {
                return "klBEGIN,";
            }
            case 301: {
                return "klEND,";
            }
            case 302: {
                return "k__LINE__,";
            }
            case 303: {
                return "k__FILE__,";
            }
            case 304: {
                return "k__ENCODING__,";
            }
            case 305: {
                return "kDO_LAMBDA,";
            }
            case 306: {
                return "tIDENTIFIER[" + this.value() + "],";
            }
            case 307: {
                return "tFID[" + this.value() + "],";
            }
            case 308: {
                return "tGVAR[" + this.value() + "],";
            }
            case 309: {
                return "tIVAR[" + this.value() + "],";
            }
            case 310: {
                return "tCONSTANT[" + this.value() + "],";
            }
            case 311: {
                return "tCVAR,";
            }
            case 378: {
                return "tINTEGER,";
            }
            case 379: {
                return "tFLOAT,";
            }
            case 377: {
                return "tSTRING_CONTENT[" + this.value() + "],";
            }
            case 365: {
                return "tSTRING_BEG,";
            }
            case 372: {
                return "tSTRING_END,";
            }
            case 370: {
                return "tSTRING_DBEG,";
            }
            case 371: {
                return "tSTRING_DVAR,";
            }
            case 366: {
                return "tXSTRING_BEG,";
            }
            case 367: {
                return "tREGEXP_BEG,";
            }
            case 380: {
                return "tREGEXP_END,";
            }
            case 368: {
                return "tWORDS_BEG,";
            }
            case 369: {
                return "tQWORDS_BEG,";
            }
            case 376: {
                return "tBACK_REF,";
            }
            case 363: {
                return "tBACK_REF2,";
            }
            case 375: {
                return "tNTH_REF,";
            }
            case 314: {
                return "tUPLUS";
            }
            case 315: {
                return "tUMINUS,";
            }
            case 317: {
                return "tPOW,";
            }
            case 318: {
                return "tCMP,";
            }
            case 319: {
                return "tEQ,";
            }
            case 320: {
                return "tEQQ,";
            }
            case 321: {
                return "tNEQ,";
            }
            case 322: {
                return "tGEQ,";
            }
            case 323: {
                return "tLEQ,";
            }
            case 324: {
                return "tANDOP,";
            }
            case 325: {
                return "tOROP,";
            }
            case 326: {
                return "tMATCH,";
            }
            case 327: {
                return "tNMATCH,";
            }
            case 328: {
                return "tDOT,";
            }
            case 329: {
                return "tDOT2,";
            }
            case 330: {
                return "tDOT3,";
            }
            case 331: {
                return "tAREF,";
            }
            case 332: {
                return "tASET,";
            }
            case 333: {
                return "tLSHFT,";
            }
            case 334: {
                return "tRSHFT,";
            }
            case 335: {
                return "tCOLON2,";
            }
            case 336: {
                return "tCOLON3,";
            }
            case 337: {
                return "tOP_ASGN,";
            }
            case 338: {
                return "tASSOC,";
            }
            case 339: {
                return "tLPAREN,";
            }
            case 340: {
                return "tLPAREN2,";
            }
            case 342: {
                return "tLPAREN_ARG,";
            }
            case 343: {
                return "tLBRACK,";
            }
            case 344: {
                return "tRBRACK,";
            }
            case 345: {
                return "tLBRACE,";
            }
            case 346: {
                return "tLBRACE_ARG,";
            }
            case 347: {
                return "tSTAR,";
            }
            case 348: {
                return "tSTAR2,";
            }
            case 349: {
                return "tAMPER,";
            }
            case 350: {
                return "tAMPER2,";
            }
            case 364: {
                return "tSYMBEG,";
            }
            case 351: {
                return "tTILDE,";
            }
            case 352: {
                return "tPERCENT,";
            }
            case 353: {
                return "tDIVIDE,";
            }
            case 354: {
                return "tPLUS,";
            }
            case 355: {
                return "tMINUS,";
            }
            case 356: {
                return "tLT,";
            }
            case 357: {
                return "tGT,";
            }
            case 360: {
                return "tCARET,";
            }
            case 359: {
                return "tBANG,";
            }
            case 361: {
                return "tTLCURLY,";
            }
            case 362: {
                return "tRCURLY,";
            }
            case 358: {
                return "tTPIPE,";
            }
            case 373: {
                return "tLAMBDA,";
            }
            case 374: {
                return "tLAMBEG,";
            }
            case 341: {
                return "tRPAREN,";
            }
            case 312: {
                return "tLABEL(" + ((Token)this.value()).getValue() + ":),";
            }
            case 10: {
                return "NL";
            }
            case -1: {
                return "EOF";
            }
        }
        return "'" + (char)token + "',";
    }

    private void dispatchScanEvent(int token, Object value2) {
        if (this.ignoreNextScanEvent) {
            this.ignoreNextScanEvent = false;
            return;
        }
        this.yaccValue = this.scanEventValue(token, value2);
        if (token == 10) {
            this.dispatchAllDelayedTokens();
        }
    }

    private Object scanEventValue(int token, Object value2) {
        IRubyObject arg2;
        if (!(value2 instanceof ByteList)) {
            if (value2 instanceof IRubyObject) {
                arg2 = ((IRubyObject)value2).asString();
            } else if (value2 == null) {
                arg2 = this.parser.getRuntime().getNil();
            } else if (value2 instanceof Token) {
                Token tok = (Token)value2;
                arg2 = this.parser.getRuntime().newString("" + tok.getValue());
                this.lastEventLocation = tok.getPosition();
            } else {
                arg2 = this.parser.getRuntime().newString("Error: " + value2.getClass().getName());
            }
        } else {
            arg2 = this.parser.getRuntime().newString((ByteList)value2);
        }
        return this.parser.dispatch(this.tokenToEventId(token), arg2);
    }

    public Position getEventLocation() {
        return this.lastEventLocation != null ? this.lastEventLocation : this.getPosition();
    }

    private String tokenToEventId(int token) {
        switch (token) {
            case 32: {
                return "on_words_sep";
            }
            case 359: {
                return "on_op";
            }
            case 352: {
                return "on_op";
            }
            case 350: {
                return "on_op";
            }
            case 348: {
                return "on_op";
            }
            case 354: {
                return "on_op";
            }
            case 355: {
                return "on_op";
            }
            case 353: {
                return "on_op";
            }
            case 356: {
                return "on_op";
            }
            case 61: {
                return "on_op";
            }
            case 357: {
                return "on_op";
            }
            case 63: {
                return "on_op";
            }
            case 360: {
                return "on_op";
            }
            case 358: {
                return "on_op";
            }
            case 351: {
                return "on_op";
            }
            case 58: {
                return "on_op";
            }
            case 44: {
                return "on_comma";
            }
            case 46: {
                return "on_period";
            }
            case 328: {
                return "on_period";
            }
            case 59: {
                return "on_semicolon";
            }
            case 363: {
                return "on_backtick";
            }
            case 10: {
                return "on_nl";
            }
            case 298: {
                return "on_kw";
            }
            case 290: {
                return "on_kw";
            }
            case 261: {
                return "on_kw";
            }
            case 275: {
                return "on_kw";
            }
            case 270: {
                return "on_kw";
            }
            case 257: {
                return "on_kw";
            }
            case 259: {
                return "on_kw";
            }
            case 299: {
                return "on_kw";
            }
            case 280: {
                return "on_kw";
            }
            case 282: {
                return "on_kw";
            }
            case 281: {
                return "on_kw";
            }
            case 269: {
                return "on_kw";
            }
            case 268: {
                return "on_kw";
            }
            case 264: {
                return "on_kw";
            }
            case 263: {
                return "on_kw";
            }
            case 289: {
                return "on_kw";
            }
            case 274: {
                return "on_kw";
            }
            case 265: {
                return "on_kw";
            }
            case 293: {
                return "on_kw";
            }
            case 279: {
                return "on_kw";
            }
            case 258: {
                return "on_kw";
            }
            case 276: {
                return "on_kw";
            }
            case 287: {
                return "on_kw";
            }
            case 292: {
                return "on_kw";
            }
            case 291: {
                return "on_kw";
            }
            case 277: {
                return "on_kw";
            }
            case 262: {
                return "on_kw";
            }
            case 297: {
                return "on_kw";
            }
            case 278: {
                return "on_kw";
            }
            case 283: {
                return "on_kw";
            }
            case 286: {
                return "on_kw";
            }
            case 285: {
                return "on_kw";
            }
            case 267: {
                return "on_kw";
            }
            case 288: {
                return "on_kw";
            }
            case 260: {
                return "on_kw";
            }
            case 266: {
                return "on_kw";
            }
            case 294: {
                return "on_kw";
            }
            case 273: {
                return "on_kw";
            }
            case 296: {
                return "on_kw";
            }
            case 271: {
                return "on_kw";
            }
            case 272: {
                return "on_kw";
            }
            case 295: {
                return "on_kw";
            }
            case 284: {
                return "on_kw";
            }
            case 303: {
                return "on_kw";
            }
            case 302: {
                return "on_kw";
            }
            case 304: {
                return "on_kw";
            }
            case 300: {
                return "on_kw";
            }
            case 301: {
                return "on_kw";
            }
            case 305: {
                return "on_kw";
            }
            case 349: {
                return "on_op";
            }
            case 324: {
                return "on_op";
            }
            case 331: {
                return "on_op";
            }
            case 332: {
                return "on_op";
            }
            case 338: {
                return "on_op";
            }
            case 376: {
                return "on_backref";
            }
            case 313: {
                return "on_CHAR";
            }
            case 318: {
                return "on_op";
            }
            case 335: {
                return "on_op";
            }
            case 336: {
                return "on_op";
            }
            case 310: {
                return "on_const";
            }
            case 311: {
                return "on_cvar";
            }
            case 329: {
                return "on_op";
            }
            case 330: {
                return "on_op";
            }
            case 319: {
                return "on_op";
            }
            case 320: {
                return "on_op";
            }
            case 307: {
                return "on_ident";
            }
            case 379: {
                return "on_float";
            }
            case 322: {
                return "on_op";
            }
            case 308: {
                return "on_gvar";
            }
            case 306: {
                return "on_ident";
            }
            case 378: {
                return "on_int";
            }
            case 309: {
                return "on_ivar";
            }
            case 345: {
                return "on_lbrace";
            }
            case 346: {
                return "on_lbrace";
            }
            case 361: {
                return "on_lbrace";
            }
            case 362: {
                return "on_rbrace";
            }
            case 343: {
                return "on_lbracket";
            }
            case 91: {
                return "on_lbracket";
            }
            case 344: {
                return "on_rbracket";
            }
            case 323: {
                return "on_op";
            }
            case 339: {
                return "on_lparen";
            }
            case 342: {
                return "on_lparen";
            }
            case 340: {
                return "on_lparen";
            }
            case 41: {
                return "on_rparen";
            }
            case 333: {
                return "on_op";
            }
            case 326: {
                return "on_op";
            }
            case 321: {
                return "on_op";
            }
            case 327: {
                return "on_op";
            }
            case 375: {
                return "on_backref";
            }
            case 337: {
                return "on_op";
            }
            case 325: {
                return "on_op";
            }
            case 317: {
                return "on_op";
            }
            case 369: {
                return "on_qwords_beg";
            }
            case 367: {
                return "on_regexp_beg";
            }
            case 380: {
                return "on_regexp_end";
            }
            case 341: {
                return "on_rparen";
            }
            case 334: {
                return "on_op";
            }
            case 347: {
                return "on_op";
            }
            case 365: {
                return "on_tstring_beg";
            }
            case 377: {
                return "on_tstring_content";
            }
            case 370: {
                return "on_embexpr_beg";
            }
            case 371: {
                return "on_embvar";
            }
            case 372: {
                return "on_tstring_end";
            }
            case 364: {
                return "on_symbeg";
            }
            case 315: {
                return "on_op";
            }
            case 316: {
                return "on_op";
            }
            case 314: {
                return "on_op";
            }
            case 368: {
                return "on_words_beg";
            }
            case 366: {
                return "on_backtick";
            }
            case 312: {
                return "on_label";
            }
            case 373: {
                return "on_tlambda";
            }
            case 374: {
                return "on_tlambeg";
            }
            case 381: {
                return "on_ignored_nl";
            }
            case 382: {
                return "on_comment";
            }
            case 383: {
                return "on_embdoc_beg";
            }
            case 384: {
                return "on_embdoc";
            }
            case 385: {
                return "on_embdoc_end";
            }
            case 386: {
                return "on_sp";
            }
            case 387: {
                return "on_heredoc_beg";
            }
            case 388: {
                return "on_heredoc_end";
            }
            case 390: {
                return "on___end__";
            }
        }
        return "on_CHAR";
    }

    private int yylex2() throws IOException {
        int currentToken = this.yylex2();
        this.printToken(currentToken);
        return currentToken;
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        if (this.token == 0 && this.src.getLine() == 0) {
            this.detectUTF8BOM();
        }
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this, this.src);
            if (tok == 372 || tok == 380) {
                this.lex_strterm = null;
                this.setState(LexState.EXPR_END);
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        block51: while (true) {
            boolean fallthru = false;
            c = this.src.read();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ByteList whitespaceBuf = new ByteList();
                    whitespaceBuf.append(c);
                    boolean looping = true;
                    spaceSeen = true;
                    block52: while (looping && (c = this.src.read()) != -1) {
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                whitespaceBuf.append(c);
                                continue block52;
                            }
                        }
                        looping = false;
                    }
                    this.src.unread(c);
                    this.dispatchScanEvent(386, new Token(whitespaceBuf, this.getPosition()));
                    continue block51;
                }
                case 35: {
                    if (this.readComment() == -1) {
                        return -1;
                    }
                    fallthru = true;
                }
                case 10: {
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: 
                        case EXPR_VALUE: {
                            if (fallthru) continue block51;
                            ByteList buf = new ByteList();
                            buf.append(10);
                            this.dispatchScanEvent(381, buf);
                            continue block51;
                        }
                    }
                    boolean done = false;
                    block53: while (!done) {
                        c = this.src.read();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block53;
                            }
                            case 46: {
                                c = this.src.read();
                                if (c == 46) break;
                                this.src.unread(c);
                                this.src.unread(46);
                                continue block51;
                            }
                        }
                        done = true;
                    }
                    if (c != -1) {
                        this.src.unread(c);
                    }
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: {
                            continue block51;
                        }
                    }
                    this.commandStart = true;
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token("\n", this.getPosition());
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.src.wasBeginOfLine() && this.src.matchMarker(BEGIN_DOC_MARKER, false, false) != 0) {
                        ByteList markerValue = new ByteList();
                        markerValue.append(61).append(BEGIN_DOC_MARKER);
                        c = this.src.read();
                        if (Character.isWhitespace(c)) {
                            this.src.unread(c);
                            markerValue.append(this.src.readLineBytesPlusNewline());
                            this.dispatchScanEvent(383, markerValue);
                            ByteList embValue = new ByteList();
                            while (true) {
                                c = this.src.read();
                                while (c == 10) {
                                    embValue.append(c);
                                    c = this.src.read();
                                }
                                if (c == -1) {
                                    throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), this.getCurrentLine(), "embedded document meets end of file", new Object[0]);
                                }
                                if (c != 61) {
                                    embValue.append(c);
                                    continue;
                                }
                                if (this.src.wasBeginOfLine() && this.src.matchMarker(END_DOC_MARKER, false, false) != 0) break;
                            }
                            this.dispatchScanEvent(384, embValue);
                            markerValue = new ByteList();
                            markerValue.append(61).append(END_DOC_MARKER);
                            markerValue.append(this.src.readLineBytesPlusNewline());
                            this.dispatchScanEvent(385, markerValue);
                            continue block51;
                        }
                        this.src.unread(c);
                    }
                    this.determineExpressionState();
                    c = this.src.read();
                    if (c == 61) {
                        c = this.src.read();
                        if (c == 61) {
                            this.yaccValue = new Token("===", this.getPosition());
                            return 320;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("==", this.getPosition());
                        return 319;
                    }
                    if (c == 126) {
                        this.yaccValue = new Token("=~", this.getPosition());
                        return 326;
                    }
                    if (c == 62) {
                        this.yaccValue = new Token("=>", this.getPosition());
                        return 338;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("=", this.getPosition());
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote();
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote();
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token(";", this.getPosition());
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.src.read();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block51;
                    }
                    this.src.unread(c);
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    int match2;
                    if (this.src.wasBeginOfLine() && (match2 = this.src.matchMarker(END_MARKER, false, true)) != 0) {
                        String endString = match2 == 10 ? "__END__\n" : "__END__";
                        this.dispatchScanEvent(390, new Token(endString, this.getPosition()));
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(LexState last_state, int result2, String value2) {
        if (result2 == 306 && last_state != LexState.EXPR_DOT && this.parser.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(LexState.EXPR_END);
        }
        this.yaccValue = new Token(value2, this.getPosition());
        this.identValue = value2;
        return result2;
    }

    private int getIdentifier(int first2) throws IOException {
        if (this.isMultiByteChar(first2)) {
            first2 = this.src.readCodepoint(first2, this.encoding);
        }
        if (!this.isIdentifierChar(first2)) {
            return first2;
        }
        this.tokenBuffer.append((char)first2);
        int c = this.src.read();
        while (c != -1) {
            if (this.isMultiByteChar(c)) {
                c = this.src.readCodepoint(c, this.encoding);
            }
            if (!this.isIdentifierChar(c)) break;
            this.tokenBuffer.append((char)c);
            c = this.src.read();
        }
        this.src.unread(c);
        return first2;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 38: {
                this.setState(LexState.EXPR_BEG);
                c = this.src.read();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token("&&=", this.getPosition());
                    return 337;
                }
                this.src.unread(c);
                this.yaccValue = new Token("&&", this.getPosition());
                return 324;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                this.yaccValue = new Token("&=", this.getPosition());
                return 337;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token("&", this.getPosition());
        if (this.isSpaceArg(c, spaceSeen)) {
            if (this.isVerbose()) {
                this.warning(Warnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`&' interpreted as argument prefix");
            }
            c = 349;
        } else {
            c = this.isBEG() ? 349 : 350;
        }
        this.determineExpressionState();
        return c;
    }

    private int at() throws IOException {
        int result2;
        int c = this.src.read();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('@');
        if (c == 64) {
            this.tokenBuffer.append('@');
            c = this.src.read();
            result2 = 311;
        } else {
            result2 = 309;
        }
        if (Character.isDigit(c)) {
            if (this.tokenBuffer.length() == 1) {
                throw new SyntaxException(SyntaxException.PID.IVAR_BAD_NAME, this.getPosition(), this.getCurrentLine(), "`@" + c + "' is not allowed as an instance variable name", new Object[0]);
            }
            throw new SyntaxException(SyntaxException.PID.CVAR_BAD_NAME, this.getPosition(), this.getCurrentLine(), "`@@" + c + "' is not allowed as a class variable name", new Object[0]);
        }
        if (!this.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("@", this.getPosition());
            return 64;
        }
        this.getIdentifier(c);
        LexState last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        return this.identifierToken(last_state, result2, this.tokenBuffer.toString().intern());
    }

    private int backtick(boolean commandState) throws IOException {
        this.yaccValue = new Token("`", this.getPosition());
        switch (this.lex_state) {
            case EXPR_FNAME: {
                this.setState(LexState.EXPR_ENDFN);
                return 363;
            }
            case EXPR_DOT: {
                this.setState(commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG);
                return 363;
            }
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 366;
    }

    private int bang() throws IOException {
        int c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                return 359;
            }
        } else {
            this.setState(LexState.EXPR_BEG);
        }
        switch (c) {
            case 61: {
                this.yaccValue = new Token("!=", this.getPosition());
                return 321;
            }
            case 126: {
                this.yaccValue = new Token("!~", this.getPosition());
                return 327;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token("!", this.getPosition());
        return 359;
    }

    private int caret() throws IOException {
        int c = this.src.read();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token("^=", this.getPosition());
            return 337;
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("^", this.getPosition());
        return 360;
    }

    private int colon(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (c == 58) {
            this.yaccValue = new Token("::", this.getPosition());
            if (this.isBEG() || this.lex_state == LexState.EXPR_CLASS || this.isARG() && spaceSeen) {
                this.setState(LexState.EXPR_BEG);
                return 336;
            }
            this.setState(LexState.EXPR_DOT);
            return 335;
        }
        this.yaccValue = new Token(":", this.getPosition());
        if (this.isEND() || Character.isWhitespace(c)) {
            this.src.unread(c);
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token(":", this.getPosition());
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c);
                break;
            }
            default: {
                this.src.unread(c);
            }
        }
        this.setState(LexState.EXPR_FNAME);
        return 364;
    }

    private int comma(int c) throws IOException {
        this.setState(LexState.EXPR_BEG);
        this.yaccValue = new Token(",", this.getPosition());
        return c;
    }

    private int doKeyword(LexState state2) {
        this.commandStart = true;
        this.yaccValue = new Token("do", this.getPosition());
        if (this.leftParenBegin > 0 && this.leftParenBegin == this.parenNest) {
            this.leftParenBegin = 0;
            --this.parenNest;
            return 305;
        }
        if (this.conditionState.isInState()) {
            return 281;
        }
        if (state2 != LexState.EXPR_CMDARG && this.cmdArgumentState.isInState()) {
            return 282;
        }
        if (state2 == LexState.EXPR_ENDARG || state2 == LexState.EXPR_BEG) {
            return 282;
        }
        return 280;
    }

    private int dollar() throws IOException {
        LexState last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        int c = this.src.read();
        switch (c) {
            case 95: {
                c = this.src.read();
                if (this.isIdentifierChar(c)) {
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append("$_");
                    this.getIdentifier(c);
                    last_state = this.lex_state;
                    this.setState(LexState.EXPR_END);
                    return this.identifierToken(last_state, 308, this.tokenBuffer.toString().intern());
                }
                this.src.unread(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = new Token("$" + (char)c, 308, this.getPosition());
                return 308;
            }
            case 45: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                this.tokenBuffer.append((char)c);
                c = this.src.read();
                if (this.isIdentifierChar(c)) {
                    this.tokenBuffer.append((char)c);
                } else {
                    this.src.unread(c);
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), 308, this.getPosition());
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                this.yaccValue = new Token("$" + (char)c, this.getPosition());
                if (last_state == LexState.EXPR_FNAME) {
                    return 308;
                }
                return 376;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                do {
                    this.tokenBuffer.append((char)c);
                } while (Character.isDigit(c = this.src.read()));
                this.src.unread(c);
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token(this.tokenBuffer.toString(), 308, this.getPosition());
                    return 308;
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), this.getPosition());
                return 375;
            }
            case 48: {
                this.setState(LexState.EXPR_END);
                return this.identifierToken(last_state, 308, ("$" + (char)c).intern());
            }
        }
        if (!this.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("$", this.getPosition());
            return 36;
        }
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('$');
        this.getIdentifier(c);
        last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        return this.identifierToken(last_state, 308, this.tokenBuffer.toString().intern());
    }

    private int dot() throws IOException {
        this.setState(LexState.EXPR_BEG);
        int c = this.src.read();
        if (c == 46) {
            c = this.src.read();
            if (c == 46) {
                this.yaccValue = new Token("..", this.getPosition());
                return 330;
            }
            this.src.unread(c);
            this.yaccValue = new Token("..", this.getPosition());
            return 329;
        }
        this.src.unread(c);
        if (Character.isDigit(c)) {
            throw new SyntaxException(SyntaxException.PID.FLOAT_MISSING_ZERO, this.getPosition(), this.getCurrentLine(), "no .<digit> floating literal anymore; put 0 before dot", new Object[0]);
        }
        this.setState(LexState.EXPR_DOT);
        this.yaccValue = new Token(".", this.getPosition());
        return 328;
    }

    private int doubleQuote() throws IOException {
        this.lex_strterm = new StringTerm(2, 0, 34);
        this.yaccValue = new Token("\"", this.getPosition());
        return 365;
    }

    private int greaterThan() throws IOException {
        this.determineExpressionState();
        int c = this.src.read();
        switch (c) {
            case 61: {
                this.yaccValue = new Token(">=", this.getPosition());
                return 322;
            }
            case 62: {
                c = this.src.read();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token(">>=", this.getPosition());
                    return 337;
                }
                this.src.unread(c);
                this.yaccValue = new Token(">>", this.getPosition());
                return 334;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token(">", this.getPosition());
        return 357;
    }

    private int identifier(int c, boolean commandState) throws IOException {
        Keyword keyword;
        if (!this.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            throw new SyntaxException(SyntaxException.PID.CHARACTER_BAD, this.getPosition(), this.getCurrentLine(), "Invalid char `" + badChar + "' ('" + (char)c + "') in expression", badChar);
        }
        this.tokenBuffer.setLength(0);
        int first2 = this.getIdentifier(c);
        c = this.src.read();
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.src.peek(61)) {
                lastBangOrPredicate = true;
                this.tokenBuffer.append((char)c);
            } else {
                this.src.unread(c);
            }
        } else {
            this.src.unread(c);
        }
        int result2 = 0;
        LexState last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result2 = 307;
        } else {
            if (this.lex_state == LexState.EXPR_FNAME) {
                c = this.src.read();
                if (c == 61) {
                    int c2 = this.src.read();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.src.peek(62))) {
                        result2 = 306;
                        this.tokenBuffer.append((char)c);
                        this.src.unread(c2);
                    } else {
                        this.src.unread(c2);
                        this.src.unread(c);
                    }
                } else {
                    this.src.unread(c);
                }
            }
            result2 = result2 == 0 && Character.isUpperCase(first2) ? 310 : 306;
        }
        String tempVal = this.tokenBuffer.toString().intern();
        if (this.lex_state == LexState.EXPR_BEG && !commandState || this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
            int c2 = this.src.read();
            if (c2 == 58 && !this.src.peek(58)) {
                this.src.unread(c2);
                this.setState(LexState.EXPR_BEG);
                this.src.read();
                this.yaccValue = new Token(tempVal, this.getPosition());
                return 312;
            }
            this.src.unread(c2);
        }
        if (this.lex_state != LexState.EXPR_DOT && (keyword = RipperLexer.getKeyword(tempVal)) != null) {
            LexState state2 = this.lex_state;
            if (keyword == Keyword.NOT) {
                this.setState(LexState.EXPR_ARG);
            } else {
                this.setState(keyword.state);
            }
            if (state2 == LexState.EXPR_FNAME) {
                this.yaccValue = new Token(keyword.name, this.getPosition());
            } else {
                this.yaccValue = new Token(tempVal, this.getPosition());
                if (keyword.id0 == 280) {
                    return this.doKeyword(state2);
                }
            }
            if (state2 == LexState.EXPR_BEG || state2 == LexState.EXPR_VALUE) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(LexState.EXPR_BEG);
            }
            return keyword.id1;
        }
        if (this.isBEG() || this.lex_state == LexState.EXPR_DOT || this.isARG()) {
            this.setState(commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG);
        } else if (this.lex_state == LexState.EXPR_ENDFN) {
            this.setState(LexState.EXPR_ENDFN);
        } else {
            this.setState(LexState.EXPR_END);
        }
        return this.identifierToken(last_state, result2, tempVal);
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        ++this.parenNest;
        int c = 91;
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            c = this.src.read();
            if (c == 93) {
                if (this.src.peek(61)) {
                    this.src.read();
                    this.yaccValue = new Token("[]=", this.getPosition());
                    return 332;
                }
                this.yaccValue = new Token("[]", this.getPosition());
                return 331;
            }
            this.src.unread(c);
            return 91;
        }
        if (this.isBEG() || this.isARG() && spaceSeen) {
            c = 343;
        }
        this.setState(LexState.EXPR_BEG);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = new Token("[", this.getPosition());
        return c;
    }

    private int leftCurly() {
        if (this.leftParenBegin > 0 && this.leftParenBegin == this.parenNest) {
            this.setState(LexState.EXPR_BEG);
            this.leftParenBegin = 0;
            --this.parenNest;
            this.conditionState.stop();
            this.cmdArgumentState.stop();
            return 374;
        }
        int c = this.isARG() || this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDFN ? 361 : (this.lex_state == LexState.EXPR_ENDARG ? 346 : 345);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(LexState.EXPR_BEG);
        if (c != 345) {
            this.commandStart = true;
        }
        this.yaccValue = new Token("{", this.getPosition());
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result2 = 340;
        if (this.isBEG()) {
            result2 = 339;
        } else if (spaceSeen) {
            if (this.lex_state == LexState.EXPR_CMDARG) {
                result2 = 342;
            } else if (this.lex_state == LexState.EXPR_ARG) {
                result2 = 342;
            }
        }
        ++this.parenNest;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(LexState.EXPR_BEG);
        this.yaccValue = new Token("(", this.getPosition());
        return result2;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        int c = this.src.read();
        if (!(c != 60 || this.lex_state == LexState.EXPR_DOT || this.lex_state == LexState.EXPR_CLASS || this.isEND() || this.isARG() && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        this.determineExpressionState();
        switch (c) {
            case 61: {
                c = this.src.read();
                if (c == 62) {
                    this.yaccValue = new Token("<=>", this.getPosition());
                    return 318;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<=", this.getPosition());
                return 323;
            }
            case 60: {
                c = this.src.read();
                if (c == 61) {
                    this.yaccValue = new Token("<<=", this.getPosition());
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<<", this.getPosition());
                return 333;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token("<", this.getPosition());
        return 356;
    }

    private int minus(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                this.yaccValue = new Token("-", this.getPosition());
                return 315;
            }
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            return 355;
        }
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token("-=", this.getPosition());
            return 337;
        }
        if (c == 62) {
            this.setState(LexState.EXPR_ARG);
            this.yaccValue = new Token("->", this.getPosition());
            return 373;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen)) {
            if (this.isARG()) {
                this.arg_ambiguous();
            }
            this.setState(LexState.EXPR_BEG);
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            if (Character.isDigit(c)) {
                return 316;
            }
            return 315;
        }
        this.setState(LexState.EXPR_BEG);
        this.src.unread(c);
        this.yaccValue = new Token("-", this.getPosition());
        return 355;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            return this.parseQuote(this.src.read());
        }
        int c = this.src.read();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token("%=", this.getPosition());
            return 337;
        }
        if (this.isSpaceArg(c, spaceSeen)) {
            return this.parseQuote(c);
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("%", this.getPosition());
        return 352;
    }

    private int pipe() throws IOException {
        int c = this.src.read();
        switch (c) {
            case 124: {
                this.setState(LexState.EXPR_BEG);
                c = this.src.read();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token("||=", this.getPosition());
                    return 337;
                }
                this.src.unread(c);
                this.yaccValue = new Token("||", this.getPosition());
                return 325;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                this.yaccValue = new Token("|=", this.getPosition());
                return 337;
            }
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("|", this.getPosition());
        return 358;
    }

    private int plus(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                return 314;
            }
            this.src.unread(c);
            this.yaccValue = new Token("+", this.getPosition());
            return 354;
        }
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token("+=", this.getPosition());
            return 337;
        }
        this.yaccValue = new Token("+", this.getPosition());
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen)) {
            if (this.isARG()) {
                this.arg_ambiguous();
            }
            this.setState(LexState.EXPR_BEG);
            this.src.unread(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            return 314;
        }
        this.setState(LexState.EXPR_BEG);
        this.src.unread(c);
        return 354;
    }

    private int questionMark() throws IOException {
        if (this.isEND()) {
            this.setState(LexState.EXPR_VALUE);
            return 63;
        }
        int c = this.src.read();
        if (c == -1) {
            throw new SyntaxException(SyntaxException.PID.INCOMPLETE_CHAR_SYNTAX, this.getPosition(), this.getCurrentLine(), "incomplete character syntax", new Object[0]);
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warn(Warnings.ID.INVALID_CHAR_SEQUENCE, this.getPosition(), "invalid character syntax; use ?\\" + c2);
                }
            }
            this.src.unread(c);
            this.setState(LexState.EXPR_VALUE);
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (this.isIdentifierChar(c) && !this.src.peek(10) && this.isNext_identchar()) {
            this.src.unread(c);
            this.setState(LexState.EXPR_VALUE);
            return 63;
        }
        if (c == 92) {
            if (this.src.peek(117)) {
                this.src.read();
                ByteList oneCharBL = new ByteList(2);
                c = this.readUTFEscape(oneCharBL, false, false);
                if (c >= 128) {
                    this.tokenAddMBC(c, oneCharBL);
                } else {
                    oneCharBL.append(c);
                }
                this.setState(LexState.EXPR_END);
                this.yaccValue = new Token(oneCharBL, this.getPosition());
                return 378;
            }
            c = this.readEscape();
        }
        this.setState(LexState.EXPR_END);
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.append(c);
        this.yaccValue = new Token(oneCharBL, this.getPosition());
        return 313;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDARG);
        this.yaccValue = new Token("]", this.getPosition());
        return 344;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDARG);
        this.yaccValue = new Token("}", this.getPosition());
        return 362;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDFN);
        this.yaccValue = new Token(")", this.getPosition());
        return 341;
    }

    private int singleQuote() throws IOException {
        this.lex_strterm = new StringTerm(0, 0, 39);
        return 365;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/", this.getPosition());
            return 367;
        }
        int c = this.src.read();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            this.yaccValue = new Token("/=", this.getPosition());
            return 337;
        }
        this.src.unread(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/ ", this.getPosition());
            return 367;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("/", this.getPosition());
        return 353;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 42: {
                c = this.src.read();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    this.yaccValue = new Token("**=", this.getPosition());
                    return 337;
                }
                this.src.unread(c);
                this.yaccValue = new Token("**", this.getPosition());
                c = 317;
                break;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                this.yaccValue = new Token("*=", this.getPosition());
                return 337;
            }
            default: {
                this.src.unread(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose()) {
                        this.warning(Warnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`*' interpreted as argument prefix");
                    }
                    c = 347;
                } else {
                    c = this.isBEG() ? 347 : 348;
                }
                this.yaccValue = new Token("*", this.getPosition());
            }
        }
        this.determineExpressionState();
        return c;
    }

    private int tilde() throws IOException {
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            int c = this.src.read();
            if (c != 64) {
                this.src.unread(c);
            }
            this.setState(LexState.EXPR_ARG);
        } else {
            this.setState(LexState.EXPR_BEG);
        }
        this.yaccValue = new Token("~", this.getPosition());
        return 351;
    }

    private int parseNumber(int c) throws IOException {
        this.setState(LexState.EXPR_END);
        this.tokenBuffer.setLength(0);
        if (c == 45) {
            this.tokenBuffer.append((char)c);
            c = this.src.read();
        } else if (c == 43) {
            c = this.src.read();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.tokenBuffer.length();
            c = this.src.read();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.src.read();
                    if (RipperLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RipperLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.getPosition(), this.getCurrentLine(), "Hexadecimal number without hex-digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 378;
                }
                case 66: 
                case 98: {
                    c = this.src.read();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), this.getCurrentLine(), "Binary number without digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 378;
                }
                case 68: 
                case 100: {
                    c = this.src.read();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), this.getCurrentLine(), "Binary number without digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                    return 378;
                }
                case 79: 
                case 111: {
                    c = this.src.read();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.tokenBuffer.append((char)c);
                        }
                        c = this.src.read();
                    }
                    if (this.tokenBuffer.length() > startLen) {
                        this.src.unread(c);
                        if (nondigit != 0) {
                            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 378;
                    }
                }
                case 56: 
                case 57: {
                    throw new SyntaxException(SyntaxException.PID.BAD_OCTAL_DIGIT, this.getPosition(), this.getCurrentLine(), "Illegal octal digit.", new Object[0]);
                }
                case 46: 
                case 69: 
                case 101: {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.src.unread(c);
                    this.yaccValue = this.parser.getRuntime().newFixnum(0);
                    return 378;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.tokenBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.src.unread(c);
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (seen_point || seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    int c2 = this.src.read();
                    if (!Character.isDigit(c2)) {
                        this.src.unread(c2);
                        this.src.unread(46);
                        if (c == 95) break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 378;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    this.tokenBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.src.read();
                    if (c == 45 || c == 43) {
                        this.tokenBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.src.unread(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.src.unread(c);
                    return this.getNumberToken(this.tokenBuffer.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.src.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, int nondigit) {
        if (nondigit != 0) {
            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), this.getCurrentLine(), "Trailing '_' in number.", new Object[0]);
        }
        if (isFloat) {
            return this.getFloatToken(number);
        }
        this.yaccValue = this.getInteger(number, 10);
        return 378;
    }

    public void readUTFEscapeRegexpLiteral(ByteList buffer) throws IOException {
        buffer.append(92);
        buffer.append(117);
        if (this.src.peek(123)) {
            do {
                buffer.append(this.src.read());
                if (this.scanHexLiteral(buffer, 6, false, "invalid Unicode escape") <= '\u10ffff') continue;
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "invalid Unicode codepoint (too large)", new Object[0]);
            } while (this.src.peek(32) || this.src.peek(9));
            int c = this.src.read();
            if (c != 125) {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "unterminated Unicode escape", new Object[0]);
            }
            buffer.append((char)c);
        } else {
            this.scanHexLiteral(buffer, 4, true, "Invalid Unicode escape");
        }
    }

    public int tokenAddMBC(int codepoint, ByteList buffer) {
        int length2 = buffer.getEncoding().codeToMbc(codepoint, this.mbcBuf, 0);
        if (length2 <= 0) {
            return -1;
        }
        buffer.append(this.mbcBuf, 0, length2);
        return length2;
    }

    public void tokenAddMBCFromSrc(int c, ByteList buffer) throws IOException {
        int length2 = buffer.getEncoding().length((byte)c);
        buffer.append((byte)c);
        for (int off = 0; off < length2 - 1; ++off) {
            buffer.append((byte)this.src.read());
        }
    }

    public int readUTFEscape(ByteList buffer, boolean stringLiteral, boolean symbolLiteral) throws IOException {
        int codepoint;
        if (this.src.peek(123)) {
            do {
                this.src.read();
                codepoint = this.scanHex(6, false, "invalid Unicode escape");
                if (codepoint > 0x10FFFF) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "invalid Unicode codepoint (too large)", new Object[0]);
                }
                if (buffer == null) continue;
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            } while (this.src.peek(32) || this.src.peek(9));
            int c = this.src.read();
            if (c != 125) {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "unterminated Unicode escape", new Object[0]);
            }
        } else {
            codepoint = this.scanHex(4, true, "Invalid Unicode escape");
            if (buffer != null) {
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            }
        }
        return codepoint;
    }

    private void readUTF8EscapeIntoBuffer(int codepoint, ByteList buffer, boolean stringLiteral) {
        if (codepoint >= 128) {
            buffer.setEncoding(UTF8_ENCODING);
            if (stringLiteral) {
                this.tokenAddMBC(codepoint, buffer);
            }
        } else if (stringLiteral) {
            buffer.append((char)codepoint);
        }
    }

    public int readEscape() throws IOException {
        int c = this.src.read();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.src.unread(c);
                return this.scanOct(3);
            }
            case 120: {
                return this.scanHex(2, false, "Invalid escape character syntax");
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
                c = this.src.read();
                if (c == 92) {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == -1) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                c = this.src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
            }
            case 99: {
                c = this.src.read();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
            }
        }
        return c;
    }

    private char scanHexLiteral(ByteList buffer, int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        char hexValue = '\u0000';
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.src.read();
            if (!RipperLexer.isHexChar(h1)) {
                this.src.unread(h1);
                break;
            }
            buffer.append(h1);
            hexValue = (char)(hexValue << 4);
            hexValue = (char)(hexValue | Integer.parseInt("" + (char)h1, 16) & 0xF);
        }
        if (i2 == 0 || strict && count2 != i2) {
            throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), errorMessage, new Object[0]);
        }
        return hexValue;
    }

    private int scanHex(int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        int hexValue = 0;
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.src.read();
            if (!RipperLexer.isHexChar(h1)) {
                this.src.unread(h1);
                break;
            }
            hexValue <<= 4;
            hexValue |= Integer.parseInt("" + (char)h1, 16) & 0xF;
        }
        if (i2 == 0 || strict && count2 != i2) {
            throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), this.getCurrentLine(), errorMessage, new Object[0]);
        }
        return hexValue;
    }

    private char scanOct(int count2) throws IOException {
        char value2 = '\u0000';
        for (int i2 = 0; i2 < count2; ++i2) {
            int c = this.src.read();
            if (!RipperLexer.isOctChar(c)) {
                this.src.unread(c);
                break;
            }
            value2 = (char)(value2 << 3);
            value2 = (char)(value2 | Integer.parseInt("" + (char)c, 8));
        }
        return value2;
    }

    private void detectUTF8BOM() throws IOException {
        int b1 = this.src.read();
        if (b1 == 239) {
            int b2 = this.src.read();
            if (b2 == 187) {
                int b3 = this.src.read();
                if (b3 == 191) {
                    this.setEncoding(UTF8_ENCODING);
                } else {
                    this.src.unread(b3);
                    this.src.unread(b2);
                    this.src.unread(b1);
                }
            } else {
                this.src.unread(b2);
                this.src.unread(b1);
            }
        } else {
            this.src.unread(b1);
        }
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
        magicRegexp = new Regex(magicString.getBytes(), 0, magicString.length(), 0, Encoding.load("ASCII"));
        encodingRegexp = new Regex(encodingString.getBytes(), 0, encodingString.length(), 0, Encoding.load("ASCII"));
    }

    public static enum LexState {
        EXPR_BEG,
        EXPR_END,
        EXPR_ARG,
        EXPR_CMDARG,
        EXPR_ENDARG,
        EXPR_MID,
        EXPR_FNAME,
        EXPR_DOT,
        EXPR_CLASS,
        EXPR_VALUE,
        EXPR_ENDFN;

    }

    public static enum Keyword {
        END("end", 264, 264, LexState.EXPR_END),
        ELSE("else", 269, 269, LexState.EXPR_BEG),
        CASE("case", 270, 270, LexState.EXPR_BEG),
        ENSURE("ensure", 263, 263, LexState.EXPR_BEG),
        MODULE("module", 258, 258, LexState.EXPR_BEG),
        ELSIF("elsif", 268, 268, LexState.EXPR_BEG),
        DEF("def", 259, 259, LexState.EXPR_FNAME),
        RESCUE("rescue", 262, 297, LexState.EXPR_MID),
        NOT("not", 292, 292, LexState.EXPR_BEG),
        THEN("then", 267, 267, LexState.EXPR_BEG),
        YIELD("yield", 284, 284, LexState.EXPR_ARG),
        FOR("for", 274, 274, LexState.EXPR_BEG),
        SELF("self", 286, 286, LexState.EXPR_END),
        FALSE("false", 289, 289, LexState.EXPR_END),
        RETRY("retry", 278, 278, LexState.EXPR_END),
        RETURN("return", 283, 283, LexState.EXPR_MID),
        TRUE("true", 288, 288, LexState.EXPR_END),
        IF("if", 265, 293, LexState.EXPR_BEG),
        DEFINED_P("defined?", 299, 299, LexState.EXPR_ARG),
        SUPER("super", 285, 285, LexState.EXPR_ARG),
        UNDEF("undef", 260, 260, LexState.EXPR_FNAME),
        BREAK("break", 275, 275, LexState.EXPR_MID),
        IN("in", 279, 279, LexState.EXPR_BEG),
        DO("do", 280, 280, LexState.EXPR_BEG),
        NIL("nil", 287, 287, LexState.EXPR_END),
        UNTIL("until", 273, 296, LexState.EXPR_BEG),
        UNLESS("unless", 266, 294, LexState.EXPR_BEG),
        OR("or", 291, 291, LexState.EXPR_BEG),
        NEXT("next", 276, 276, LexState.EXPR_MID),
        WHEN("when", 271, 271, LexState.EXPR_BEG),
        REDO("redo", 277, 277, LexState.EXPR_END),
        AND("and", 290, 290, LexState.EXPR_BEG),
        BEGIN("begin", 261, 261, LexState.EXPR_BEG),
        __LINE__("__LINE__", 302, 302, LexState.EXPR_END),
        CLASS("class", 257, 257, LexState.EXPR_CLASS),
        __FILE__("__FILE__", 303, 303, LexState.EXPR_END),
        LEND("END", 301, 301, LexState.EXPR_END),
        LBEGIN("BEGIN", 300, 300, LexState.EXPR_END),
        WHILE("while", 272, 295, LexState.EXPR_BEG),
        ALIAS("alias", 298, 298, LexState.EXPR_FNAME),
        __ENCODING__("__ENCODING__", 304, 304, LexState.EXPR_END);

        public final String name;
        public final int id0;
        public final int id1;
        public final LexState state;

        private Keyword(String name2, int id0, int id1, LexState state2) {
            this.name = name2;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state2;
        }
    }

    class TokenPair {
        public final int token;
        public final Object value;

        public TokenPair(int token, Object value2) {
            this.token = token;
            this.value = value2;
        }
    }
}

