/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.MessageDigest;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;

public class Name {
    public X500Name name;

    public Name(X500Principal nm) {
        try {
            this.name = X500Name.getInstance((Object)nm.getEncoded());
        }
        catch (Exception e) {
            this.name = null;
        }
    }

    public Name(X500Name nm) {
        this.name = nm;
    }

    public long hash() {
        try {
            byte[] bytes = this.name.getEncoded();
            byte[] md = null;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md = md5.digest(bytes);
            long result = 0L;
            result |= (long)(md[3] & 0xFF);
            result <<= 8;
            result |= (long)(md[2] & 0xFF);
            result <<= 8;
            result |= (long)(md[1] & 0xFF);
            result <<= 8;
            return (result |= (long)(md[0] & 0xFF)) & 0xFFFFFFFFFFFFFFFFL;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean isEqual(X500Principal oname) {
        try {
            return new X500Principal(this.name.getEncoded("DER")).equals(oname);
        }
        catch (Exception e) {
            return false;
        }
    }
}

