/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ext.openssl.x509store.CertificateFile;
import org.jruby.ext.openssl.x509store.CertificateHashDir;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function4;
import org.jruby.ext.openssl.x509store.Function5;
import org.jruby.ext.openssl.x509store.LookupMethod;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class Lookup {
    public boolean init = false;
    public boolean skip = false;
    public LookupMethod method;
    public Object methodData;
    public Store store;
    private static final LookupMethod x509FileLookup = new LookupMethod();
    private static final LookupMethod x509DirectoryLookup = new LookupMethod();

    public Lookup(LookupMethod method) throws Exception {
        this.method = method;
        this.methodData = null;
        this.store = null;
        if (method.newItem != null && method.newItem != Function1.EMPTY && method.newItem.call(this) == 0) {
            throw new Exception();
        }
    }

    public int loadFile(CertificateFile.Path file) throws Exception {
        return this.control(1, file.name, file.type, null);
    }

    public int addDir(CertificateHashDir.Dir dir) throws Exception {
        return this.control(2, dir.name, dir.type, null);
    }

    public static LookupMethod hashDirLookup() {
        return x509DirectoryLookup;
    }

    public static LookupMethod fileLookup() {
        return x509FileLookup;
    }

    public int control(int cmd, String argc, long argl, String[] ret) throws Exception {
        if (this.method == null) {
            return -1;
        }
        if (this.method.control != null && this.method.control != Function5.EMPTY) {
            return this.method.control.call(this, new Integer(cmd), argc, new Long(argl), ret);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCertificateFile(String file, int type) throws Exception {
        X509AuxCertificate x;
        InputStream in;
        Reader reader;
        int ret;
        int count;
        block25: {
            if (file == null) {
                return 1;
            }
            count = 0;
            ret = 0;
            reader = null;
            in = this.wrapJRubyNormalizedInputStream(file);
            x = null;
            if (type != 1) {
                if (type == 2) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x = StoreContext.ensureAux((X509Certificate)cf.generateCertificate(in));
                    if (x == null) {
                        X509Error.addError(13);
                        int n = ret;
                        return n;
                    }
                    int i2 = this.store.addCertificate(x);
                    if (i2 == 0) {
                        int n = ret;
                        return n;
                    }
                    ret = i2;
                    return ret;
                }
                X509Error.addError(100);
                return ret;
            }
            break block25;
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
        reader = new BufferedReader(new InputStreamReader(in));
        while (true) {
            if (null == (x = PEMInputOutput.readX509Aux(reader, null))) {
                ret = count;
                return ret;
            }
            int i3 = this.store.addCertificate(x);
            if (i3 == 0) {
                int n = ret;
                return n;
            }
            ++count;
            x = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCRLFile(String file, int type) throws Exception {
        CRL x;
        InputStream in;
        Reader reader;
        int ret;
        int count;
        block25: {
            if (file == null) {
                return 1;
            }
            count = 0;
            ret = 0;
            reader = null;
            in = this.wrapJRubyNormalizedInputStream(file);
            x = null;
            if (type != 1) {
                if (type == 2) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x = cf.generateCRL(in);
                    if (x == null) {
                        X509Error.addError(13);
                        int n = ret;
                        return n;
                    }
                    int i2 = this.store.addCRL(x);
                    if (i2 == 0) {
                        int n = ret;
                        return n;
                    }
                    ret = i2;
                    return ret;
                }
                X509Error.addError(100);
                return ret;
            }
            break block25;
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
        reader = new BufferedReader(new InputStreamReader(in));
        while (true) {
            if (null == (x = PEMInputOutput.readX509CRL(reader, null))) {
                ret = count;
                return ret;
            }
            int i3 = this.store.addCRL(x);
            if (i3 == 0) {
                int n = ret;
                return n;
            }
            ++count;
            x = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCertificateOrCRLFile(String file, int type) throws Exception {
        if (type != 1) {
            return this.loadCertificateFile(file, type);
        }
        int count = 0;
        Reader reader = null;
        try {
            Object v;
            InputStream in = this.wrapJRubyNormalizedInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in));
            while (null != (v = PEMInputOutput.readPEM(reader, null))) {
                if (v instanceof X509Certificate) {
                    this.store.addCertificate(StoreContext.ensureAux((X509Certificate)v));
                    ++count;
                    continue;
                }
                if (!(v instanceof CRL)) continue;
                this.store.addCRL((CRL)v);
                ++count;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ignored) {}
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadDefaultJavaCACertsFile() throws Exception {
        int count = 0;
        String certsFile = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        FileInputStream fin = new FileInputStream(certsFile);
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(fin, null);
            PKIXParameters params2 = new PKIXParameters(keystore);
            for (TrustAnchor trustAnchor : params2.getTrustAnchors()) {
                X509Certificate certificate = trustAnchor.getTrustedCert();
                this.store.addCertificate(certificate);
                ++count;
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception ignored) {}
            }
        }
        return count;
    }

    private InputStream wrapJRubyNormalizedInputStream(String file) throws IOException {
        Ruby runtime = Ruby.getGlobalRuntime();
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open((String)runtime.getCurrentDirectory(), (String)file, (ModeFlags)new ModeFlags((long)ModeFlags.RDONLY));
            return ChannelStream.open((Ruby)runtime, (ChannelDescriptor)descriptor).newInputStream();
        }
        catch (NoSuchMethodError nsme) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileExistsException fee) {
            fee.printStackTrace(System.err);
            throw new IllegalStateException(fee.getMessage(), fee);
        }
        catch (InvalidValueException ive) {
            ive.printStackTrace(System.err);
            throw new IllegalStateException(ive.getMessage(), ive);
        }
    }

    public void free() throws Exception {
        if (this.method != null && this.method.free != null && this.method.free != Function1.EMPTY) {
            this.method.free.call(this);
        }
    }

    public int init() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.init != null && this.method.init != Function1.EMPTY) {
            return this.method.init.call(this);
        }
        return 1;
    }

    public int bySubject(int type, Name name2, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getBySubject == null || this.method.getBySubject == Function4.EMPTY) {
            return 0;
        }
        if (this.skip) {
            return 0;
        }
        return this.method.getBySubject.call(this, new Integer(type), name2, ret);
    }

    public int byIssuerSerialNumber(int type, Name name2, BigInteger serial2, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByIssuerSerialNumber == null || this.method.getByIssuerSerialNumber == Function5.EMPTY) {
            return 0;
        }
        return this.method.getByIssuerSerialNumber.call(this, new Integer(type), name2, serial2, ret);
    }

    public int byFingerprint(int type, String bytes, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByFingerprint == null || this.method.getByFingerprint == Function4.EMPTY) {
            return 0;
        }
        return this.method.getByFingerprint.call(this, new Integer(type), bytes, ret);
    }

    public int byAlias(int type, String str, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByAlias == null || this.method.getByAlias == Function4.EMPTY) {
            return 0;
        }
        return this.method.getByAlias.call(this, new Integer(type), str, ret);
    }

    public int shutdown() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.shutdown != null && this.method.shutdown != Function1.EMPTY) {
            return this.method.shutdown.call(this);
        }
        return 1;
    }

    static {
        Lookup.x509FileLookup.name = "Load file into cache";
        Lookup.x509FileLookup.control = new ByFile();
        Lookup.x509DirectoryLookup.name = "Load certs from files in a directory";
        Lookup.x509DirectoryLookup.newItem = new NewLookupDir();
        Lookup.x509DirectoryLookup.free = new FreeLookupDir();
        Lookup.x509DirectoryLookup.control = new LookupDirControl();
        Lookup.x509DirectoryLookup.getBySubject = new GetCertificateBySubject();
    }

    private static class GetCertificateBySubject
    implements LookupMethod.BySubjectFunction {
        private GetCertificateBySubject() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int call(Object _xl, Object _type, Object _name, Object _ret) throws Exception {
            Lookup x1 = (Lookup)_xl;
            int type = (Integer)_type;
            Name name2 = (Name)_name;
            X509Object[] ret = (X509Object[])_ret;
            int ok = 0;
            StringBuffer b = new StringBuffer();
            if (null == name2) {
                return 0;
            }
            String postfix = "";
            if (type != 1) {
                if (type == 2) {
                    postfix = "r";
                } else {
                    X509Error.addError(112);
                    return ok;
                }
            }
            LookupDir ctx = (LookupDir)x1.methodData;
            long h = name2.hash();
            Iterator<Integer> iter = ctx.dirsType.iterator();
            for (String cdir : ctx.dirs) {
                int tp = iter.next();
                int k = 0;
                do {
                    b.append(String.format("%s%s%08x.%s%d", cdir, File.separator, h, postfix, k));
                    ++k;
                } while (new File(b.toString()).exists() && !(type == 1 ? x1.loadCertificateFile(b.toString(), tp) == 0 : type == 2 && x1.loadCRLFile(b.toString(), tp) == 0));
                X509Object tmp = null;
                Object object = X509Utils.CRYPTO_LOCK_X509_STORE;
                synchronized (object) {
                    for (X509Object o : x1.store.objs) {
                        if (o.type() != type || !o.isName(name2)) continue;
                        tmp = o;
                        break;
                    }
                }
                if (tmp == null) continue;
                ok = 1;
                ret[0] = tmp;
                break;
            }
            return ok;
        }
    }

    private static class LookupDirControl
    implements LookupMethod.ControlFunction {
        private LookupDirControl() {
        }

        @Override
        public int call(Object _ctx, Object _cmd, Object _argp, Object _argl, Object _retp) {
            Lookup ctx = (Lookup)_ctx;
            int cmd = (Integer)_cmd;
            String argp = (String)_argp;
            long argl = (Long)_argl;
            int ret = 0;
            LookupDir ld = (LookupDir)ctx.methodData;
            String dir = null;
            switch (cmd) {
                case 2: {
                    if (argl == 3L) {
                        try {
                            RubyHash env = (RubyHash)Ruby.getGlobalRuntime().getObject().getConstant("ENV");
                            dir = (String)env.get((Object)Ruby.getGlobalRuntime().newString(X509Utils.getDefaultCertificateDirectoryEnvironment()));
                        }
                        catch (Error error2) {
                            // empty catch block
                        }
                        ret = null != dir ? this.addCertificateDirectory(ld, dir, 1) : this.addCertificateDirectory(ld, X509Utils.getDefaultCertificateDirectory(), 1);
                        if (ret != 0) break;
                        X509Error.addError(103);
                        break;
                    }
                    ret = this.addCertificateDirectory(ld, argp, (int)argl);
                }
            }
            return ret;
        }

        private int addCertificateDirectory(LookupDir ctx, String dir, int type) {
            if (dir == null || "".equals(dir)) {
                X509Error.addError(113);
                return 0;
            }
            String[] dirs = dir.split(System.getProperty("path.separator"));
            for (int i2 = 0; i2 < dirs.length; ++i2) {
                if (dirs[i2].length() == 0 || ctx.dirs.contains(dirs[i2])) continue;
                ctx.dirsType.add(type);
                ctx.dirs.add(dirs[i2]);
            }
            return 1;
        }
    }

    private static class FreeLookupDir
    implements LookupMethod.FreeFunction {
        private FreeLookupDir() {
        }

        @Override
        public int call(Object _lu) {
            Lookup lu = (Lookup)_lu;
            LookupDir a = (LookupDir)lu.methodData;
            a.dirs = null;
            a.dirsType = null;
            lu.methodData = null;
            return -1;
        }
    }

    private static class NewLookupDir
    implements LookupMethod.NewItemFunction {
        private NewLookupDir() {
        }

        @Override
        public int call(Object _lu) {
            Lookup lu = (Lookup)_lu;
            LookupDir a = new LookupDir();
            a.dirs = new ArrayList<String>();
            a.dirsType = new ArrayList<Integer>();
            lu.methodData = a;
            return 1;
        }
    }

    private static class LookupDir {
        List<String> dirs;
        List<Integer> dirsType;

        private LookupDir() {
        }
    }

    private static class ByFile
    implements LookupMethod.ControlFunction {
        private ByFile() {
        }

        @Override
        public int call(Object _ctx, Object _cmd, Object _argp, Object _argl, Object _ret) throws Exception {
            Lookup ctx = (Lookup)_ctx;
            int cmd = (Integer)_cmd;
            String argp = (String)_argp;
            long argl = (Long)_argl;
            int ok = 0;
            String file = null;
            switch (cmd) {
                case 1: {
                    if (argl == 3L) {
                        try {
                            RubyHash env = (RubyHash)Ruby.getGlobalRuntime().getObject().getConstant("ENV");
                            file = (String)env.get((Object)Ruby.getGlobalRuntime().newString(X509Utils.getDefaultCertificateFileEnvironment()));
                        }
                        catch (Error error2) {
                            // empty catch block
                        }
                        if (file != null) {
                            ok = ctx.loadCertificateOrCRLFile(file, 1) != 0 ? 1 : 0;
                        } else {
                            int n = ok = ctx.loadDefaultJavaCACertsFile() != 0 ? 1 : 0;
                        }
                        if (ok != 0) break;
                        X509Error.addError(104);
                        break;
                    }
                    ok = argl == 1L ? (ctx.loadCertificateOrCRLFile(argp, 1) != 0 ? 1 : 0) : (ctx.loadCertificateFile(argp, (int)argl) != 0 ? 1 : 0);
                }
            }
            return ok;
        }
    }
}

