/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.JobAttributes;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.lwawt.LWButtonPeer;
import sun.lwawt.LWCanvasPeer;
import sun.lwawt.LWCheckboxPeer;
import sun.lwawt.LWChoicePeer;
import sun.lwawt.LWCursorManager;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWLabelPeer;
import sun.lwawt.LWListPeer;
import sun.lwawt.LWMouseInfoPeer;
import sun.lwawt.LWPanelPeer;
import sun.lwawt.LWScrollBarPeer;
import sun.lwawt.LWScrollPanePeer;
import sun.lwawt.LWTextAreaPeer;
import sun.lwawt.LWTextFieldPeer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CDesktopPeer;
import sun.lwawt.macosx.CDragSourceContextPeer;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.lwawt.macosx.CPrinterDialog;
import sun.lwawt.macosx.CPrinterDialogPeer;
import sun.print.PrintJob2D;

public abstract class LWToolkit
extends SunToolkit
implements Runnable {
    private static final int STATE_NONE = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_MESSAGELOOP = 2;
    private static final int STATE_SHUTDOWN = 3;
    private static final int STATE_CLEANUP = 4;
    private static final int STATE_DONE = 5;
    private int runState = 0;
    private Clipboard clipboard;
    private MouseInfoPeer mouseInfoPeer;

    protected final void init() {
        AWTAutoShutdown.notifyToolkitThreadBusy();
        ThreadGroup threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                return threadGroup;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                LWToolkit.this.shutdown();
                LWToolkit.this.waitForRunState(4);
            }
        }));
        Thread thread = new Thread(threadGroup, this, "AWT-LW");
        thread.setDaemon(true);
        thread.setPriority(6);
        thread.start();
        this.waitForRunState(2);
    }

    protected abstract void platformInit();

    public void shutdown() {
        this.setRunState(3);
        this.platformShutdown();
    }

    protected abstract void platformShutdown();

    protected abstract void platformCleanup();

    private synchronized int getRunState() {
        return this.runState;
    }

    private synchronized void setRunState(int n) {
        this.runState = n;
        this.notifyAll();
    }

    public boolean isTerminating() {
        return this.getRunState() >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunState(int n) {
        while (this.getRunState() < n) {
            try {
                LWToolkit lWToolkit = this;
                synchronized (lWToolkit) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    @Override
    public void run() {
        this.setRunState(1);
        this.platformInit();
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.setRunState(2);
        while (this.getRunState() < 3) {
            try {
                this.platformRunMessage();
                if (!Thread.currentThread().isInterrupted() || !AppContext.getAppContext().isDisposed()) continue;
                break;
            }
            catch (ThreadDeath threadDeath) {
                break;
            }
            catch (Throwable throwable) {
                System.err.println("Exception on the toolkit thread");
                throwable.printStackTrace(System.err);
            }
        }
        this.setRunState(4);
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.platformCleanup();
        this.setRunState(5);
    }

    protected abstract void platformRunMessage();

    public static LWToolkit getLWToolkit() {
        return (LWToolkit)Toolkit.getDefaultToolkit();
    }

    private LWWindowPeer createDelegatedPeer(Window window, PlatformComponent platformComponent, PlatformWindow platformWindow) {
        LWWindowPeer lWWindowPeer = new LWWindowPeer(window, platformComponent, platformWindow);
        LWToolkit.targetCreatedPeer(window, lWWindowPeer);
        lWWindowPeer.initialize();
        return lWWindowPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.SIMPLEWINDOW);
        return this.createDelegatedPeer(window, platformComponent, platformWindow);
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.FRAME);
        return this.createDelegatedPeer(frame, platformComponent, platformWindow);
    }

    public LWWindowPeer createEmbeddedFrame(CEmbeddedFrame cEmbeddedFrame) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.EMBEDDEDFRAME);
        return this.createDelegatedPeer(cEmbeddedFrame, platformComponent, platformWindow);
    }

    CPrinterDialogPeer createCPrinterDialog(CPrinterDialog cPrinterDialog) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.DIALOG);
        CPrinterDialogPeer cPrinterDialogPeer = new CPrinterDialogPeer(cPrinterDialog, platformComponent, platformWindow);
        LWToolkit.targetCreatedPeer(cPrinterDialog, cPrinterDialogPeer);
        return cPrinterDialogPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        if (dialog instanceof CPrinterDialog) {
            return this.createCPrinterDialog((CPrinterDialog)dialog);
        }
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.DIALOG);
        return this.createDelegatedPeer(dialog, platformComponent, platformWindow);
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        FileDialogPeer fileDialogPeer = this.createFileDialogPeer(fileDialog);
        LWToolkit.targetCreatedPeer(fileDialog, fileDialogPeer);
        return fileDialogPeer;
    }

    @Override
    public ButtonPeer createButton(Button button) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWButtonPeer lWButtonPeer = new LWButtonPeer(button, platformComponent);
        LWToolkit.targetCreatedPeer(button, lWButtonPeer);
        lWButtonPeer.initialize();
        return lWButtonPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCheckboxPeer lWCheckboxPeer = new LWCheckboxPeer(checkbox, platformComponent);
        LWToolkit.targetCreatedPeer(checkbox, lWCheckboxPeer);
        lWCheckboxPeer.initialize();
        return lWCheckboxPeer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWChoicePeer lWChoicePeer = new LWChoicePeer(choice, platformComponent);
        LWToolkit.targetCreatedPeer(choice, lWChoicePeer);
        lWChoicePeer.initialize();
        return lWChoicePeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWLabelPeer lWLabelPeer = new LWLabelPeer(label, platformComponent);
        LWToolkit.targetCreatedPeer(label, lWLabelPeer);
        lWLabelPeer.initialize();
        return lWLabelPeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCanvasPeer lWCanvasPeer = new LWCanvasPeer(canvas, platformComponent);
        LWToolkit.targetCreatedPeer(canvas, lWCanvasPeer);
        lWCanvasPeer.initialize();
        return lWCanvasPeer;
    }

    @Override
    public ListPeer createList(List list) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWListPeer lWListPeer = new LWListPeer(list, platformComponent);
        LWToolkit.targetCreatedPeer(list, lWListPeer);
        lWListPeer.initialize();
        return lWListPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWPanelPeer lWPanelPeer = new LWPanelPeer(panel, platformComponent);
        LWToolkit.targetCreatedPeer(panel, lWPanelPeer);
        lWPanelPeer.initialize();
        return lWPanelPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollPanePeer lWScrollPanePeer = new LWScrollPanePeer(scrollPane, platformComponent);
        LWToolkit.targetCreatedPeer(scrollPane, lWScrollPanePeer);
        lWScrollPanePeer.initialize();
        return lWScrollPanePeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollBarPeer lWScrollBarPeer = new LWScrollBarPeer(scrollbar, platformComponent);
        LWToolkit.targetCreatedPeer(scrollbar, lWScrollBarPeer);
        lWScrollBarPeer.initialize();
        return lWScrollBarPeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextAreaPeer lWTextAreaPeer = new LWTextAreaPeer(textArea, platformComponent);
        LWToolkit.targetCreatedPeer(textArea, lWTextAreaPeer);
        lWTextAreaPeer.initialize();
        return lWTextAreaPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextFieldPeer lWTextFieldPeer = new LWTextFieldPeer(textField, platformComponent);
        LWToolkit.targetCreatedPeer(textField, lWTextFieldPeer);
        lWTextFieldPeer.initialize();
        return lWTextFieldPeer;
    }

    @Override
    public ColorModel getColorModel() throws HeadlessException {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    @Override
    public boolean isDesktopSupported() {
        return true;
    }

    @Override
    protected DesktopPeer createDesktopPeer(Desktop desktop) {
        return new CDesktopPeer();
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        CDragSourceContextPeer cDragSourceContextPeer = CDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
        return cDragSourceContextPeer;
    }

    @Override
    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) {
        return LWKeyboardFocusManagerPeer.getInstance(keyboardFocusManager);
    }

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (this.mouseInfoPeer == null) {
            this.mouseInfoPeer = this.createMouseInfoPeerImpl();
        }
        return this.mouseInfoPeer;
    }

    protected MouseInfoPeer createMouseInfoPeerImpl() {
        return new LWMouseInfoPeer();
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isTraySupported() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) {
        throw new RuntimeException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        LWToolkit lWToolkit = this;
        synchronized (lWToolkit) {
            if (this.clipboard == null) {
                this.clipboard = this.createPlatformClipboard();
            }
        }
        return this.clipboard;
    }

    public abstract Clipboard createPlatformClipboard();

    protected abstract PlatformWindow createPlatformWindow(LWWindowPeer.PeerType var1);

    protected abstract PlatformComponent createPlatformComponent();

    protected abstract FileDialogPeer createFileDialogPeer(FileDialog var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public abstract LWCursorManager getCursorManager();

    public static void postEvent(AWTEvent aWTEvent) {
        LWToolkit.postEvent(LWToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    @Override
    public boolean needUpdateWindow() {
        return true;
    }

    @Override
    public void grab(Window window) {
        if (window.getPeer() != null) {
            ((LWWindowPeer)window.getPeer()).grab();
        }
    }

    @Override
    public void ungrab(Window window) {
        if (window.getPeer() != null) {
            ((LWWindowPeer)window.getPeer()).ungrab(false);
        }
    }
}

