/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class KqueueArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short EVFILT_READ = -1;
    static final short EVFILT_WRITE = -2;
    static final short EV_ADD = 1;
    static final short EV_DELETE = 2;
    static final short EV_ERROR = 16384;
    static final int SIZE_KEVENT = KqueueArrayWrapper.keventSize();
    static final Integer ZERO_MASK = new Integer(0);
    static final int capacityIncr = 100;
    private HashMap<Integer, Integer> updateMap = new HashMap();
    private int[] oldMasks = new int[100];
    private AllocatedNativeObject pollKeventArray;
    int pollKeventSize = 200;
    int nextKeventSize;
    int kqfd;
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    KqueueArrayWrapper() {
        int n = this.pollKeventSize * SIZE_KEVENT;
        this.pollKeventArray = new AllocatedNativeObject(n, true);
        this.kqfd = KqueueArrayWrapper.kqueue();
    }

    void ensureFd(int n) {
        this.ensureNextEventFd(n);
        if (this.oldMasks.length < n + 1) {
            this.oldMasks = Arrays.copyOf(this.oldMasks, n + 100);
        }
    }

    void ensureNextEventFd(int n) {
        if (this.nextKeventSize / 2 < n + 1) {
            this.nextKeventSize = (n + 1) * 2;
        }
    }

    void resizeEventBuffer() {
        if (this.nextKeventSize > this.pollKeventSize) {
            this.pollKeventArray.free();
            this.pollKeventSize = this.nextKeventSize + 200;
            int n = this.pollKeventSize * SIZE_KEVENT;
            this.pollKeventArray = new AllocatedNativeObject(n, true);
        }
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.ensureFd(n);
        KqueueArrayWrapper.register(this.kqfd, n, (short)-1);
    }

    int getReventOps(int n) {
        short s = KqueueArrayWrapper.getKeventFilter(this.pollKeventArray.address(), n);
        short s2 = KqueueArrayWrapper.getKeventFlags(this.pollKeventArray.address(), n);
        if ((s2 & 0x4000) != 0) {
            return 8;
        }
        if (s == -1) {
            return 1;
        }
        if (s == -2) {
            return 4;
        }
        return 0;
    }

    int getDescriptor(int n) {
        return KqueueArrayWrapper.getKeventIdent(this.pollKeventArray.address(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("file handle less than 0");
        }
        HashMap<Integer, Integer> hashMap = this.updateMap;
        synchronized (hashMap) {
            this.ensureFd(n);
            this.updateMap.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        HashMap<Integer, Integer> hashMap = this.updateMap;
        synchronized (hashMap) {
            this.updateMap.put(new Integer(n), ZERO_MASK);
        }
    }

    void closeKqueueFD() throws IOException {
        FileDispatcher.closeIntFD(this.kqfd);
        this.pollKeventArray.free();
    }

    int poll(long l) {
        int n = this.updateRegistrations();
        this.updated = KqueueArrayWrapper.kevent(this.kqfd, this.pollKeventArray.address(), n, this.pollKeventArray.address(), this.pollKeventSize, l);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateRegistrations() {
        int n = 0;
        HashMap<Integer, Integer> hashMap = this.updateMap;
        synchronized (hashMap) {
            this.resizeEventBuffer();
            Set<Integer> set = this.updateMap.keySet();
            long l = this.pollKeventArray.address();
            for (Integer n2 : set) {
                Integer n3 = this.updateMap.get(n2);
                int n4 = this.oldMasks[n2];
                if ((n4 & 1) != 0) {
                    if ((n3 & 1) == 0) {
                        KqueueArrayWrapper.putKevent(l, n, n2, (short)2, (short)-1);
                        ++n;
                    }
                } else if ((n3 & 1) != 0) {
                    KqueueArrayWrapper.putKevent(l, n, n2, (short)1, (short)-1);
                    ++n;
                }
                if ((n4 & 4) != 0) {
                    if ((n3 & 4) == 0) {
                        KqueueArrayWrapper.putKevent(l, n, n2, (short)2, (short)-2);
                        ++n;
                    }
                } else if ((n3 & 4) != 0) {
                    KqueueArrayWrapper.putKevent(l, n, n2, (short)1, (short)-2);
                    ++n;
                }
                this.oldMasks[n2.intValue()] = n3;
            }
            this.updateMap.clear();
        }
        return n;
    }

    public void interrupt() {
        KqueueArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private static native int kqueue();

    private static native void register(int var0, int var1, short var2);

    private static native int kevent(int var0, long var1, int var3, long var4, int var6, long var7);

    private static native int keventSize();

    private static native void interrupt(int var0);

    private static native void putKevent(long var0, int var2, int var3, short var4, short var5);

    private static native short getKeventFilter(long var0, int var2);

    private static native short getKeventFlags(long var0, int var2);

    private static native int getKeventIdent(long var0, int var2);
}

