/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

public class XSelection {
    private static final Hashtable<XAtom, XSelection> table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    private static long SELECTION_TIMEOUT;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private final XClipboard clipboard;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private static long lastRequestServerTime;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private volatile XAtom targetsPropertyAtom;
    private static volatile Set targetsPropertyAtoms;
    private volatile boolean isSelectionNotifyProcessed;
    private long convertSelectionTime;

    static XSelection getSelection(XAtom xAtom) {
        return table.get(xAtom);
    }

    public XSelection(XAtom xAtom, XClipboard xClipboard) {
        if (xAtom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = xAtom;
        this.clipboard = xClipboard;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    void initializeSelectionForTrackingChanges() {
        this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selectionAtom.getName());
        if (targetsPropertyAtoms == null) {
            targetsPropertyAtoms = Collections.synchronizedSet(new HashSet(2));
        }
        targetsPropertyAtoms.add(this.targetsPropertyAtom.getAtom());
        this.isSelectionNotifyProcessed = true;
    }

    void deinitializeSelectionForTrackingChanges() {
        if (targetsPropertyAtoms != null && this.targetsPropertyAtom != null) {
            targetsPropertyAtoms.remove(this.targetsPropertyAtom.getAtom());
        }
        this.isSelectionNotifyProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setOwner(Transferable transferable, Map map, long[] lArray, long l) {
        block5: {
            boolean bl;
            long l2 = XWindow.getXAWTRootWindow().getWindow();
            long l3 = this.selectionAtom.getAtom();
            if (l == 0L) {
                l = XToolkit.getCurrentServerTime();
            }
            this.contents = transferable;
            this.formatMap = map;
            this.formats = lArray;
            this.appContext = AppContext.getAppContext();
            this.ownershipTime = l;
            XToolkit.awtLock();
            try {
                XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), l3, l2, l);
                if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), l3) == l2) break block5;
                this.reset();
                bl = false;
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return bl;
        }
        this.isOwner = true;
        if (this.clipboard != null) {
            this.clipboard.checkChangeHere(transferable);
        }
        boolean bl = true;
        Object var12_10 = null;
        XToolkit.awtUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSelectionNotify(WindowPropertyGetter windowPropertyGetter) throws InterruptedException {
        long l = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.awtLockWait(250L);
                if (propertyGetter != windowPropertyGetter) break;
            } while (System.currentTimeMillis() < l + SELECTION_TIMEOUT);
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long[] getTargets(long l) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] lArray = null;
        Object object = lock;
        synchronized (object) {
            SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
            try {
                XToolkit.awtLock();
                propertyGetter = windowPropertyGetter;
                lastRequestServerTime = l;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l);
                try {
                    try {
                        XSelection.waitForSelectionNotify(windowPropertyGetter);
                    }
                    catch (InterruptedException interruptedException) {
                        long[] lArray2 = new long[]{};
                        {
                            Object var9_6 = null;
                            propertyGetter = null;
                        }
                        Object var11_10 = null;
                        XToolkit.awtUnlock();
                        Object var13_13 = null;
                        windowPropertyGetter.dispose();
                        return lArray2;
                    }
                    {
                        Object var9_5 = null;
                        propertyGetter = null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        Object var9_7 = null;
                        propertyGetter = null;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var11_12 = null;
                        XToolkit.awtUnlock();
                        throw throwable2;
                    }
                }
                Object var11_11 = null;
                XToolkit.awtUnlock();
                lArray = XSelection.getFormats(windowPropertyGetter);
                Object var13_14 = null;
                windowPropertyGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                windowPropertyGetter.dispose();
                throw throwable;
            }
        }
        return lArray;
    }

    private static long[] getFormats(WindowPropertyGetter windowPropertyGetter) {
        int n;
        long[] lArray = null;
        if (windowPropertyGetter.isExecuted() && !windowPropertyGetter.isDisposed() && (windowPropertyGetter.getActualType() == 4L || windowPropertyGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && windowPropertyGetter.getActualFormat() == 32 && (n = windowPropertyGetter.getNumberOfItems()) > 0) {
            long l = windowPropertyGetter.getData();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Native.getLong(l + (long)(i * XAtom.getAtomSize()));
            }
        }
        return lArray != null ? lArray : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTargetsDelayed() {
        XToolkit.awtLock();
        try {
            long l = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || l >= this.convertSelectionTime + SELECTION_TIMEOUT) {
                this.convertSelectionTime = l;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.targetsPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * Exception decompiling
     */
    public byte[] getData(long var1_1, long var3_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isOwner() {
        return this.isOwner;
    }

    public void lostOwnership() {
        this.isOwner = false;
        if (this.clipboard != null) {
            this.clipboard.run();
        }
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long l, long l2, long l3) {
        int n = 8;
        byte[] byArray = null;
        long l4 = 0L;
        int n2 = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byArray = DataTransferer.getInstance().convertData(this, this.contents, l2, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        n2 = byArray.length;
        try {
            if (n2 > 0) {
                if (n2 <= MAX_PROPERTY_SIZE) {
                    l4 = Native.toData(byArray);
                } else {
                    new IncrementalDataProvider(l, l3, l2, 8, byArray);
                    l4 = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(l4, n2);
                    l2 = XDataTransferer.INCR_ATOM.getAtom();
                    n = 32;
                    n2 = 1;
                }
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, l3, l2, n, 0, l4, n2);
                Object var14_9 = null;
            }
            catch (Throwable throwable) {
                Object var14_10 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var16_12 = null;
            if (l4 != 0L) {
                XlibWrapper.unsafe.freeMemory(l4);
                l4 = 0L;
            }
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            if (l4 != 0L) {
                XlibWrapper.unsafe.freeMemory(l4);
                l4 = 0L;
            }
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleSelectionRequest(XSelectionRequestEvent var1_1) {
        var2_2 = var1_1.get_property();
        var4_3 = var1_1.get_requestor();
        var6_4 = var1_1.get_time();
        var8_5 = var1_1.get_target();
        var10_6 = 0;
        var11_7 = false;
        if (this.ownershipTime != 0L && (var6_4 == 0L || var6_4 >= this.ownershipTime)) {
            var2_2 = var1_1.get_property();
            if (var8_5 == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                if (var2_2 != 0L) {
                    var12_8 = new WindowPropertyGetter(var4_3, XAtom.get(var2_2), 0L, 1000000L, false, 0L);
                    try {
                        var12_8.execute();
                        if (var12_8.getActualFormat() == 32 && var12_8.getNumberOfItems() % 2 == 0) {
                            var13_11 = var12_8.getNumberOfItems() / 2;
                            var15_12 = var12_8.getData();
                            var17_14 = false;
                            var18_15 = 0;
                            while ((long)var18_15 < var13_11) {
                                var19_16 = Native.getLong(var15_12, 2 * var18_15);
                                if (!this.convertAndStore(var4_3, var19_16, var21_17 = Native.getLong(var15_12, 2 * var18_15 + 1))) {
                                    Native.putLong(var15_12, 2 * var18_15, 0L);
                                    var17_14 = true;
                                }
                                ++var18_15;
                            }
                            if (var17_14) {
                                XToolkit.awtLock();
                                try {
                                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var12_8.getActualType(), var12_8.getActualFormat(), 0, var12_8.getData(), var12_8.getNumberOfItems());
                                    var24_18 = null;
                                }
                                catch (Throwable var23_20) {
                                    var24_19 = null;
                                    XToolkit.awtUnlock();
                                    throw var23_20;
                                }
                                XToolkit.awtUnlock();
                                {
                                }
                            }
                            var11_7 = true;
                        }
                        var26_21 = null;
                        var12_8.dispose();
                    }
                    catch (Throwable var25_23) {
                        var26_22 = null;
                        var12_8.dispose();
                        throw var25_23;
                    }
                }
            } else {
                if (var2_2 == 0L) {
                    var2_2 = var8_5;
                }
                if (var8_5 == XDataTransferer.TARGETS_ATOM.getAtom()) {
                    var12_9 = 0L;
                    var14_24 = 0;
                    var10_6 = 32;
                    var15_13 = this.formats;
                    if (var15_13 == null) {
                        throw new IllegalStateException("Not an owner.");
                    }
                    var14_24 = var15_13.length;
                    try {
                        if (var14_24 > 0) {
                            var12_9 = Native.allocateLongArray(var14_24);
                            Native.put(var12_9, var15_13);
                        }
                        var11_7 = true;
                        XToolkit.awtLock();
                        try {
                            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var8_5, var10_6, 0, var12_9, var14_24);
                            var28_25 = null;
                        }
                        catch (Throwable var27_27) {
                            var28_26 = null;
                            XToolkit.awtUnlock();
                            throw var27_27;
                        }
                        XToolkit.awtUnlock();
                        var30_28 = null;
                        if (var12_9 == 0L) ** GOTO lbl91
                        XlibWrapper.unsafe.freeMemory(var12_9);
                        var12_9 = 0L;
                    }
                    catch (Throwable var29_30) {
                        var30_29 = null;
                        if (var12_9 != 0L) {
                            XlibWrapper.unsafe.freeMemory(var12_9);
                            var12_9 = 0L;
                        }
                        throw var29_30;
                    }
                } else {
                    var11_7 = this.convertAndStore(var4_3, var8_5, var2_2);
                }
            }
        }
lbl91:
        // 7 sources

        if (!var11_7) {
            var2_2 = 0L;
        }
        var12_10 = new XSelectionEvent();
        try {
            var12_10.set_type(31);
            var12_10.set_send_event(true);
            var12_10.set_requestor(var4_3);
            var12_10.set_selection(this.selectionAtom.getAtom());
            var12_10.set_target(var8_5);
            var12_10.set_property(var2_2);
            var12_10.set_time(var6_4);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), var4_3, false, 0L, var12_10.pData);
                var32_31 = null;
            }
            catch (Throwable var31_33) {
                var32_32 = null;
                XToolkit.awtUnlock();
                throw var31_33;
            }
            XToolkit.awtUnlock();
            var34_34 = null;
            var12_10.dispose();
        }
        catch (Throwable var33_36) {
            var34_35 = null;
            var12_10.dispose();
            throw var33_36;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkChange(XSelectionEvent xSelectionEvent) {
        Object object;
        if (targetsPropertyAtoms == null || targetsPropertyAtoms.isEmpty()) {
            return;
        }
        long l = xSelectionEvent.get_property();
        long[] lArray = null;
        if (l == 0L) {
            lArray = new long[]{};
        } else {
            if (!targetsPropertyAtoms.contains(l)) {
                return;
            }
            object = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(l), 0L, 1000000L, true, 0L);
            try {
                ((WindowPropertyGetter)object).execute();
                lArray = XSelection.getFormats((WindowPropertyGetter)object);
                Object var6_4 = null;
                ((WindowPropertyGetter)object).dispose();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                ((WindowPropertyGetter)object).dispose();
                throw throwable;
            }
        }
        object = XAtom.get(xSelectionEvent.get_selection());
        XSelection xSelection = XSelection.getSelection((XAtom)object);
        if (xSelection != null) {
            xSelection.isSelectionNotifyProcessed = true;
            if (xSelection.clipboard != null) {
                xSelection.clipboard.checkChange(lArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        XToolkit.awtLock();
        try {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
            Object var1 = null;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_state() != 0 || xPropertyEvent.get_atom() != selectionPropertyAtom.getAtom()) break;
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.awtLockNotifyAll();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
            }
        }
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long l, long l2, long l3, int n, byte[] byArray) {
            if (n != 8) {
                throw new IllegalArgumentException("Unsupported format: " + n);
            }
            this.requestor = l;
            this.property = l2;
            this.target = l3;
            this.format = n;
            this.data = byArray;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XToolkit.awtLock();
                try {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, xWindowAttributes.get_your_event_mask() | 0x400000L);
                    Object var11_7 = null;
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
                XToolkit.awtUnlock();
                Object var13_10 = null;
                xWindowAttributes.dispose();
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                xWindowAttributes.dispose();
                throw throwable;
            }
            XToolkit.addEventDispatcher(l, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_window() != this.requestor || xPropertyEvent.get_state() != 1 || xPropertyEvent.get_atom() != this.property) break;
                    int n = this.data.length - this.offset;
                    long l = 0L;
                    if (n > MAX_PROPERTY_SIZE) {
                        n = MAX_PROPERTY_SIZE;
                    }
                    if (n > 0) {
                        l = XlibWrapper.unsafe.allocateMemory(n);
                        for (int i = 0; i < n; ++i) {
                            Native.putByte(l + (long)i, this.data[this.offset + i]);
                        }
                    } else {
                        assert (n == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, l, n);
                        Object var8_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    if (l != 0L) {
                        XlibWrapper.unsafe.freeMemory(l);
                        l = 0L;
                    }
                    this.offset += n;
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 31: {
                    XSelectionEvent xSelectionEvent = xEvent.get_xselection();
                    XSelection.checkChange(xSelectionEvent);
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null && xSelectionEvent.get_time() == lastRequestServerTime) {
                            if (xSelectionEvent.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xSelectionEvent.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.awtLockNotifyAll();
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
                case 30: {
                    XSelectionRequestEvent xSelectionRequestEvent = xEvent.get_xselectionrequest();
                    long l = xSelectionRequestEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection == null) break;
                    xSelection.handleSelectionRequest(xSelectionRequestEvent);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xSelectionClearEvent = xEvent.get_xselectionclear();
                    long l = xSelectionClearEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection != null) {
                        xSelection.lostOwnership();
                    }
                    XToolkit.awtLock();
                    try {
                        XToolkit.awtLockNotifyAll();
                        Object var7_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
            }
        }
    }
}

