/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import sun.swing.SwingUtilities2;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), UIManager.get("InternalFrame.activeTitleGradient") != null ? null : MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.get("InternalFrame.inactiveTitleGradient") != null ? null : MetalLookAndFeel.getControl());
    MetalBumps paletteBumps;
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateOptionPaneState();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.wasClosable = this.frame.isClosable();
        this.selectedBackgroundKey = null;
        this.selectedForegroundKey = null;
        if (MetalLookAndFeel.usingOcean()) {
            this.setOpaque(true);
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.wasClosable != this.frame.isClosable()) {
            this.frame.setClosable(this.wasClosable);
        }
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        Boolean bl = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", bl);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton.putClientProperty("paintActive", bl);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("paintActive", bl);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
        if (MetalLookAndFeel.usingOcean()) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    @Override
    protected void assembleSystemMenu() {
    }

    @Override
    protected void addSystemMenuItems(JMenu jMenu) {
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    public void paintPalette(Graphics graphics) {
        boolean bl = MetalUtils.isLeftToRight(this.frame);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        int n3 = bl ? 4 : this.buttonsWidth + 4;
        int n4 = n - this.buttonsWidth - 8;
        int n5 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n4, n5);
        this.paletteBumps.paintIcon(this, graphics, n3, 2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        MetalBumps metalBumps;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = MetalUtils.isLeftToRight(this.frame);
        boolean bl2 = this.frame.isSelected();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (bl2) {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(true);
                this.maxButton.setContentAreaFilled(true);
                this.iconButton.setContentAreaFilled(true);
            }
            if (this.selectedBackgroundKey != null) {
                color = UIManager.getColor(this.selectedBackgroundKey);
            }
            if (color == null) {
                color = MetalLookAndFeel.getWindowTitleBackground();
            }
            if (this.selectedForegroundKey != null) {
                color2 = UIManager.getColor(this.selectedForegroundKey);
            }
            if (this.selectedShadowKey != null) {
                color3 = UIManager.getColor(this.selectedShadowKey);
            }
            if (color3 == null) {
                color3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            }
            if (color2 == null) {
                color2 = MetalLookAndFeel.getWindowTitleForeground();
            }
            this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, UIManager.get("InternalFrame.activeTitleGradient") != null ? null : color);
            metalBumps = this.activeBumps;
            string = "InternalFrame.activeTitleGradient";
        } else {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(false);
                this.maxButton.setContentAreaFilled(false);
                this.iconButton.setContentAreaFilled(false);
            }
            color = MetalLookAndFeel.getWindowTitleInactiveBackground();
            color2 = MetalLookAndFeel.getWindowTitleInactiveForeground();
            color3 = MetalLookAndFeel.getControlDarkShadow();
            metalBumps = this.inactiveBumps;
            string = "InternalFrame.inactiveTitleGradient";
        }
        if (!MetalUtils.drawGradient(this, graphics, string, 0, 0, n5, n6, true)) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n5, n6);
        }
        graphics.setColor(color3);
        graphics.drawLine(0, n6 - 1, n5, n6 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
        int n7 = 0;
        int n8 = bl ? 5 : n5 - 5;
        String string2 = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n8 -= icon.getIconWidth();
            }
            n4 = n6 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n8, n4);
            n8 += bl ? icon.getIconWidth() + 5 : -5;
        }
        if (string2 != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.frame, graphics, font);
            n3 = fontMetrics.getHeight();
            graphics.setColor(color2);
            n2 = (n6 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int n9 = rectangle.x - n8 - 4;
                string2 = this.getTitle(string2, fontMetrics, n9);
            } else {
                int n10 = n8 - rectangle.x - rectangle.width - 4;
                string2 = this.getTitle(string2, fontMetrics, n10);
                n8 -= SwingUtilities2.stringWidth(this.frame, fontMetrics, string2);
            }
            n7 = SwingUtilities2.stringWidth(this.frame, fontMetrics, string2);
            SwingUtilities2.drawString((JComponent)this.frame, graphics, string2, n8, n2);
            n8 += bl ? n7 + 5 : -5;
        }
        if (bl) {
            n = n5 - this.buttonsWidth - n8 - 5;
            n4 = n8;
        } else {
            n = n8 - this.buttonsWidth - 5;
            n4 = this.buttonsWidth + 5;
        }
        n3 = 3;
        n2 = this.getHeight() - 2 * n3;
        metalBumps.setBumpArea(n, n2);
        metalBumps.paintIcon(this, graphics, n4, n3);
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void updateOptionPaneState() {
        int n = -2;
        boolean bl = this.wasClosable;
        Object object = this.frame.getClientProperty("JInternalFrame.messageType");
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        switch (n) {
            case 0: {
                this.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                bl = false;
                break;
            }
            case 3: {
                this.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                bl = false;
                break;
            }
            case 2: {
                this.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                bl = false;
                break;
            }
            case -1: 
            case 1: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
                bl = false;
                break;
            }
            default: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
            }
        }
        if (bl != this.frame.isClosable()) {
            this.frame.setClosable(bl);
        }
    }

    class MetalTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MetalTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 16 + (MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = MetalInternalFrameTitlePane.this.frame.getFontMetrics(MetalInternalFrameTitlePane.this.getFont());
            String string = MetalInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fontMetrics, string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n4 < (n = SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fontMetrics, MetalInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n4 : n) : (n3 += n4);
            n = 0;
            if (MetalInternalFrameTitlePane.this.isPalette) {
                n = MetalInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int n6 = fontMetrics.getHeight();
                n6 += 7;
                Icon icon = MetalInternalFrameTitlePane.this.frame.getFrameIcon();
                int n7 = 0;
                if (icon != null) {
                    n7 = Math.min(icon.getIconHeight(), 16);
                }
                n = Math.max(n6, n7 += 5);
            }
            return new Dimension(n3, n);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            boolean bl = MetalUtils.isLeftToRight(MetalInternalFrameTitlePane.this.frame);
            int n2 = MetalInternalFrameTitlePane.this.getWidth();
            int n3 = bl ? n2 : 0;
            int n4 = 2;
            int n5 = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int n6 = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                if (MetalInternalFrameTitlePane.this.isPalette) {
                    n = 3;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(n3 += bl ? -n - (n6 + 2) : n, n4, n6 + 2, MetalInternalFrameTitlePane.this.getHeight() - 4);
                    if (!bl) {
                        n3 += n6 + 2;
                    }
                } else {
                    n = 4;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                    if (!bl) {
                        n3 += n6;
                    }
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable() && !MetalInternalFrameTitlePane.this.isPalette) {
                n = MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                MetalInternalFrameTitlePane.this.maxButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable() && !MetalInternalFrameTitlePane.this.isPalette) {
                n = MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                MetalInternalFrameTitlePane.this.iconButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            MetalInternalFrameTitlePane.this.buttonsWidth = bl ? n2 - n3 : n3;
        }
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MetalInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", bl);
                MetalInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", bl);
                MetalInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", bl);
            } else if ("JInternalFrame.messageType".equals(string)) {
                MetalInternalFrameTitlePane.this.updateOptionPaneState();
                MetalInternalFrameTitlePane.this.frame.repaint();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

