/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    private static MBeanServer platformMBeanServer;
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return sun.management.ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return sun.management.ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return sun.management.ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return sun.management.ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return sun.management.ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return sun.management.ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return sun.management.ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return sun.management.ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return sun.management.ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer getPlatformMBeanServer() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanServerPermission mBeanServerPermission = new MBeanServerPermission("createMBeanServer");
            securityManager.checkPermission(mBeanServerPermission);
        }
        if (platformMBeanServer == null) {
            platformMBeanServer = sun.management.ManagementFactory.createPlatformMBeanServer();
        }
        return platformMBeanServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        final Class<T> clazz2 = clazz;
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz2.getClassLoader();
            }
        });
        if (classLoader != null) {
            throw new IllegalArgumentException(string + " is not a platform MXBean");
        }
        try {
            ObjectName objectName = new ObjectName(string);
            if (!mBeanServerConnection.isInstanceOf(objectName, clazz2.getName())) {
                throw new IllegalArgumentException(string + " is not an instance of " + clazz2);
            }
            boolean bl = mBeanServerConnection.isInstanceOf(objectName, NOTIF_EMITTER);
            return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, bl);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " not found in the connection.");
            illegalArgumentException.initCause(instanceNotFoundException);
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " is not a valid ObjectName format.");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }
}

