/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.Stub;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.client.sei.AsyncMethodHandler;
import com.sun.xml.internal.ws.client.sei.CallbackMethodHandler;
import com.sun.xml.internal.ws.client.sei.MethodHandler;
import com.sun.xml.internal.ws.client.sei.PollingMethodHandler;
import com.sun.xml.internal.ws.client.sei.SyncMethodHandler;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public final class SEIStub
extends Stub
implements InvocationHandler {
    public final SOAPSEIModel seiModel;
    public final SOAPVersion soapVersion;
    private final Map<Method, MethodHandler> methodHandlers = new HashMap<Method, MethodHandler>();

    public SEIStub(WSServiceDelegate owner, BindingImpl binding, SOAPSEIModel seiModel, Tube master, WSEndpointReference epr) {
        super(owner, master, binding, seiModel.getPort(), seiModel.getPort().getAddress(), epr);
        this.seiModel = seiModel;
        this.soapVersion = binding.getSOAPVersion();
        HashMap<WSDLBoundOperation, JavaMethodImpl> syncs = new HashMap<WSDLBoundOperation, JavaMethodImpl>();
        for (JavaMethodImpl m : seiModel.getJavaMethods()) {
            if (m.getMEP().isAsync) continue;
            SyncMethodHandler handler = new SyncMethodHandler(this, m);
            syncs.put(m.getOperation(), m);
            this.methodHandlers.put(m.getMethod(), handler);
        }
        for (JavaMethodImpl jm : seiModel.getJavaMethods()) {
            AsyncMethodHandler handler;
            Method m;
            JavaMethodImpl sync = (JavaMethodImpl)syncs.get(jm.getOperation());
            if (jm.getMEP() == MEP.ASYNC_CALLBACK) {
                m = jm.getMethod();
                handler = new CallbackMethodHandler(this, jm, sync, m.getParameterTypes().length - 1);
                this.methodHandlers.put(m, handler);
            }
            if (jm.getMEP() != MEP.ASYNC_POLL) continue;
            m = jm.getMethod();
            handler = new PollingMethodHandler(this, jm, sync);
            this.methodHandlers.put(m, handler);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandler handler = this.methodHandlers.get(method);
        if (handler != null) {
            return handler.invoke(proxy, args);
        }
        try {
            return method.invoke(this, args);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final Packet doProcess(Packet request, RequestContext rc, ResponseContextReceiver receiver) {
        return super.process(request, rc, receiver);
    }

    public final void doProcessAsync(Packet request, RequestContext rc, Fiber.CompletionCallback callback) {
        super.processAsync(request, rc, callback);
    }

    @NotNull
    protected final QName getPortName() {
        return this.wsdlPort.getName();
    }

    public void setOutboundHeaders(Object ... headers) {
        if (headers == null) {
            throw new IllegalArgumentException();
        }
        Header[] hl = new Header[headers.length];
        for (int i = 0; i < hl.length; ++i) {
            if (headers[i] == null) {
                throw new IllegalArgumentException();
            }
            hl[i] = Headers.create(this.seiModel.getJAXBContext(), headers[i]);
        }
        super.setOutboundHeaders(hl);
    }
}

