/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Packet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class WsaPropertyBag
extends PropertySet {
    @NotNull
    private final AddressingVersion addressingVersion;
    @NotNull
    private final SOAPVersion soapVersion;
    @NotNull
    private final Packet packet;
    private static final PropertySet.PropertyMap model = WsaPropertyBag.parse(WsaPropertyBag.class);

    WsaPropertyBag(AddressingVersion addressingVersion, SOAPVersion soapVersion, Packet packet) {
        this.addressingVersion = addressingVersion;
        this.soapVersion = soapVersion;
        this.packet = packet;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.addressing.to"})
    public String getTo() throws XMLStreamException {
        Header h = this.packet.getMessage().getHeaders().get(this.addressingVersion.toTag, false);
        if (h == null) {
            return null;
        }
        return h.getStringContent();
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.addressing.from"})
    public WSEndpointReference getFrom() throws XMLStreamException {
        return this.getEPR(this.addressingVersion.fromTag);
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.addressing.action"})
    public String getAction() {
        Header h = this.packet.getMessage().getHeaders().get(this.addressingVersion.actionTag, false);
        if (h == null) {
            return null;
        }
        return h.getStringContent();
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.addressing.messageId", "com.sun.xml.internal.ws.addressing.request.messageID"})
    public String getMessageID() {
        return this.packet.getMessage().getHeaders().getMessageID(this.addressingVersion, this.soapVersion);
    }

    private WSEndpointReference getEPR(QName tag) throws XMLStreamException {
        Header h = this.packet.getMessage().getHeaders().get(tag, false);
        if (h == null) {
            return null;
        }
        return h.readAsEPR(this.addressingVersion);
    }

    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

